/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javolution.util.FastCollection;
import javolution.util.function.Consumer;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.service.CollectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionView<E>
extends FastCollection<E>
implements CollectionService<E> {
    private static final long serialVersionUID = 1536L;
    private CollectionService<E> target;

    public CollectionView(CollectionService<E> target) {
        this.target = target;
    }

    @Override
    public abstract boolean add(E var1);

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public CollectionView<E> clone() {
        try {
            CollectionView copy = (CollectionView)super.clone();
            if (this.target != null) {
                copy.target = this.target.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Should not happen since target is cloneable");
        }
    }

    @Override
    public abstract Equality<? super E> comparator();

    @Override
    public boolean contains(Object obj) {
        Iterator<E> it = this.iterator();
        Equality<E> cmp = this.comparator();
        while (it.hasNext()) {
            if (!cmp.equal(obj, it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this instanceof Set) {
            if (!(o instanceof Set)) {
                return false;
            }
            Set set = (Set)o;
            return this.size() == set.size() && this.containsAll(set);
        }
        if (this instanceof List) {
            if (!(o instanceof List)) {
                return false;
            }
            List list = (List)o;
            if (this.size() != list.size()) {
                return false;
            }
            Equality<Object> cmp = Equalities.STANDARD;
            Iterator<E> it1 = this.iterator();
            Iterator it2 = list.iterator();
            while (it1.hasNext()) {
                if (!it2.hasNext()) {
                    return false;
                }
                if (cmp.equal(it1.next(), it2.next())) continue;
                return false;
            }
            return !it2.hasNext();
        }
        return false;
    }

    @Override
    public int hashCode() {
        Equality<Object> cmp = Equalities.STANDARD;
        Iterator<E> it = this.iterator();
        int hash = 0;
        if (this instanceof Set) {
            while (it.hasNext()) {
                hash += cmp.hashOf(it.next());
            }
        } else if (this instanceof List) {
            while (it.hasNext()) {
                hash += 31 * hash + cmp.hashOf(it.next());
            }
        } else {
            hash = super.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public void perform(Consumer<CollectionService<E>> action, CollectionService<E> view) {
        if (this.target == null) {
            action.accept(view);
        } else {
            this.target.perform(action, view);
        }
    }

    @Override
    public boolean remove(Object obj) {
        Iterator<E> it = this.iterator();
        Equality<E> cmp = this.comparator();
        while (it.hasNext()) {
            if (!cmp.equal(obj, it.next())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public CollectionService<E>[] split(int n, boolean updateable) {
        return new CollectionService[]{this};
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] result = size <= a.length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        int i = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            result[i++] = it.next();
        }
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    @Override
    public void update(Consumer<CollectionService<E>> action, CollectionService<E> view) {
        if (this.target == null) {
            action.accept(view);
        } else {
            this.target.perform(action, view);
        }
    }

    @Override
    protected CollectionService<E> service() {
        return this;
    }

    protected CollectionService<E> target() {
        return this.target;
    }
}

