/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.util.function.Equality;
import javolution.util.function.Predicate;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;
    protected final Predicate<? super E> filter;

    public FilteredCollectionImpl(CollectionService<E> target, Predicate<? super E> filter) {
        super(target);
        this.filter = filter;
    }

    @Override
    public boolean add(E element) {
        if (!this.filter.test(element)) {
            return false;
        }
        return this.target().add(element);
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object o) {
        if (!this.filter.test(o)) {
            return false;
        }
        return this.target().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl(this.filter);
    }

    @Override
    public boolean remove(Object o) {
        if (!this.filter.test(o)) {
            return false;
        }
        return this.target().remove(o);
    }

    @Override
    public CollectionService<E>[] split(int n, boolean updateable) {
        CollectionService[] subTargets = (CollectionService[])this.target().split(n, updateable);
        CollectionService[] result = new CollectionService[subTargets.length];
        for (int i = 0; i < subTargets.length; ++i) {
            result[i] = new FilteredCollectionImpl<E>(subTargets[i], this.filter);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<E> {
        private boolean ahead;
        private final Predicate<? super E> filter;
        private E next;
        private final Iterator<E> targetIterator;

        public IteratorImpl(Predicate<? super E> filter) {
            this.filter = filter;
            this.targetIterator = FilteredCollectionImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.ahead) {
                return true;
            }
            while (this.targetIterator.hasNext()) {
                this.next = this.targetIterator.next();
                if (!this.filter.test(this.next)) continue;
                this.ahead = true;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            this.hasNext();
            this.ahead = false;
            return this.next;
        }

        @Override
        public void remove() {
            this.targetIterator.remove();
        }
    }
}

