/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.context.ConcurrentContext;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;

    public ParallelCollectionImpl(CollectionService<E> target) {
        super(target);
    }

    @Override
    public boolean add(E e) {
        return this.target().add(e);
    }

    @Override
    public void clear() {
        this.target().clear();
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.target().contains(obj);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.target().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(final Consumer<CollectionService<E>> action, CollectionService<E> view) {
        ConcurrentContext ctx = ConcurrentContext.enter();
        try {
            int concurrency = ctx.getConcurrency();
            CollectionService[] subViews = (CollectionService[])view.split(concurrency + 1, false);
            for (int i = 1; i < subViews.length; ++i) {
                final CollectionService subView = subViews[i];
                ctx.execute(new Runnable(){

                    public void run() {
                        ParallelCollectionImpl.this.target().perform(action, subView);
                    }
                });
            }
            this.target().perform(action, subViews[0]);
        }
        finally {
            ctx.exit();
        }
    }

    @Override
    public boolean remove(Object obj) {
        return this.target().remove(obj);
    }

    @Override
    public int size() {
        return this.target().size();
    }

    @Override
    public CollectionService<E>[] split(int n, boolean threadsafe) {
        return (CollectionService[])this.target().split(n, threadsafe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(final Consumer<CollectionService<E>> action, CollectionService<E> view) {
        ConcurrentContext ctx = ConcurrentContext.enter();
        try {
            int concurrency = ctx.getConcurrency();
            CollectionService[] subViews = (CollectionService[])view.split(concurrency + 1, true);
            for (int i = 1; i < subViews.length; ++i) {
                final CollectionService subView = subViews[i];
                ctx.execute(new Runnable(){

                    public void run() {
                        ParallelCollectionImpl.this.target().update(action, subView);
                    }
                });
            }
            this.target().perform(action, subViews[0]);
        }
        finally {
            ctx.exit();
        }
    }
}

