/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReversedCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;

    public ReversedCollectionImpl(CollectionService<E> target) {
        super(target);
    }

    @Override
    public boolean add(E e) {
        return this.target().add(e);
    }

    @Override
    public void clear() {
        this.target().clear();
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.target().contains(obj);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public boolean remove(Object obj) {
        return this.target().remove(obj);
    }

    @Override
    public int size() {
        return this.target().size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<E> {
        private final E[] elements;
        private int index;

        public IteratorImpl() {
            this.elements = new Object[ReversedCollectionImpl.this.size()];
            this.index = 0;
            Iterator it = ReversedCollectionImpl.this.target().iterator();
            while (it.hasNext() && this.index < this.elements.length) {
                this.elements[this.index++] = it.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index > 0;
        }

        @Override
        public E next() {
            return this.elements[--this.index];
        }

        @Override
        public void remove() {
            ReversedCollectionImpl.this.target().remove(this.elements[this.index]);
        }
    }
}

