/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.comparator;

import javolution.util.function.Equality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalCaseInsensitiveComparatorImpl
implements Equality<CharSequence> {
    private static final long serialVersionUID = 1536L;

    private static char up(char c) {
        return Character.toUpperCase(c);
    }

    @Override
    public boolean equal(CharSequence csq1, CharSequence csq2) {
        if (csq1 == csq2) {
            return true;
        }
        if (csq1 == null || csq2 == null) {
            return false;
        }
        if (csq1 instanceof String && csq2 instanceof String) {
            return ((String)csq1).equalsIgnoreCase((String)csq2);
        }
        int n = csq1.length();
        if (csq2.length() != n) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (LexicalCaseInsensitiveComparatorImpl.up(csq1.charAt(i)) == LexicalCaseInsensitiveComparatorImpl.up(csq2.charAt(i++))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(CharSequence left, CharSequence right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).compareToIgnoreCase((String)right);
        }
        int i = 0;
        int n = Math.min(left.length(), right.length());
        while (n-- != 0) {
            char c2;
            char c1 = LexicalCaseInsensitiveComparatorImpl.up(left.charAt(i));
            if (c1 == (c2 = LexicalCaseInsensitiveComparatorImpl.up(right.charAt(i++)))) continue;
            return c1 - c2;
        }
        return left.length() - right.length();
    }

    @Override
    public int hashOf(CharSequence csq) {
        if (csq == null) {
            return 0;
        }
        int h = 0;
        int i = 0;
        int n = csq.length();
        while (i < n) {
            h = 31 * h + LexicalCaseInsensitiveComparatorImpl.up(csq.charAt(i++));
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LexicalCaseInsensitiveComparatorImpl;
    }

    public int hashCode() {
        return LexicalCaseInsensitiveComparatorImpl.class.hashCode();
    }
}

