/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import java.io.Serializable;
import java.util.Map;
import javolution.util.function.Equality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryComparatorImpl<K, V>
implements Equality<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1536L;
    public final Equality<? super K> keyComparator;
    public final Equality<? super V> valueComparator;

    public EntryComparatorImpl(Equality<? super K> keyComparator, Equality<? super V> valueComparator) {
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
    }

    @Override
    public boolean equal(Map.Entry<K, V> left, Map.Entry<K, V> right) {
        return this.keyComparator.equal(left.getKey(), right.getKey()) && this.valueComparator.equal(left.getValue(), right.getValue());
    }

    @Override
    public int compare(Map.Entry<K, V> left, Map.Entry<K, V> right) {
        int cmp = this.keyComparator.compare(left.getKey(), right.getKey());
        if (cmp != 0) {
            return cmp;
        }
        return this.valueComparator.compare(left.getValue(), right.getValue());
    }

    @Override
    public int hashOf(Map.Entry<K, V> e) {
        return this.keyComparator.hashOf(e.getKey()) ^ this.valueComparator.hashOf(e.getValue());
    }
}

