/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import java.util.Iterator;
import java.util.Map;
import javolution.context.ConcurrentContext;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.internal.map.MapView;
import javolution.util.service.MapService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelMapImpl<K, V>
extends MapView<K, V> {
    private static final long serialVersionUID = 1536L;

    public ParallelMapImpl(MapService<K, V> target) {
        super(target);
    }

    @Override
    public void clear() {
        this.target().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.target().containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.target().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.target().iterator();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.target().keyComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(final Consumer<MapService<K, V>> action, MapService<K, V> view) {
        ConcurrentContext ctx = ConcurrentContext.enter();
        try {
            int concurrency = ctx.getConcurrency();
            MapService[] subViews = (MapService[])view.split(concurrency + 1, false);
            for (int i = 1; i < subViews.length; ++i) {
                final MapService subView = subViews[i];
                ctx.execute(new Runnable(){

                    public void run() {
                        ParallelMapImpl.this.target().perform(action, subView);
                    }
                });
            }
            this.target().perform(action, subViews[0]);
        }
        finally {
            ctx.exit();
        }
    }

    @Override
    public V put(K key, V value) {
        return this.target().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.target().remove(key);
    }

    @Override
    public int size() {
        return this.target().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(final Consumer<MapService<K, V>> action, MapService<K, V> view) {
        ConcurrentContext ctx = ConcurrentContext.enter();
        try {
            int concurrency = ctx.getConcurrency();
            MapService[] subViews = (MapService[])view.split(concurrency + 1, true);
            for (int i = 1; i < subViews.length; ++i) {
                final MapService subView = subViews[i];
                ctx.execute(new Runnable(){

                    public void run() {
                        ParallelMapImpl.this.target().update(action, subView);
                    }
                });
            }
            this.target().perform(action, subViews[0]);
        }
        finally {
            ctx.exit();
        }
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.target().valueComparator();
    }

    @Override
    public MapService<K, V>[] split(int n, boolean threadsafe) {
        return (MapService[])this.target().split(n, threadsafe);
    }
}

