/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map.sorted;

import java.util.Comparator;
import java.util.Map;
import javolution.util.internal.map.MapView;
import javolution.util.internal.map.sorted.MapEntryImpl;
import javolution.util.internal.map.sorted.SubSortedMapImpl;
import javolution.util.internal.set.sorted.SubSortedSetImpl;
import javolution.util.service.SortedMapService;
import javolution.util.service.SortedSetService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SortedMapView<K, V>
extends MapView<K, V>
implements SortedMapService<K, V> {
    private static final long serialVersionUID = 1536L;

    public SortedMapView(SortedMapService<K, V> target) {
        super(target);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyComparator();
    }

    @Override
    public SortedSetService<Map.Entry<K, V>> entrySet() {
        return new EntrySortedSet();
    }

    @Override
    public abstract K firstKey();

    @Override
    public SortedMapService<K, V> headMap(K toKey) {
        return new SubSortedMapImpl(this, this.firstKey(), toKey);
    }

    @Override
    public SortedSetService<K> keySet() {
        return new KeySortedSet();
    }

    @Override
    public abstract K lastKey();

    @Override
    public SortedMapService<K, V>[] split(int n, boolean updateable) {
        return new SortedMapService[]{this};
    }

    @Override
    public SortedMapService<K, V> subMap(K fromKey, K toKey) {
        return new SubSortedMapImpl(this, fromKey, toKey);
    }

    @Override
    public SortedMapService<K, V> tailMap(K fromKey) {
        return new SubSortedMapImpl(this, fromKey, this.lastKey());
    }

    @Override
    protected SortedMapService<K, V> target() {
        return (SortedMapService)super.target();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class KeySortedSet
    extends MapView.KeySet
    implements SortedSetService<K> {
        private static final long serialVersionUID = 1536L;

        protected KeySortedSet() {
            super(SortedMapView.this);
        }

        @Override
        public K first() {
            return SortedMapView.this.firstKey();
        }

        @Override
        public SortedSetService<K> headSet(K toElement) {
            return new SubSortedSetImpl<Object>(this, null, toElement);
        }

        @Override
        public K last() {
            return SortedMapView.this.lastKey();
        }

        @Override
        public SortedSetService<K>[] split(int n, boolean updateable) {
            return new SortedSetService[]{this};
        }

        @Override
        public SortedSetService<K> subSet(K fromElement, K toElement) {
            return new SubSortedSetImpl(this, fromElement, toElement);
        }

        @Override
        public SortedSetService<K> tailSet(K fromElement) {
            return new SubSortedSetImpl<Object>(this, fromElement, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntrySortedSet
    extends MapView.EntrySet
    implements SortedSetService<Map.Entry<K, V>> {
        private static final long serialVersionUID = 1536L;

        protected EntrySortedSet() {
            super(SortedMapView.this);
        }

        @Override
        public Map.Entry<K, V> first() {
            Object key = SortedMapView.this.firstKey();
            Object value = SortedMapView.this.get(key);
            return new MapEntryImpl(key, value);
        }

        @Override
        public SortedSetService<Map.Entry<K, V>> headSet(Map.Entry<K, V> toElement) {
            return new SubSortedSetImpl(this, null, toElement);
        }

        @Override
        public Map.Entry<K, V> last() {
            Object key = SortedMapView.this.lastKey();
            Object value = SortedMapView.this.get(key);
            return new MapEntryImpl(key, value);
        }

        @Override
        public SortedSetService<Map.Entry<K, V>>[] split(int n, boolean updateable) {
            return new SortedSetService[]{this};
        }

        @Override
        public SortedSetService<Map.Entry<K, V>> subSet(Map.Entry<K, V> fromElement, Map.Entry<K, V> toElement) {
            return new SubSortedSetImpl(this, fromElement, toElement);
        }

        @Override
        public SortedSetService<Map.Entry<K, V>> tailSet(Map.Entry<K, V> fromElement) {
            return new SubSortedSetImpl<Object>(this, fromElement, null);
        }
    }
}

