/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.set.sorted;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javolution.util.function.Equality;
import javolution.util.internal.set.sorted.SortedSetView;
import javolution.util.service.SortedSetService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubSortedSetImpl<E>
extends SortedSetView<E> {
    private static final long serialVersionUID = 1536L;
    private final E from;
    private final E to;

    public SubSortedSetImpl(SortedSetService<E> target, E from, E to) {
        super(target);
        if (from != null && to != null && this.comparator().compare(from, to) > 0) {
            throw new IllegalArgumentException("from: " + from + ", to: " + to);
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean add(E e) {
        Comparator cmp = this.comparator();
        if (this.from != null && cmp.compare(e, this.from) < 0) {
            throw new IllegalArgumentException("Element: " + e + " outside of this sub-set bounds");
        }
        if (this.to != null && cmp.compare(e, this.to) >= 0) {
            throw new IllegalArgumentException("Element: " + e + " outside of this sub-set bounds");
        }
        return this.target().add(e);
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object obj) {
        Comparator cmp = this.comparator();
        if (this.from != null && cmp.compare(obj, this.from) < 0) {
            return false;
        }
        if (this.to != null && cmp.compare(obj, this.to) >= 0) {
            return false;
        }
        return this.target().contains(obj);
    }

    @Override
    public E first() {
        if (this.from == null) {
            return this.target().first();
        }
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        return it.next();
    }

    @Override
    public boolean isEmpty() {
        return this.iterator().hasNext();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public E last() {
        if (this.to == null) {
            return this.target().last();
        }
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            throw new NoSuchElementException();
        }
        E last = it.next();
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    @Override
    public boolean remove(Object obj) {
        Comparator cmp = this.comparator();
        if (this.from != null && cmp.compare(obj, this.from) < 0) {
            return false;
        }
        if (this.to != null && cmp.compare(obj, this.to) >= 0) {
            return false;
        }
        return this.target().remove(obj);
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<E> {
        private boolean ahead;
        private final Equality<? super E> cmp;
        private E next;
        private final Iterator<E> targetIterator;

        private IteratorImpl() {
            this.cmp = SubSortedSetImpl.this.comparator();
            this.targetIterator = SubSortedSetImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.ahead) {
                return true;
            }
            while (this.targetIterator.hasNext()) {
                this.next = this.targetIterator.next();
                if (SubSortedSetImpl.this.from != null && this.cmp.compare(this.next, SubSortedSetImpl.this.from) < 0) continue;
                if (SubSortedSetImpl.this.to != null && this.cmp.compare(this.next, SubSortedSetImpl.this.to) >= 0) break;
                this.ahead = true;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            this.hasNext();
            this.ahead = false;
            return this.next;
        }

        @Override
        public void remove() {
            this.targetIterator.remove();
        }
    }
}

