/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javolution.util.internal.collection.AtomicCollectionImpl;
import javolution.util.internal.table.ReversedTableImpl;
import javolution.util.internal.table.SubTableImpl;
import javolution.util.internal.table.TableIteratorImpl;
import javolution.util.service.TableService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicTableImpl<E>
extends AtomicCollectionImpl<E>
implements TableService<E> {
    private static final long serialVersionUID = 1536L;

    public AtomicTableImpl(TableService<E> target) {
        super(target);
    }

    @Override
    public synchronized void add(int index, E element) {
        this.target().add(index, element);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        boolean changed = this.target().addAll(index, c);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized void addFirst(E element) {
        this.target().addFirst(element);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public synchronized void addLast(E element) {
        this.target().addLast(element);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new ReversedTableImpl(this).iterator();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E get(int index) {
        return this.targetView().get(index);
    }

    @Override
    public E getFirst() {
        return this.targetView().getFirst();
    }

    @Override
    public E getLast() {
        return this.targetView().getLast();
    }

    @Override
    public int indexOf(Object element) {
        return this.targetView().indexOf(element);
    }

    @Override
    public ListIterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.targetView().lastIndexOf(element);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new TableIteratorImpl(this, index);
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public synchronized boolean offerFirst(E e) {
        boolean changed = this.target().offerFirst(e);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized boolean offerLast(E e) {
        boolean changed = this.target().offerLast(e);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        return this.targetView().peekFirst();
    }

    @Override
    public E peekLast() {
        return this.targetView().peekLast();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public synchronized E pollFirst() {
        Object e = this.target().pollFirst();
        if (e != null && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return e;
    }

    @Override
    public synchronized E pollLast() {
        Object e = this.target().pollLast();
        if (e != null && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return e;
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public synchronized E remove(int index) {
        Object e = this.target().remove(index);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return e;
    }

    @Override
    public synchronized E removeFirst() {
        Object e = this.target().removeFirst();
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return e;
    }

    @Override
    public synchronized boolean removeFirstOccurrence(Object o) {
        boolean changed = this.target().removeFirstOccurrence(o);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized E removeLast() {
        Object e = this.target().removeLast();
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return e;
    }

    @Override
    public synchronized boolean removeLastOccurrence(Object o) {
        boolean changed = this.target().removeLastOccurrence(o);
        if (changed && !this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return changed;
    }

    @Override
    public synchronized E set(int index, E element) {
        E e = this.target().set(index, element);
        if (!this.updateInProgress()) {
            this.immutable = this.cloneTarget();
        }
        return e;
    }

    @Override
    public TableService<E>[] split(int n, boolean updateable) {
        return SubTableImpl.splitOf(this, n, false);
    }

    @Override
    public TableService<E> subList(int fromIndex, int toIndex) {
        return new SubTableImpl(this, fromIndex, toIndex);
    }

    @Override
    protected TableService<E> target() {
        return (TableService)super.target();
    }

    @Override
    protected TableService<E> targetView() {
        return (TableService)super.targetView();
    }
}

