/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import java.util.Comparator;
import javolution.util.service.TableService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickSort<E> {
    private final Comparator<? super E> comparator;
    private final TableService<E> table;

    public QuickSort(TableService<E> table, Comparator<? super E> comparator) {
        this.table = table;
        this.comparator = comparator;
    }

    public void sort() {
        int size = this.table.size();
        if (size > 0) {
            this.quicksort(0, this.table.size() - 1);
        }
    }

    public void sort(int first, int last) {
        if (first < last) {
            int pivIndex = this.partition(first, last);
            this.sort(first, pivIndex - 1);
            this.sort(pivIndex + 1, last);
        }
    }

    void quicksort(int first, int last) {
        int pivIndex = 0;
        if (first < last) {
            pivIndex = this.partition(first, last);
            this.quicksort(first, pivIndex - 1);
            this.quicksort(pivIndex + 1, last);
        }
    }

    private int partition(int f, int l) {
        Object piv = this.table.get(f);
        int up = f;
        int down = l;
        while (true) {
            if (this.comparator.compare(this.table.get(up), piv) <= 0 && up < l) {
                ++up;
                continue;
            }
            while (this.comparator.compare(this.table.get(down), piv) > 0 && down > f) {
                --down;
            }
            if (up < down) {
                Object temp = this.table.get(up);
                this.table.set(up, this.table.get(down));
                this.table.set(down, temp);
            }
            if (down <= up) break;
        }
        this.table.set(f, this.table.get(down));
        this.table.set(down, piv);
        return down;
    }
}

