/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table;

import javolution.util.function.Equality;
import javolution.util.internal.table.SharedTableImpl;
import javolution.util.internal.table.TableView;
import javolution.util.service.TableService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTableImpl<E>
extends TableView<E> {
    private static final long serialVersionUID = 1536L;
    protected final int fromIndex;
    protected int toIndex;

    public static <E> TableService<E>[] splitOf(TableService<E> table, int n, boolean updateable) {
        if (updateable) {
            table = new SharedTableImpl<E>(table);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid argument n: " + n);
        }
        TableService[] subTables = new TableService[n];
        int minSize = table.size() / n;
        int start = 0;
        for (int i = 0; i < n - 1; ++i) {
            subTables[i] = new SubTableImpl<E>(table, start, start + minSize);
            start += minSize;
        }
        subTables[n - 1] = new SubTableImpl<E>(table, start, table.size());
        return subTables;
    }

    public SubTableImpl(TableService<E> target, int from, int to) {
        super(target);
        if (from < 0 || to > target.size() || from > to) {
            throw new IndexOutOfBoundsException("fromIndex: " + from + ", toIndex: " + to + ", size(): " + target.size());
        }
        this.fromIndex = from;
        this.toIndex = to;
    }

    @Override
    public boolean add(E element) {
        this.target().add(this.toIndex++, element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 && index > this.size()) {
            this.indexError(index);
        }
        this.target().add(index + this.fromIndex, element);
        ++this.toIndex;
    }

    @Override
    public void clear() {
        for (int i = this.toIndex - 1; i >= this.fromIndex; --i) {
            this.target().remove(i);
        }
        this.toIndex = this.fromIndex;
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public E get(int index) {
        if (index < 0 && index >= this.size()) {
            this.indexError(index);
        }
        return this.target().get(index + this.fromIndex);
    }

    @Override
    public E remove(int index) {
        if (index < 0 && index >= this.size()) {
            this.indexError(index);
        }
        --this.toIndex;
        return this.target().remove(index + this.fromIndex);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 && index >= this.size()) {
            this.indexError(index);
        }
        return this.target().set(index + this.fromIndex, element);
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }
}

