/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.table.sorted;

import java.util.Comparator;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.internal.comparator.WrapperComparatorImpl;
import javolution.util.internal.table.FastTableImpl;
import javolution.util.internal.table.sorted.SortedTableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastSortedTableImpl<E>
extends SortedTableView<E> {
    private static final long serialVersionUID = 1536L;
    private final FastTableImpl<E> table = new FastTableImpl<Object>(Equalities.STANDARD);
    private final Comparator<? super E> comparator;

    public FastSortedTableImpl(Comparator<? super E> comparator) {
        super(null);
        this.comparator = comparator;
    }

    @Override
    public void add(int index, E element) {
        this.table.add(index, element);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public Equality<? super E> comparator() {
        return this.comparator instanceof Equality ? this.comparator : new WrapperComparatorImpl<E>(this.comparator);
    }

    @Override
    public E get(int index) {
        return this.table.get(index);
    }

    @Override
    public int positionOf(E element) {
        return this.positionOf(element, 0, this.size());
    }

    private int positionOf(E element, int start, int length) {
        if (length == 0) {
            return -start - 1;
        }
        int half = length >> 1;
        int cmp = this.comparator.compare(element, this.get(start + half));
        if (cmp == 0) {
            return start + half;
        }
        if (cmp < 0) {
            return this.positionOf(element, start, half);
        }
        return this.positionOf(element, start + half + 1, length - half - 1);
    }

    @Override
    public E remove(int index) {
        return this.table.remove(index);
    }

    @Override
    public E set(int index, E element) {
        return this.table.set(index, element);
    }

    @Override
    public int size() {
        return this.table.size();
    }
}

