/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javolution.context.LogContext;
import javolution.text.CharArray;
import javolution.text.TextBuilder;
import javolution.text.TextContext;
import javolution.text.TextFormat;
import javolution.util.FastMap;
import javolution.xml.DefaultXMLFormat;
import javolution.xml.XMLContext;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLContextImpl
extends XMLContext {
    private final FastMap<Class<?>, XMLFormat<?>> classToFormat = new FastMap().shared();
    private final XMLContextImpl parent;
    private static final XMLFormat<Object> OBJECT_XML = new XMLFormat<Object>(){

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public Object newInstance(Class<?> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            TextFormat<?> format = TextContext.getFormat(cls);
            CharArray value = xml.getAttribute("value");
            if (value == null) {
                throw new XMLStreamException("Missing value attribute to parse " + cls + " instances.");
            }
            return format.parse(value);
        }

        @Override
        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        @Override
        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            TextBuilder tmp = new TextBuilder();
            TextFormat<?> tf = TextContext.getFormat(obj.getClass());
            tf.format(obj, tmp);
            xml.setAttribute("value", tmp);
        }
    };
    private static final XMLFormat<Collection> COLLECTION_XML = new XMLFormat<Collection>(){

        @Override
        public void read(XMLFormat.InputElement xml, Collection collection) throws XMLStreamException {
            while (xml.hasNext()) {
                collection.add(xml.getNext());
            }
        }

        @Override
        public void write(Collection collection, XMLFormat.OutputElement xml) throws XMLStreamException {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                xml.add(i.next());
            }
        }
    };
    private static final XMLFormat<Map> MAP_XML = new XMLFormat<Map>(){

        @Override
        public void read(XMLFormat.InputElement xml, Map map) throws XMLStreamException {
            while (xml.hasNext()) {
                Object key = xml.get("Key");
                Object value = xml.get("Value");
                map.put(key, value);
            }
        }

        @Override
        public void write(Map map, XMLFormat.OutputElement xml) throws XMLStreamException {
            for (Map.Entry entry : map.entrySet()) {
                xml.add(entry.getKey(), "Key");
                xml.add(entry.getValue(), "Value");
            }
        }
    };

    public XMLContextImpl() {
        this.parent = null;
    }

    public XMLContextImpl(XMLContextImpl parent) {
        this.parent = parent;
    }

    @Override
    protected XMLContext inner() {
        return new XMLContextImpl(this);
    }

    @Override
    protected <T> XMLFormat<T> searchFormat(Class<? extends T> type) {
        XMLFormat<Object> format = this.classToFormat.get(type);
        if (format != null) {
            return format;
        }
        if (this.parent != null) {
            format = this.parent.searchFormat(type);
            this.classToFormat.put(type, format);
            return format;
        }
        DefaultXMLFormat annotation = type.getAnnotation(DefaultXMLFormat.class);
        if (annotation != null) {
            try {
                format = annotation.value().newInstance();
                this.classToFormat.put(type, format);
                return format;
            }
            catch (Throwable error) {
                LogContext.warning(error);
            }
        }
        if (Collection.class.isAssignableFrom(type)) {
            this.classToFormat.put(type, COLLECTION_XML);
            return COLLECTION_XML;
        }
        if (Map.class.isAssignableFrom(type)) {
            this.classToFormat.put(type, MAP_XML);
            return MAP_XML;
        }
        this.classToFormat.put(type, OBJECT_XML);
        return OBJECT_XML;
    }

    @Override
    public <T> void setFormat(Class<? extends T> type, XMLFormat<T> format) {
        this.classToFormat.put(type, format);
    }
}

