/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.DefaultHandler;
import javolution.xml.sax.XMLReader;
import javolution.xml.stream.XMLStreamException;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLReaderImpl
implements XMLReader {
    private static DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;
    private final XMLStreamReaderImpl _xmlReader = new XMLStreamReaderImpl();
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    private static final CharArray NO_CHAR = new CharArray("");

    public XMLReaderImpl() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
    }

    public void parse(InputStream in) throws IOException, SAXException {
        try {
            this._xmlReader.setInput(in);
            this.parseAll();
        }
        catch (XMLStreamException e) {
            if (e.getNestedException() instanceof IOException) {
                throw (IOException)e.getNestedException();
            }
            throw new SAXException(e.getMessage());
        }
        finally {
            this._xmlReader.reset();
        }
    }

    public void parse(InputStream in, String encoding) throws IOException, SAXException {
        try {
            this._xmlReader.setInput(in, encoding);
            this.parseAll();
        }
        catch (XMLStreamException e) {
            if (e.getNestedException() instanceof IOException) {
                throw (IOException)e.getNestedException();
            }
            throw new SAXException(e.getMessage());
        }
        finally {
            this._xmlReader.reset();
        }
    }

    public void parse(Reader reader) throws IOException, SAXException {
        try {
            this._xmlReader.setInput(reader);
            this.parseAll();
        }
        catch (XMLStreamException e) {
            if (e.getNestedException() instanceof IOException) {
                throw (IOException)e.getNestedException();
            }
            throw new SAXException(e.getMessage());
        }
        finally {
            this._xmlReader.reset();
        }
    }

    public void parse(InputSource input) throws IOException, SAXException {
        Reader reader = input.getCharacterStream();
        if (reader != null) {
            this.parse(reader);
        } else {
            InputStream inStream = input.getByteStream();
            if (inStream != null) {
                this.parse(inStream, input.getEncoding());
            } else {
                this.parse(input.getSystemId());
            }
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        InputStream inStream;
        try {
            URL url = new URL(systemId);
            inStream = url.openStream();
        }
        catch (Exception urlException) {
            try {
                inStream = new FileInputStream(systemId);
            }
            catch (Exception fileException) {
                throw new UnsupportedOperationException("Cannot parse " + systemId);
            }
        }
        this.parse(inStream);
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler == DEFAULT_HANDLER ? null : this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler == DEFAULT_HANDLER ? null : this._errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return true;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + name + " not recognized");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + name + " not recognized");
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void reset() {
        this.setContentHandler(DEFAULT_HANDLER);
        this.setErrorHandler(DEFAULT_HANDLER);
        this._xmlReader.reset();
    }

    private void parseAll() throws XMLStreamException, SAXException {
        int eventType = this._xmlReader.getEventType();
        if (eventType != 7) {
            throw new SAXException("Currently parsing");
        }
        this._contentHandler.startDocument();
        boolean doContinue = true;
        block9: while (doContinue) {
            switch (this._xmlReader.next()) {
                case 1: {
                    CharArray uri;
                    CharArray prefix;
                    int i;
                    int count = this._xmlReader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        prefix = this._xmlReader.getNamespacePrefix(i);
                        prefix = prefix == null ? NO_CHAR : prefix;
                        uri = this._xmlReader.getNamespaceURI(i);
                        this._contentHandler.startPrefixMapping(prefix, uri);
                    }
                    uri = this._xmlReader.getNamespaceURI();
                    uri = uri == null ? NO_CHAR : uri;
                    CharArray localName = this._xmlReader.getLocalName();
                    CharArray qName = this._xmlReader.getQName();
                    this._contentHandler.startElement(uri, localName, qName, this._xmlReader.getAttributes());
                    break;
                }
                case 2: {
                    CharArray prefix;
                    int i;
                    CharArray uri = this._xmlReader.getNamespaceURI();
                    uri = uri == null ? NO_CHAR : uri;
                    CharArray localName = this._xmlReader.getLocalName();
                    CharArray qName = this._xmlReader.getQName();
                    this._contentHandler.endElement(uri, localName, qName);
                    int count = this._xmlReader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        prefix = this._xmlReader.getNamespacePrefix(i);
                        prefix = prefix == null ? NO_CHAR : prefix;
                        this._contentHandler.endPrefixMapping(prefix);
                    }
                    continue block9;
                }
                case 4: 
                case 12: {
                    CharArray text = this._xmlReader.getText();
                    this._contentHandler.characters(text.array(), text.offset(), text.length());
                    break;
                }
                case 6: {
                    CharArray text = this._xmlReader.getText();
                    this._contentHandler.ignorableWhitespace(text.array(), text.offset(), text.length());
                    break;
                }
                case 3: {
                    this._contentHandler.processingInstruction(this._xmlReader.getPITarget(), this._xmlReader.getPIData());
                    break;
                }
                case 5: {
                    break;
                }
                case 8: {
                    doContinue = false;
                    this._xmlReader.close();
                }
            }
        }
    }
}

