/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import gnu.trove.map.hash.THashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import lucxor.NormalDensityWorkerThread;
import lucxor.PSM;
import lucxor.globals;

public class FLRClass {
    ArrayList<PSM> realPSMs = new ArrayList();
    ArrayList<PSM> decoyPSMs = new ArrayList();
    THashMap<Integer, double[]> minorMapG;
    THashMap<Integer, double[]> minorMapL;
    double[] pos;
    double[] neg;
    double[] tickMarks;
    double[] f0;
    double[] f1;
    double[] globalFDR;
    double[] localFDR;
    double[] globalFDR2;
    double[] localFDR2;
    double maxDeltaScore = 0.0;
    double deltaScoreVar_pos;
    double deltaScoreVar_neg;
    double deltaScoreMu_pos;
    double deltaScoreMu_neg;
    double bw_real;
    double bw_decoy;
    int Nreal = 0;
    int Ndecoy = 0;
    final int NMARKS = 10001;

    FLRClass() {
    }

    public void prepArrays() {
        int i;
        this.pos = new double[this.realPSMs.size()];
        this.neg = new double[this.decoyPSMs.size()];
        for (i = 0; i < this.realPSMs.size(); ++i) {
            this.pos[i] = this.realPSMs.get((int)i).deltaScore;
        }
        for (i = 0; i < this.decoyPSMs.size(); ++i) {
            this.neg[i] = this.decoyPSMs.get((int)i).deltaScore;
        }
        this.Nreal = this.pos.length;
        this.Ndecoy = this.neg.length;
    }

    public void initializeTickMarks() {
        this.maxDeltaScore *= 1.001;
        this.tickMarks = new double[10001];
        for (int i = 0; i < 10001; ++i) {
            double x;
            this.tickMarks[i] = x = (double)i * this.maxDeltaScore / 10001.0;
        }
        this.localFDR = new double[this.Nreal];
        this.globalFDR = new double[this.Nreal];
        this.localFDR2 = new double[this.Nreal];
        this.globalFDR2 = new double[this.Nreal];
        this.calcDeltaScoreMean();
        this.calcDeltaScoreVar();
        this.getBandWidth(0);
        this.getBandWidth(1);
        System.err.print("FLR bandwidth (pos): " + globals.round_dbl(this.bw_real, 6) + "\n" + "FLR bandwidth (neg): " + globals.round_dbl(this.bw_decoy, 6) + "\n");
    }

    private void getBandWidth(int dataType) {
        double sigma = 0.0;
        double N = 0.0;
        double result = 0.0;
        double x = 0.0;
        if (dataType == 1) {
            sigma = Math.sqrt(this.deltaScoreVar_pos);
            N = this.realPSMs.size();
            x = Math.pow(N, 0.2);
            this.bw_real = result = 1.06 * (sigma / x);
        }
        if (dataType == 0) {
            sigma = Math.sqrt(this.deltaScoreVar_neg);
            N = this.decoyPSMs.size();
            x = Math.pow(N, 0.2);
            this.bw_decoy = result = 1.06 * (sigma / x);
        }
    }

    private void calcDeltaScoreMean() {
        double sum = 0.0;
        double N = 0.0;
        for (double d : this.pos) {
            sum += d;
        }
        N = this.pos.length;
        this.deltaScoreMu_pos = sum / N;
        sum = 0.0;
        for (double d : this.neg) {
            sum += d;
        }
        N = this.neg.length;
        this.deltaScoreMu_neg = sum / N;
    }

    private void calcDeltaScoreVar() {
        double v = 0.0;
        double N = 0.0;
        double x = 0.0;
        for (double d : this.pos) {
            x = d - this.deltaScoreMu_pos;
            v += Math.pow(x, 2.0);
        }
        N = (double)this.pos.length - 1.0;
        this.deltaScoreVar_pos = v / N;
        v = 0.0;
        for (double d : this.neg) {
            x = d - this.deltaScoreMu_neg;
            v += Math.pow(x, 2.0);
        }
        N = (double)this.neg.length - 1.0;
        this.deltaScoreVar_neg = v / N;
    }

    void evalTickMarks(int dataType) throws InterruptedException, ExecutionException {
        double kernelResult = 0.0;
        double[] dataAry = null;
        double[] res = null;
        double bw = 0.0;
        double N = 0.0;
        if (dataType == 0) {
            dataAry = this.neg;
            bw = this.bw_decoy;
            N = this.Ndecoy;
            res = new double[10001];
            this.f0 = new double[10001];
        }
        if (dataType == 1) {
            dataAry = this.pos;
            bw = this.bw_real;
            N = this.Nreal;
            res = new double[10001];
            this.f1 = new double[10001];
        }
        int block = dataAry.length / globals.numThreads;
        for (int i = 0; i < 10001; ++i) {
            double tic = this.tickMarks[i];
            ExecutorService pool = Executors.newFixedThreadPool(globals.numThreads);
            ArrayList<Future<Double>> taskList = new ArrayList<Future<Double>>(globals.numThreads);
            for (int cpu = 0; cpu < globals.numThreads; ++cpu) {
                int n = cpu * block;
                int end = n + block;
                if (cpu == globals.numThreads - 1) {
                    end = dataAry.length;
                }
                double[] subAry = Arrays.copyOfRange(dataAry, n, end);
                NormalDensityWorkerThread C = new NormalDensityWorkerThread(subAry, tic, bw);
                Future<Double> task = pool.submit(C);
                taskList.add(task);
                subAry = null;
            }
            kernelResult = 0.0;
            for (Future future : taskList) {
                kernelResult += ((Double)future.get()).doubleValue();
            }
            res[i] = (kernelResult /= N * bw) > 1.0E-10 ? kernelResult : 1.0E-10;
            pool.shutdown();
        }
        if (dataType == 0) {
            this.f0 = res;
        }
        if (dataType == 1) {
            this.f1 = res;
        }
    }

    void calcBothFDRs() {
        double AUC_rev_0 = 0.0;
        double AUC_rev_1 = 0.0;
        double ratio = 0.0;
        double Nreal2 = this.Nreal;
        double Ndecoy2 = this.Ndecoy;
        int i = 0;
        for (double tmp_score : this.pos) {
            if (tmp_score < 0.1) {
                tmp_score = 0.1;
            }
            ratio = 0.0;
            AUC_rev_0 = this.getGlobalAUC(tmp_score, 0);
            AUC_rev_1 = this.getGlobalAUC(tmp_score, 1);
            this.globalFDR[i] = ratio = Ndecoy2 / Nreal2 * (AUC_rev_0 / AUC_rev_1);
            ratio = 0.0;
            AUC_rev_0 = this.getLocalAUC(tmp_score, 0);
            AUC_rev_1 = this.getLocalAUC(tmp_score, 1);
            this.localFDR[i] = ratio = Ndecoy2 / Nreal2 * (AUC_rev_0 / AUC_rev_1);
            ++i;
        }
    }

    private double getLocalAUC(double x, int whichF) {
        int i;
        int j;
        double result = 0.0;
        double a = 0.0;
        double b = 0.0;
        double sum = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double fx = 0.0;
        double start_tick = this.tickMarks[0];
        double end_tick = this.tickMarks[10000];
        double start_val = 0.0;
        double end_val = 0.0;
        if (whichF == 0) {
            start_val = this.f0[0];
            end_val = this.f0[10000];
            for (j = 10000; j >= 1; --j) {
                i = j - 1;
                a = this.tickMarks[i];
                b = this.tickMarks[j];
                if (!(x >= a)) continue;
                tmp1 = (b - x) / (b - a);
                tmp2 = (x - a) / (b - a);
                fx = tmp1 * this.f0[i] + tmp2 * this.f0[j];
                sum += fx;
                break;
            }
            if (x <= start_tick) {
                sum = start_val;
            } else if (x >= end_tick) {
                sum = end_val;
            }
            result = sum;
        }
        if (whichF == 1) {
            start_val = this.f1[0];
            end_val = this.f1[10000];
            for (j = 10000; j >= 1; --j) {
                i = j - 1;
                a = this.tickMarks[i];
                b = this.tickMarks[j];
                if (!(x >= a)) continue;
                tmp1 = (b - x) / (b - a);
                tmp2 = (x - a) / (b - a);
                fx = tmp1 * this.f1[i] + tmp2 * this.f1[j];
                sum += fx;
                break;
            }
            if (x <= start_tick) {
                sum = start_val;
            } else if (x >= end_tick) {
                sum = end_val;
            }
            result = sum;
        }
        return result;
    }

    private double getGlobalAUC(double x, int whichF) {
        int i;
        int j;
        double a = 0.0;
        double b = 0.0;
        double sum = 0.0;
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double fx = 0.0;
        if (whichF == 0) {
            sum = 0.0;
            for (j = 10000; j >= 1; --j) {
                i = j - 1;
                a = this.tickMarks[i];
                b = this.tickMarks[j];
                if (x < a) {
                    sum += (b - a) * (0.5 * (this.f0[j] + this.f0[i]));
                    continue;
                }
                tmp1 = (b - x) / (b - a);
                tmp2 = (x - a) / (b - a);
                fx = tmp1 * this.f0[i] + tmp2 * this.f0[j];
                sum += (b - x) * (0.5 * (fx + this.f0[j]));
                break;
            }
        }
        if (whichF == 1) {
            sum = 0.0;
            for (j = 10000; j >= 1; --j) {
                i = j - 1;
                a = this.tickMarks[i];
                b = this.tickMarks[j];
                if (x < a) {
                    sum += (b - a) * (0.5 * (this.f1[j] + this.f1[i]));
                    continue;
                }
                tmp1 = (b - x) / (b - a);
                tmp2 = (x - a) / (b - a);
                fx = tmp1 * this.f1[i] + tmp2 * this.f1[j];
                sum += (b - x) * (0.5 * (fx + this.f1[j]));
                break;
            }
        }
        return sum;
    }

    public void setMinorMaps() {
        ArrayList<Double> scoreList = new ArrayList<Double>();
        HashMap<Double, double[]> localMap = new HashMap<Double, double[]>();
        double[] FDRary = null;
        double ds = 0.0;
        double FDR = 0.0;
        int i = 0;
        for (int iter = 0; iter < 2; ++iter) {
            if (iter == 0) {
                FDRary = this.globalFDR;
                this.minorMapG = new THashMap();
            } else {
                FDRary = this.localFDR;
                this.minorMapL = new THashMap();
            }
            localMap.clear();
            scoreList.clear();
            i = 0;
            for (i = 0; i < this.Nreal; ++i) {
                ds = this.pos[i];
                FDR = FDRary[i];
                scoreList.add(ds);
                double[] X = new double[]{ds, FDR};
                localMap.put(ds, X);
            }
            Collections.sort(scoreList);
            i = 0;
            Iterator iterator = scoreList.iterator();
            while (iterator.hasNext()) {
                double L = (Double)iterator.next();
                double[] pair = (double[])localMap.get(L);
                if (iter == 0) {
                    this.minorMapG.put(i, pair);
                } else {
                    this.minorMapL.put(i, pair);
                }
                ++i;
            }
        }
    }

    public void performMinorization() {
        double[] deqPtr = null;
        THashMap<Integer, double[]> mapPtr = null;
        for (int iter = 0; iter < 2; ++iter) {
            double f_expect;
            int i;
            if (iter == 0) {
                deqPtr = this.globalFDR;
                mapPtr = this.minorMapG;
            } else {
                deqPtr = this.localFDR;
                mapPtr = this.minorMapL;
            }
            int N = mapPtr.size();
            double[] x = new double[N];
            double[] f = new double[N];
            double[] fcopy = new double[N];
            double[] forig = new double[N];
            boolean[] isMinorPoint = new boolean[N];
            for (i = 0; i < N; ++i) {
                double[] M = mapPtr.get(i);
                x[i] = M[0];
                f[i] = M[1];
                forig[i] = f[i];
                fcopy[i] = 0.0;
                isMinorPoint[i] = false;
            }
            int minId = 0;
            double minVal = f[0];
            for (i = 1; i < N; ++i) {
                if (!(f[i] < minVal)) continue;
                minVal = f[i];
                minId = i;
            }
            double slope = (0.0 - minVal) / (this.maxDeltaScore * 1.1 - x[minId]);
            for (i = minId; i < N; ++i) {
                f[i] = minVal + slope * (x[i] - x[minId]);
            }
            int maxId = 0;
            double maxVal = f[0];
            i = 1;
            while (x[i] < x[N - 1] / 2.0) {
                if (f[i] >= maxVal) {
                    maxVal = f[i];
                    maxId = i;
                }
                ++i;
            }
            slope = maxVal / (x[maxId] - x[N - 1]);
            for (i = maxId - 1; i >= 0; --i) {
                f[i] = maxVal - slope * (x[maxId] - x[i]);
            }
            for (i = 0; i < maxId; ++i) {
                isMinorPoint[i] = true;
            }
            int curStart = maxId;
            int curEnd = maxId + 1;
            while (x[curStart] >= x[curEnd]) {
                ++curEnd;
            }
            while (curStart < N - 1) {
                slope = (f[curEnd] - f[curStart]) / (x[curEnd] - x[curStart]);
                if (slope > 0.0) {
                    ++curEnd;
                    continue;
                }
                slope = (f[curEnd] - f[curStart]) / (x[curEnd] - x[curStart]);
                boolean cont = true;
                for (i = curStart + 1; cont && i < N && i < curEnd; ++i) {
                    f_expect = f[curStart] + slope * (x[i] - x[curStart]);
                    cont = !(f_expect > f[i]);
                }
                if (cont) {
                    isMinorPoint[curEnd] = true;
                    curStart = curEnd;
                    curEnd = curStart + 1;
                    continue;
                }
                ++curEnd;
            }
            isMinorPoint[N - 1] = true;
            for (i = 0; i < N; ++i) {
                fcopy[i] = f[i];
            }
            curStart = 0;
            curEnd = curStart + 1;
            while (!isMinorPoint[curEnd]) {
                ++curEnd;
            }
            while (curStart < N - 1 && curEnd < N) {
                slope = (fcopy[curEnd] - fcopy[curStart]) / (x[curEnd] - x[curStart]);
                for (i = curStart + 1; i < curEnd; ++i) {
                    f_expect = fcopy[curStart] + slope * (x[i] - x[curStart]);
                    if (!(fcopy[i] > f_expect)) continue;
                    f[i] = f_expect;
                }
                curStart = curEnd;
                if ((curEnd = curStart + 1) >= N) {
                    curEnd = N - 1;
                }
                while (!isMinorPoint[curEnd] && curEnd < N) {
                    ++curEnd;
                }
            }
            block15: for (i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    if (this.pos[i] != x[j]) continue;
                    deqPtr[i] = f[j];
                    continue block15;
                }
            }
            if (iter == 0) {
                this.globalFDR = deqPtr;
                continue;
            }
            this.localFDR = deqPtr;
        }
    }

    public void assignFDRs() {
        int i;
        int N = this.realPSMs.size();
        for (i = 0; i < N; ++i) {
            double g_FDR = this.globalFDR[i] > 1.0 ? 1.0 : this.globalFDR[i];
            double l_FDR = this.localFDR[i] > 1.0 ? 1.0 : this.localFDR[i];
            this.realPSMs.get((int)i).globalFDR = g_FDR;
            this.realPSMs.get((int)i).localFDR = l_FDR;
        }
        block1: for (i = 0; i < N; ++i) {
            PSM realPSM = this.realPSMs.get(i);
            for (PSM p : globals.PSM_list) {
                if (!p.specId.equalsIgnoreCase(realPSM.specId)) continue;
                p.globalFDR = realPSM.globalFDR;
                p.localFDR = realPSM.localFDR;
                continue block1;
            }
        }
        for (PSM p : globals.PSM_list) {
            if (p.isDecoy) {
                p.globalFDR = Double.NaN;
                p.localFDR = Double.NaN;
                continue;
            }
            if (!(p.deltaScore <= 0.1)) continue;
            p.globalFDR = 1.0;
            p.localFDR = 1.0;
        }
    }

    private double normalDensity(double curTickMark, double curScore, double h) {
        double result = 0.0;
        double x = (curTickMark - curScore) / h;
        double term1 = 1.0 / Math.sqrt(Math.PI * 2);
        double term2 = -0.5 * x * x;
        result = term1 * Math.exp(term2);
        return result;
    }

    void debugFLR() {
        try {
            File f = new File("debug_flr_tickMarks.tsv");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("index\ttickMark\tf0\tf1\n");
            for (int i = 0; i < 10001; ++i) {
                String line = Integer.toString(i) + "\t" + Double.toString(this.tickMarks[i]) + "\t" + Double.toString(this.f0[i]) + "\t" + Double.toString(this.f1[i]) + "\n";
                bw.write(line);
            }
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FLRClass.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

