/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import javax.xml.parsers.ParserConfigurationException;
import lucxor.ModelData_CID;
import lucxor.ModelData_HCD;
import lucxor.ModelParameterWorkerThread;
import lucxor.PSM;
import lucxor.PeakClass;
import lucxor.PepXML;
import lucxor.ScoringWorkerThread;
import lucxor.globals;
import org.xml.sax.SAXException;
import umich.ms.fileio.exceptions.FileParsingException;

public class LucXor {
    private static long startTime;
    private static long endTime;
    private static long elapsedTime;

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, IllegalStateException, DataFormatException, CloneNotSupportedException, InterruptedException, ExecutionException, FileParsingException {
        String releaseVersion = "1.2014Oct10";
        System.err.print("\nluciphor2 (JAVA-based version of Luciphor)\nVersion: " + releaseVersion + "\n" + "Original C++ version available at: http://luciphor.sf.net\n\n");
        if (args.length < 1) {
            System.err.print("USAGE: java -jar luciphor2.jar <input_file>\n\n");
            System.err.print("\tGenerate a luciphor2 input file with: java -jar luciphor2.jar -t\n");
            System.err.print("\tModify the input file to suit your needs and submit it to the program.\n");
            System.err.print("\tExample: java -jar luciphor2.jar input_file_you_edited\n\n");
            System.exit(0);
        }
        if (args[0].equalsIgnoreCase("-t")) {
            globals.writeTemplateInputFile();
        }
        startTime = System.nanoTime();
        globals.initialize();
        globals.parse_input_file(args[0]);
        globals.loadUserMods();
        if (globals.inputType == 0) {
            LucXor.parse_pepXML();
        } else {
            LucXor.parse_TSV_src();
        }
        globals.read_in_spectra();
        if (globals.scoringAlgorithm == 0) {
            LucXor.runCIDcode();
        }
        if (globals.scoringAlgorithm == 1) {
            LucXor.runHCDcode();
        }
        LucXor.writeResults();
        endTime = System.nanoTime();
        LucXor.reportElapsedTime();
    }

    private static void reportElapsedTime() {
        elapsedTime = endTime - startTime;
        long milliseconds = TimeUnit.NANOSECONDS.toMillis(elapsedTime);
        int ss = (int)(milliseconds / 1000L) % 60;
        int mm = (int)(milliseconds / 60000L % 60L);
        int hh = (int)(milliseconds / 3600000L % 24L);
        System.err.println("\nTotal run time (HH:MM:SS) = " + String.format("%02d", hh) + ":" + String.format("%02d", mm) + ":" + String.format("%02d", ss) + "\n");
    }

    private static void parse_pepXML() throws ParserConfigurationException, SAXException, IOException {
        System.err.println("\nReading PSMs from pepXML file: " + globals.inputFile.getAbsolutePath());
        PepXML p = new PepXML(globals.inputFile);
        System.err.println(globals.PSM_list.size() + " Candidate PSMs read in.");
    }

    private static void parse_TSV_src() throws FileNotFoundException, IOException {
        String line;
        System.err.println("\nReading PSM from TSV file: " + globals.inputFile.getAbsolutePath());
        PSM curPSM = null;
        if (!globals.inputFile.exists()) {
            System.err.println("ERROR: Unable to find " + globals.inputFile.getAbsolutePath());
            System.exit(0);
        }
        BufferedReader br = new BufferedReader(new FileReader(globals.inputFile));
        boolean passedHdr = false;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (globals.tsvHdr == 1 && !passedHdr) {
                passedHdr = true;
                continue;
            }
            String[] vars = line.split("\t");
            curPSM = new PSM();
            curPSM.srcFile = vars[0];
            curPSM.scanNum = Integer.valueOf(vars[1]);
            curPSM.charge = Integer.valueOf(vars[2]);
            curPSM.PSMscore = Double.valueOf(vars[3]);
            curPSM.origPep.peptide = vars[4].toUpperCase();
            if (vars.length < 6) {
                curPSM = null;
                continue;
            }
            for (String modSites : vars[5].split(",")) {
                String[] ary = modSites.split("=");
                int pos = Integer.valueOf(ary[0]);
                double mass = Double.valueOf(ary[1]);
                curPSM.modCoordMap.put(pos, mass);
            }
            int numBadChars = 0;
            for (int i = 0; i < vars[4].length(); ++i) {
                String c = Character.toString(vars[4].charAt(i));
                if ("ACDEFGHIKLMNPQRSTVWY".contains(c)) continue;
                ++numBadChars;
            }
            if (curPSM.origPep.getNumPerm() > globals.max_num_permutations) {
                numBadChars = 100;
            }
            if (numBadChars == 0) {
                curPSM.process();
                if (curPSM.isKeeper) {
                    globals.PSM_list.add(curPSM);
                }
            }
            curPSM = null;
        }
        br.close();
        System.err.println("Read in " + globals.PSM_list.size() + " PSMs");
    }

    private static void runCIDcode() throws IOException, CloneNotSupportedException, InterruptedException, ExecutionException {
        int ctr;
        int z;
        System.err.println("\nRunning in CID mode.\n");
        int NCPU = globals.numThreads;
        if (NCPU > 1) {
            if (NCPU < Runtime.getRuntime().availableProcessors()) {
                NCPU = globals.numThreads + 1;
            }
        } else {
            NCPU = 1;
        }
        globals.modelingMap_CID = new THashMap();
        int numPSM = 0;
        TIntIntHashMap chargeMap = new TIntIntHashMap();
        for (int z2 = 2; z2 <= globals.maxChargeState; ++z2) {
            chargeMap.put(z2, 0);
        }
        for (PSM p : globals.PSM_list) {
            if (!p.useForModel) continue;
            int old = 1;
            if (chargeMap.containsKey(p.charge)) {
                old = chargeMap.get(p.charge) + 1;
            }
            chargeMap.put(p.charge, old);
            ++numPSM;
        }
        TIntHashSet badZ = new TIntHashSet();
        System.err.print("PSMs for modeling:\n------------------\n");
        for (z = 2; z <= globals.maxChargeState; ++z) {
            int n = chargeMap.get(z);
            System.err.println("+" + z + ": " + n + " PSMs");
            if (n >= globals.minNumPSMsForModeling) continue;
            badZ.add(z);
        }
        System.err.print("\n");
        if (numPSM < globals.minNumPSMsForModeling || badZ.size() == chargeMap.size()) {
            System.err.println("You do not have enough PSMs with a score > " + globals.modelTH + " to accurately model the data. (Minimum number of PSMs required per charge state: " + globals.minNumPSMsForModeling + ")\n" + "Exiting now.\n");
            System.exit(0);
        }
        System.err.println("(CID) Building Parametric Models from high-scoring PSMs...");
        for (z = 2; z <= globals.maxChargeState; ++z) {
            ArrayList<PeakClass> modelingPks = new ArrayList<PeakClass>();
            if (badZ.contains(z)) continue;
            numPSM = 0;
            if (globals.numThreads == 1 || globals.debugMode != 0) {
                for (PSM p : globals.PSM_list) {
                    if (p.charge != z || !p.useForModel) continue;
                    p.generatePermutations(0);
                    p.matchAllPeaks();
                }
            } else {
                int NTHREADS = globals.numThreads;
                ExecutorService executor = Executors.newFixedThreadPool(NTHREADS);
                ctr = 1;
                for (PSM p : globals.PSM_list) {
                    if (p.charge != z || !p.useForModel) continue;
                    ModelParameterWorkerThread worker = new ModelParameterWorkerThread(p, ctr++);
                    executor.execute(worker);
                }
                executor.shutdown();
                executor.awaitTermination(120L, TimeUnit.SECONDS);
                while (!executor.isShutdown()) {
                }
            }
            for (PSM p : globals.PSM_list) {
                if (p.charge != z || !p.useForModel) continue;
                if (null != p.posPeaks && !p.posPeaks.isEmpty()) {
                    modelingPks.addAll(p.posPeaks);
                    p.posPeaks.clear();
                }
                if (null != p.negPeaks && !p.negPeaks.isEmpty()) {
                    modelingPks.addAll(p.negPeaks);
                    p.negPeaks.clear();
                }
                ++numPSM;
            }
            if (modelingPks.isEmpty()) continue;
            ModelData_CID M = new ModelData_CID(z, modelingPks);
            if (globals.debugMode == 1) {
                M.writeModelPks();
            }
            M.numPSM = numPSM;
            globals.modelingMap_CID.put(z, M);
            M = null;
            modelingPks.clear();
            modelingPks = null;
        }
        if (globals.modelingMap_CID.size() < 1) {
            System.err.println("\nInsufficient data to construct model.\nExiting now.\n");
            System.exit(0);
        }
        TIntArrayList missedChargeStates = new TIntArrayList();
        int maxObsZ = 0;
        for (int z3 = 2; z3 <= globals.maxChargeState; ++z3) {
            if (!globals.modelingMap_CID.containsKey(z3)) {
                missedChargeStates.add(z3);
                continue;
            }
            Object m = globals.modelingMap_CID.get(z3);
            ((ModelData_CID)m).calcMean();
            ((ModelData_CID)m).calcVar();
            ((ModelData_CID)m).printSummaryStats();
            ((ModelData_CID)m).clearArrays();
            globals.modelingMap_CID.put(z3, (ModelData_CID)m);
            m = null;
            if (z3 <= maxObsZ) continue;
            maxObsZ = z3;
        }
        ModelData_CID m = globals.modelingMap_CID.get(maxObsZ);
        for (int missedZ : missedChargeStates.toArray()) {
            globals.modelingMap_CID.put(missedZ, m);
        }
        m = null;
        missedChargeStates.clear();
        System.gc();
        for (int RN = 0; RN < 2; ++RN) {
            if (globals.runMode == 0) {
                if (RN == 0) {
                    System.err.println("\n[ " + RN + " ] Estimating FLR with decoys (" + NCPU + " threads)...");
                }
                if (RN == 1) {
                    System.err.println("\n[ " + RN + " ] Scoring " + globals.PSM_list.size() + " PSMs (" + NCPU + " threads)...");
                }
            } else {
                System.err.println("\nScoring " + globals.PSM_list.size() + " PSMs (" + NCPU + " threads)...");
            }
            if (globals.numThreads == 1 || globals.debugMode != 0) {
                ctr = 1;
                for (PSM p : globals.PSM_list) {
                    p.generatePermutations(RN);
                    p.scorePermutations();
                    if (globals.debugMode == 3) {
                        p.debug_writeScoredPeaks();
                    }
                    if (++ctr % 100 == 0) {
                        System.err.print(ctr + " ");
                    }
                    if (ctr % 1000 != 0) continue;
                    System.err.print("\n");
                }
            } else {
                int NTHREADS = globals.numThreads;
                ExecutorService executor = Executors.newFixedThreadPool(NTHREADS);
                int ctr2 = 1;
                for (PSM p : globals.PSM_list) {
                    ScoringWorkerThread worker = new ScoringWorkerThread(p, RN, ctr2++);
                    executor.execute(worker);
                }
                executor.shutdown();
                executor.awaitTermination(120L, TimeUnit.SECONDS);
                while (!executor.isTerminated()) {
                }
            }
            System.err.print("\n");
            if (RN == 0) {
                globals.SF.calcFLR();
                if (globals.runMode == 0) {
                    globals.recordFLRestimates();
                    globals.clearPSMs();
                } else {
                    RN = 2;
                    break;
                }
            }
            if (RN != 1) continue;
            globals.assignFLR();
        }
    }

    private static void runHCDcode() throws IOException, InterruptedException, ExecutionException {
        Iterator<ModelData_HCD> m;
        int z;
        System.err.println("\nRunning in HCD mode.\n");
        int numPSM = 0;
        int NCPU = globals.numThreads;
        if (NCPU < Runtime.getRuntime().availableProcessors()) {
            NCPU = globals.numThreads + 1;
        }
        globals.modelingMap_HCD = new THashMap();
        THashMap<Integer, Integer> chargeMap = new THashMap<Integer, Integer>();
        for (int z2 = 2; z2 <= globals.maxChargeState; ++z2) {
            chargeMap.put(z2, 0);
        }
        for (PSM p : globals.PSM_list) {
            if (!p.useForModel) continue;
            int old = 1;
            if (chargeMap.containsKey(p.charge)) {
                old = (Integer)chargeMap.get(p.charge) + 1;
            }
            chargeMap.put(p.charge, old);
            ++numPSM;
        }
        THashSet<Integer> badZ = new THashSet<Integer>();
        System.err.print("PSMs for modeling:\n------------------\n");
        for (z = 2; z <= globals.maxChargeState; ++z) {
            int n = (Integer)chargeMap.get(z);
            System.err.println("+" + z + ": " + n + " PSMs");
            if (n >= globals.minNumPSMsForModeling) continue;
            badZ.add(z);
        }
        System.err.print("\n");
        if (numPSM < globals.minNumPSMsForModeling || badZ.size() == chargeMap.size()) {
            System.err.println("You do not have enough PSMs with a score > " + globals.modelTH + " to accurately model the data. (Minimum number of PSMs required per charge state: " + globals.minNumPSMsForModeling + ")\n" + "Exiting now.\n");
            System.exit(0);
        }
        System.err.println("(HCD) Acquiring Non-Parametric Model features from high-scoring PSMs...");
        for (z = 2; z <= globals.maxChargeState; ++z) {
            ArrayList<PeakClass> modelingPks = new ArrayList<PeakClass>();
            if (badZ.contains(z)) continue;
            numPSM = 0;
            if (globals.numThreads == 1 || globals.debugMode != 0) {
                for (PSM p : globals.PSM_list) {
                    if (p.charge != z || !p.useForModel) continue;
                    p.generatePermutations(0);
                    p.matchAllPeaks();
                }
            } else {
                int NTHREADS = globals.numThreads;
                ExecutorService executor = Executors.newFixedThreadPool(NTHREADS);
                int ctr = 1;
                for (PSM p : globals.PSM_list) {
                    if (p.charge != z || !p.useForModel) continue;
                    ModelParameterWorkerThread worker = new ModelParameterWorkerThread(p, ctr++);
                    executor.execute(worker);
                }
                executor.shutdown();
                executor.awaitTermination(120L, TimeUnit.SECONDS);
                while (!executor.isShutdown()) {
                }
            }
            for (PSM p : globals.PSM_list) {
                if (p.charge != z || !p.useForModel) continue;
                if (null != p.posPeaks && !p.posPeaks.isEmpty()) {
                    modelingPks.addAll(p.posPeaks);
                    p.posPeaks.clear();
                }
                if (null != p.negPeaks && !p.negPeaks.isEmpty()) {
                    modelingPks.addAll(p.negPeaks);
                    p.negPeaks.clear();
                }
                ++numPSM;
            }
            if (modelingPks.isEmpty()) continue;
            ModelData_HCD M = new ModelData_HCD(z, modelingPks);
            M.numPSM = numPSM;
            globals.modelingMap_HCD.put(z, M);
            if (globals.debugMode == 1) {
                M.writeModelPks();
            }
            M = null;
            modelingPks = null;
        }
        if (globals.modelingMap_HCD.size() < 1) {
            System.err.println("\nInsufficient data to construct model.\nExiting now.\n");
            System.exit(0);
        }
        ArrayList<Integer> missedChargeStates = new ArrayList<Integer>();
        int maxObsZ = 0;
        for (int z3 = 2; z3 <= globals.maxChargeState; ++z3) {
            if (!globals.modelingMap_HCD.containsKey(z3)) {
                missedChargeStates.add(z3);
                continue;
            }
            m = globals.modelingMap_HCD.get(z3);
            ((ModelData_HCD)((Object)m)).calcMean();
            ((ModelData_HCD)((Object)m)).calcVar();
            ((ModelData_HCD)((Object)m)).printStats();
            ((ModelData_HCD)((Object)m)).estimateNP_intensity('b');
            ((ModelData_HCD)((Object)m)).estimateNP_intensity('y');
            ((ModelData_HCD)((Object)m)).estimateNP_intensity('n');
            ((ModelData_HCD)((Object)m)).estimateNP_posDist();
            System.err.print("\n");
            globals.modelingMap_HCD.put(z3, (ModelData_HCD)((Object)m));
            m = null;
            if (z3 <= maxObsZ) continue;
            maxObsZ = z3;
        }
        ModelData_HCD m2 = globals.modelingMap_HCD.get(maxObsZ);
        m = missedChargeStates.iterator();
        while (m.hasNext()) {
            int missedZ = (Integer)m.next();
            globals.modelingMap_HCD.put(missedZ, m2);
        }
        m2 = null;
        missedChargeStates.clear();
        if (globals.debugMode == 4) {
            for (ModelData_HCD hcd : globals.modelingMap_HCD.values()) {
                hcd.write_density_data(1);
                hcd.write_density_data(2);
            }
        }
        System.gc();
        for (int RN = 0; RN < 2; ++RN) {
            if (globals.runMode == 0) {
                if (RN == 0) {
                    System.err.println("\n[ " + RN + " ] Estimating FLR with decoys (" + NCPU + " threads)...");
                }
                if (RN == 1) {
                    System.err.println("\n[ " + RN + " ] Scoring " + globals.PSM_list.size() + " PSMs (" + NCPU + " threads)...");
                }
            } else {
                System.err.println("\nScoring " + globals.PSM_list.size() + " PSMs (" + NCPU + " threads)...");
            }
            if (globals.numThreads == 1 || globals.debugMode != 0) {
                int ctr = 1;
                for (PSM p : globals.PSM_list) {
                    p.generatePermutations(RN);
                    p.scorePermutations();
                    if (globals.debugMode == 3) {
                        p.debug_writeScoredPeaks();
                    }
                    if (++ctr % 100 == 0) {
                        System.err.print(ctr + " ");
                    }
                    if (ctr % 1000 != 0) continue;
                    System.err.print("\n");
                }
            } else {
                int NTHREADS = globals.numThreads;
                ExecutorService executor = Executors.newFixedThreadPool(NTHREADS);
                int ctr = 1;
                for (PSM p : globals.PSM_list) {
                    p.generatePermutations(RN);
                    ScoringWorkerThread worker = new ScoringWorkerThread(p, RN, ctr++);
                    executor.execute(worker);
                }
                executor.shutdown();
                executor.awaitTermination(120L, TimeUnit.SECONDS);
                while (!executor.isTerminated()) {
                }
            }
            System.err.print("\n");
            if (RN == 0) {
                globals.SF.calcFLR();
                if (globals.runMode == 0) {
                    globals.recordFLRestimates();
                    globals.clearPSMs();
                } else {
                    RN = 2;
                    break;
                }
            }
            if (RN != 1) continue;
            globals.assignFLR();
        }
    }

    private static void writeResults() throws IOException {
        if (globals.outputFile.equalsIgnoreCase("luciphor_results.tsv")) {
            globals.outputFile = "luciphor_results." + globals.timeStamp + ".tsv";
        }
        File outF = new File(globals.outputFile);
        System.err.println("\nResults written to '" + outF.getAbsoluteFile() + "'");
        File matchedPksF = null;
        FileWriter fwPks = null;
        BufferedWriter bwPks = null;
        if (globals.writeMatchedPeaks) {
            String suffixDir = outF.getParent();
            globals.matchedPkFile = suffixDir + "/luciphor_matchedPks." + globals.timeStamp + ".tsv";
            System.err.print("Matched peaks will be written to '" + globals.matchedPkFile + "'\n");
            matchedPksF = new File(globals.matchedPkFile);
            fwPks = new FileWriter(matchedPksF.getAbsoluteFile());
            bwPks = new BufferedWriter(fwPks);
            String pkHdr = "specId\tpepNum\tpredictPep\tfragmentIon\tm/z\trelIntensity\tDscore\tIscore\tscore\n";
            bwPks.write(pkHdr);
        }
        FileWriter fw = new FileWriter(outF.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        String hdr = "specId\tpeptide\tpredictedPep1\tpredictedPep2\tnumPPS\tnumRPS\t";
        switch (globals.scoringMethod) {
            case 1: {
                hdr = hdr + "MascotIonScore\t";
                break;
            }
            case 2: {
                hdr = hdr + "negLogExpect\t";
                break;
            }
            case 0: {
                hdr = hdr + "pepProphet\t";
            }
        }
        if (globals.runMode == 1) {
            hdr = hdr + "isDecoy1\tisDecoy2\t";
        }
        hdr = hdr + "deltaScore\tpep1score\tpep2score\tglobalFLR\tlocalFLR\n";
        bw.write(hdr);
        for (PSM psm : globals.PSM_list) {
            bw.write(psm.getResults());
            if (!globals.writeMatchedPeaks) continue;
            bwPks.write(psm.writeMatchedPks());
        }
        bw.close();
        if (globals.writeMatchedPeaks) {
            bwPks.close();
        }
    }
}

