/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import lucxor.PeakClass;
import lucxor.globals;

public class ModelData_CID {
    int chargeState;
    int numPSM;
    double mu_int_B;
    double mu_int_Y;
    double mu_int_U;
    double var_int_B;
    double var_int_Y;
    double var_int_U;
    double mu_dist_B;
    double mu_dist_Y;
    double mu_dist_U;
    double var_dist_B;
    double var_dist_Y;
    double var_dist_U;
    double[] b_intensity = null;
    double[] b_distance = null;
    double[] y_intensity = null;
    double[] y_distance = null;
    double[] u_intensity = null;
    double[] u_distance = null;
    final double CID_ADJUST = 0.64;

    public ModelData_CID(int z, ArrayList<PeakClass> peaks) {
        this.chargeState = z;
        this.numPSM = 0;
        int Nb = 0;
        int Ny = 0;
        int Nu = 0;
        for (PeakClass pk : peaks) {
            if (pk.matched) {
                if (pk.matchedIonStr.startsWith("b")) {
                    ++Nb;
                }
                if (!pk.matchedIonStr.startsWith("y")) continue;
                ++Ny;
                continue;
            }
            ++Nu;
        }
        this.b_intensity = new double[Nb];
        this.b_distance = new double[Nb];
        this.y_intensity = new double[Ny];
        this.y_distance = new double[Ny];
        Nb = 0;
        Ny = 0;
        for (PeakClass pk : peaks) {
            if (!pk.matched) continue;
            if (pk.matchedIonStr.startsWith("b")) {
                this.b_intensity[Nb] = pk.norm_intensity;
                this.b_distance[Nb] = pk.dist;
                ++Nb;
            }
            if (!pk.matchedIonStr.startsWith("y")) continue;
            this.y_intensity[Ny] = pk.norm_intensity;
            this.y_distance[Ny] = pk.dist;
            ++Ny;
        }
        int limitN = Nb + Ny;
        if (limitN < 50000) {
            limitN += 50000;
        }
        if (limitN > Nu) {
            limitN = Nu;
        }
        this.u_intensity = new double[limitN];
        this.u_distance = new double[limitN];
        ArrayList<PeakClass> negPks = new ArrayList<PeakClass>();
        for (PeakClass pk : peaks) {
            if (pk.matched) continue;
            negPks.add(pk);
        }
        Collections.shuffle(negPks);
        for (int i = 0; i < limitN; ++i) {
            PeakClass pk;
            pk = (PeakClass)negPks.get(i);
            this.u_intensity[i] = pk.norm_intensity;
            this.u_distance[i] = pk.dist;
        }
        negPks.clear();
        negPks = null;
    }

    public void calcMean() {
        double sum = 0.0;
        double N = this.b_intensity.length;
        for (double d : this.b_intensity) {
            sum += d;
        }
        this.mu_int_B = sum / N;
        sum = 0.0;
        N = this.y_intensity.length;
        for (double d : this.y_intensity) {
            sum += d;
        }
        this.mu_int_Y = sum / N;
        sum = 0.0;
        N = this.u_intensity.length;
        for (double d : this.u_intensity) {
            sum += d;
        }
        this.mu_int_U = sum / N;
        sum = 0.0;
        N = this.b_distance.length;
        for (double d : this.b_distance) {
            sum += d;
        }
        this.mu_dist_B = sum / N;
        sum = 0.0;
        N = this.y_distance.length;
        for (double d : this.y_distance) {
            sum += d;
        }
        this.mu_dist_Y = sum / N;
        sum = 0.0;
        N = this.u_distance.length;
        for (double d : this.u_distance) {
            sum += d;
        }
        this.mu_dist_U = 0.0;
    }

    public void calcVar() {
        double x;
        double v = 0.0;
        double N = (double)this.b_intensity.length - 1.0;
        for (double d : this.b_intensity) {
            x = d - this.mu_int_B;
            v += Math.pow(x, 2.0);
        }
        this.var_int_B = v / N;
        v = 0.0;
        N = (double)this.y_intensity.length - 1.0;
        for (double d : this.y_intensity) {
            x = d - this.mu_int_Y;
            v += Math.pow(x, 2.0);
        }
        this.var_int_Y = v / N;
        v = 0.0;
        N = (double)this.u_intensity.length - 1.0;
        for (double d : this.u_intensity) {
            x = d - this.mu_int_U;
            v += Math.pow(x, 2.0);
        }
        this.var_int_U = v / N;
        v = 0.0;
        N = (double)this.b_distance.length - 1.0;
        for (double d : this.b_distance) {
            x = d - this.mu_dist_B;
            v += Math.pow(x, 2.0);
        }
        this.var_dist_B = v / N;
        v = 0.0;
        N = (double)this.y_distance.length - 1.0;
        for (double d : this.y_distance) {
            x = d - this.mu_dist_Y;
            v += Math.pow(x, 2.0);
        }
        this.var_dist_Y = v / N;
        v = 0.0;
        N = (double)this.u_distance.length - 1.0;
        for (double d : this.u_distance) {
            x = d - this.mu_dist_U;
            v += Math.pow(x, 2.0);
        }
        this.var_dist_U = v / N;
        this.var_dist_B *= 0.64;
        this.var_dist_Y *= 0.64;
    }

    public void printSummaryStats() {
        System.err.print("+" + this.chargeState + ": " + this.numPSM + " PSMs for modeling.\n");
        System.err.print("-----------------------------------------------------\n");
        System.err.print("+" + this.chargeState + "\tb-ions Intensity (mu, sigma): (" + globals.round_dbl(this.mu_int_B, 4) + ", " + globals.round_dbl(Math.sqrt(this.var_int_B), 4) + ") N = " + this.b_intensity.length + "\n");
        System.err.print("+" + this.chargeState + "\ty-ions Intensity (mu, sigma): (" + globals.round_dbl(this.mu_int_Y, 4) + ", " + globals.round_dbl(Math.sqrt(this.var_int_Y), 4) + ") N = " + this.y_intensity.length + "\n");
        System.err.print("+" + this.chargeState + "\tNoise Intensity (mu, sigma): (" + globals.round_dbl(this.mu_int_U, 4) + ", " + globals.round_dbl(Math.sqrt(this.var_int_U), 4) + ") N = " + this.u_intensity.length + "\n\n");
        System.err.print("+" + this.chargeState + "\tb-ions m/z Accuracy (mu, sigma): (" + globals.round_dbl(this.mu_dist_B, 4) + ", " + globals.round_dbl(Math.sqrt(this.var_dist_B), 4) + ") N = " + this.b_distance.length + "\n");
        System.err.print("+" + this.chargeState + "\ty-ions m/z Accuracy (mu, sigma): (" + globals.round_dbl(this.mu_dist_Y, 4) + ", " + globals.round_dbl(Math.sqrt(this.var_dist_Y), 4) + ") N = " + this.y_distance.length + "\n");
        System.err.print("+" + this.chargeState + "\tNoise Distance (mu, sigma): (" + globals.round_dbl(this.mu_dist_U, 4) + ", " + globals.round_dbl(Math.sqrt(this.var_dist_U), 4) + ") N = " + this.u_distance.length + "\n\n");
    }

    public void clearArrays() {
        this.b_distance = null;
        this.b_intensity = null;
        this.y_distance = null;
        this.y_intensity = null;
        this.u_distance = null;
        this.u_intensity = null;
    }

    public void writeModelPks() throws IOException {
        double dist;
        int n;
        int y;
        String line;
        double normI;
        int b;
        File debugF = new File("debug_model_pks_CID.txt");
        FileWriter fw = null;
        BufferedWriter bw = null;
        if (!debugF.exists()) {
            fw = new FileWriter(debugF);
            bw = new BufferedWriter(fw);
            String hdr = "charge\tdataType\tvalue\n";
            bw.write(hdr);
        } else {
            fw = new FileWriter(debugF, true);
            bw = new BufferedWriter(fw);
        }
        for (b = 0; b < this.b_intensity.length; ++b) {
            normI = globals.round_dbl(this.b_intensity[b], 4);
            line = Integer.toString(this.chargeState) + "\tyi\t" + Double.toString(normI) + "\n";
            bw.write(line);
        }
        for (y = 0; y < this.y_intensity.length; ++y) {
            normI = globals.round_dbl(this.y_intensity[y], 4);
            line = Integer.toString(this.chargeState) + "\tyi\t" + Double.toString(normI) + "\n";
            bw.write(line);
        }
        for (n = 0; n < this.u_intensity.length; ++n) {
            normI = globals.round_dbl(this.u_intensity[n], 4);
            line = Integer.toString(this.chargeState) + "\tni\t" + Double.toString(normI) + "\n";
            bw.write(line);
        }
        for (b = 0; b < this.b_distance.length; ++b) {
            dist = globals.round_dbl(this.b_distance[b], 4);
            line = Integer.toString(this.chargeState) + "\tbd\t" + Double.toString(dist) + "\n";
            bw.write(line);
        }
        for (y = 0; y < this.y_distance.length; ++y) {
            dist = globals.round_dbl(this.y_distance[y], 4);
            line = Integer.toString(this.chargeState) + "\tyd\t" + Double.toString(dist) + "\n";
            bw.write(line);
        }
        for (n = 0; n < this.u_distance.length; ++n) {
            dist = globals.round_dbl(this.u_distance[n], 4);
            line = Integer.toString(this.chargeState) + "\tnd\t" + Double.toString(dist) + "\n";
            bw.write(line);
        }
        bw.close();
    }
}

