/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lucxor.NormalDensityWorkerThread;
import lucxor.PeakClass;
import lucxor.globals;

public class ModelData_HCD {
    private static final double NORMAL_CONSTANT = 1.0 / Math.sqrt(Math.PI * 2);
    int chargeState;
    int numPSM;
    static final int ntick = 2000;
    double bIntBW;
    double yIntBW;
    double negIntBW;
    double posDistBW;
    double bIntMean;
    double bIntVar;
    double yIntMean;
    double yIntVar;
    double negIntMean;
    double negIntVar;
    double posDistMean;
    double posDistVar;
    double negDistMean;
    double negDistVar;
    double[] bTickMarksInt;
    double[] yTickMarksInt;
    double[] negTickMarksInt;
    double[] posTickMarksDist;
    double[] negTickMarksDist;
    double[] f_int_b;
    double[] f_int_y;
    double[] f_int_neg;
    double[] f_dist;
    ArrayList<PeakClass> posPks;
    ArrayList<PeakClass> negPks;
    double[] b_int;
    double[] y_int;
    double[] n_int;
    double[] pos_dist;

    public ModelData_HCD(int z, ArrayList<PeakClass> peaks) {
        this.chargeState = z;
        this.numPSM = 0;
        this.posPks = new ArrayList();
        this.negPks = new ArrayList();
        int b = 0;
        int y = 0;
        int n = 0;
        int p = 0;
        for (PeakClass pk : peaks) {
            if (pk.matched) {
                ++p;
                if (pk.matchedIonStr.startsWith("b")) {
                    this.posPks.add(pk);
                    ++b;
                }
                if (!pk.matchedIonStr.startsWith("y")) continue;
                this.posPks.add(pk);
                ++y;
                continue;
            }
            this.negPks.add(pk);
            ++n;
        }
        this.b_int = new double[b];
        this.y_int = new double[y];
        this.pos_dist = new double[p];
        b = 0;
        y = 0;
        for (PeakClass pk : this.posPks) {
            if (pk.matchedIonStr.startsWith("b")) {
                this.b_int[b] = pk.norm_intensity;
                ++b;
                continue;
            }
            if (!pk.matchedIonStr.startsWith("y")) continue;
            this.y_int[y] = pk.norm_intensity;
            ++y;
        }
        p = 0;
        for (PeakClass pk : this.posPks) {
            this.pos_dist[p] = pk.dist;
            ++p;
        }
        int limitN = b + y;
        if (limitN < 50000) {
            limitN += 50000;
        }
        if (limitN > n) {
            limitN = n;
        }
        this.n_int = new double[limitN];
        Collections.shuffle(this.negPks);
        n = 0;
        for (n = 0; n < limitN; ++n) {
            PeakClass pk;
            pk = this.negPks.get(n);
            this.n_int[n] = pk.norm_intensity;
        }
        this.posPks.clear();
        this.posPks = null;
        this.negPks.clear();
        this.negPks = null;
    }

    public void percentileTrim(char ionType, int dataType, double percentTrim) {
        double[] d = null;
        double[] f = null;
        int N = 0;
        int n = 0;
        int a = 0;
        int b = 0;
        if (ionType == 'b' && dataType == 0) {
            d = this.b_int;
        }
        if (ionType == 'y' && dataType == 0) {
            d = this.y_int;
        }
        if (ionType == 'n') {
            d = this.n_int;
        }
        N = d.length;
        a = n = (int)((double)N * (percentTrim * 0.5));
        b = N - 1 - n;
        Arrays.sort(d);
        f = Arrays.copyOfRange(d, a, b);
        if (ionType == 'b' && dataType == 0) {
            this.b_int = f;
        }
        if (ionType == 'y' && dataType == 0) {
            this.y_int = f;
        }
        if (ionType == 'n') {
            this.n_int = f;
        }
    }

    public void calcMean() {
        double mean = 0.0;
        double N = 0.0;
        double sum = 0.0;
        N = this.b_int.length;
        sum = 0.0;
        for (double b : this.b_int) {
            sum += b;
        }
        this.bIntMean = sum / N;
        N = this.y_int.length;
        sum = 0.0;
        for (double y : this.y_int) {
            sum += y;
        }
        this.yIntMean = sum / N;
        this.posDistMean = this.getMode(this.pos_dist);
        N = this.n_int.length;
        sum = 0.0;
        for (double n : this.n_int) {
            sum += n;
        }
        this.negIntMean = sum / N;
        this.negDistMean = 0.0;
    }

    public void calcVar() {
        double x;
        double v = 0.0;
        double N = (double)this.b_int.length - 1.0;
        for (double b : this.b_int) {
            x = b - this.bIntMean;
            v += Math.pow(x, 2.0);
        }
        this.bIntVar = v / N;
        v = 0.0;
        N = (double)this.y_int.length - 1.0;
        for (double b : this.y_int) {
            x = b - this.yIntMean;
            v += Math.pow(x, 2.0);
        }
        this.yIntVar = v / N;
        v = 0.0;
        N = (double)this.pos_dist.length - 1.0;
        for (double n : this.pos_dist) {
            x = n - this.posDistMean;
            v += Math.pow(x, 2.0);
        }
        this.posDistVar = v / N;
        v = 0.0;
        N = (double)this.n_int.length - 1.0;
        for (double n : this.n_int) {
            x = n - this.negIntMean;
            v += Math.pow(x, 2.0);
        }
        this.negIntVar = v / N;
    }

    void estimateNP_intensity(char ionType) throws InterruptedException, ExecutionException {
        int N = 0;
        double[] norm_ints = null;
        double[] tickMarksInt = null;
        double[] f_int = null;
        double variance = 0.0;
        double bw = 0.0;
        double kernelResult = 0.0;
        if (ionType == 'b') {
            N = this.b_int.length;
            norm_ints = this.b_int;
            variance = this.bIntVar;
            System.err.println("+" + this.chargeState + "  Estimating NP Model for b-ion intensities");
        } else if (ionType == 'y') {
            N = this.y_int.length;
            norm_ints = this.y_int;
            variance = this.yIntVar;
            System.err.println("+" + this.chargeState + "  Estimating NP Model for y-ion intensities");
        } else {
            N = this.n_int.length;
            norm_ints = this.n_int;
            variance = this.negIntVar;
            System.err.println("+" + this.chargeState + "  Estimating NP Model for noise peak intensities");
        }
        Arrays.sort(norm_ints);
        double minI = norm_ints[0];
        double maxI = norm_ints[N - 1];
        double padding = 0.1;
        double t = minI < 0.0 ? minI + globals.round_dbl(minI, 4) * padding : minI - globals.round_dbl(minI, 4) * padding;
        minI = globals.round_dbl(t, 4);
        t = maxI < 0.0 ? maxI - globals.round_dbl(maxI, 4) * padding : maxI + globals.round_dbl(maxI, 4) * padding;
        maxI = globals.round_dbl(t, 4);
        tickMarksInt = new double[2000];
        for (int ii = 0; ii < 2000; ++ii) {
            double tic;
            tickMarksInt[ii] = tic = minI + (double)ii * (maxI - minI) / 1999.0;
        }
        double sigma = Math.sqrt(variance);
        bw = 1.06 * (sigma / Math.pow(N, 0.2)) * 0.5;
        f_int = new double[2000];
        int block = norm_ints.length / globals.numThreads;
        for (int i = 0; i < 2000; ++i) {
            double tic = tickMarksInt[i];
            ExecutorService pool = Executors.newFixedThreadPool(globals.numThreads);
            ArrayList<Future<Double>> taskList = new ArrayList<Future<Double>>(globals.numThreads);
            for (int cpu = 0; cpu < globals.numThreads; ++cpu) {
                int n = cpu * block;
                int end = n + block;
                if (cpu == globals.numThreads - 1) {
                    end = norm_ints.length;
                }
                double[] subAry = Arrays.copyOfRange(norm_ints, n, end);
                NormalDensityWorkerThread C = new NormalDensityWorkerThread(subAry, tic, bw);
                Future<Double> task = pool.submit(C);
                taskList.add(task);
                subAry = null;
            }
            kernelResult = 0.0;
            for (Future future : taskList) {
                kernelResult += ((Double)future.get()).doubleValue();
            }
            if ((kernelResult /= (double)N * bw) <= 1.0E-10) {
                kernelResult = 1.0E-10;
            }
            f_int[i] = kernelResult;
            pool.shutdown();
        }
        if (ionType == 'b') {
            this.bTickMarksInt = tickMarksInt;
            this.f_int_b = f_int;
            this.bIntBW = bw;
        } else if (ionType == 'y') {
            this.yTickMarksInt = tickMarksInt;
            this.f_int_y = f_int;
            this.yIntBW = bw;
        } else {
            this.negTickMarksInt = tickMarksInt;
            this.f_int_neg = f_int;
            this.negIntBW = bw;
        }
    }

    void estimateNP_posDist() throws InterruptedException, ExecutionException {
        int N = 0;
        double min_dist = 0.0;
        double max_dist = 0.0;
        double variance = 0.0;
        double bw = 0.0;
        double kernelResult = 0.0;
        System.err.println("+" + this.chargeState + "  Estimating NP Model for b and y ions m/z distances");
        N = this.pos_dist.length;
        Arrays.sort(this.pos_dist);
        min_dist = this.pos_dist[0];
        max_dist = this.pos_dist[N - 1];
        double padding = 0.1;
        double t = min_dist < 0.0 ? min_dist + globals.round_dbl(min_dist, 4) * padding : min_dist - globals.round_dbl(min_dist, 4) * padding;
        min_dist = globals.round_dbl(t, 4);
        t = max_dist < 0.0 ? max_dist - globals.round_dbl(max_dist, 4) * padding : max_dist + globals.round_dbl(max_dist, 4) * padding;
        max_dist = globals.round_dbl(t, 4);
        this.posTickMarksDist = new double[2000];
        for (int ii = 0; ii < 2000; ++ii) {
            double tic;
            this.posTickMarksDist[ii] = tic = min_dist + (double)ii * (max_dist - min_dist) / 1999.0;
        }
        double sigma = Math.sqrt(this.posDistVar);
        bw = 1.06 * (sigma / Math.pow(N, 0.2)) * 0.1;
        double[] f_ary = new double[2000];
        int block = this.pos_dist.length / globals.numThreads;
        for (int i = 0; i < 2000; ++i) {
            double tic = this.posTickMarksDist[i];
            ExecutorService pool = Executors.newFixedThreadPool(globals.numThreads);
            ArrayList<Future<Double>> taskList = new ArrayList<Future<Double>>(globals.numThreads);
            for (int cpu = 0; cpu < globals.numThreads; ++cpu) {
                int n = cpu * block;
                int end = n + block;
                if (cpu == globals.numThreads - 1) {
                    end = this.pos_dist.length;
                }
                double[] subAry = Arrays.copyOfRange(this.pos_dist, n, end);
                NormalDensityWorkerThread C = new NormalDensityWorkerThread(subAry, tic, bw);
                Future<Double> task = pool.submit(C);
                taskList.add(task);
                subAry = null;
            }
            kernelResult = 0.0;
            for (Future future : taskList) {
                kernelResult += ((Double)future.get()).doubleValue();
            }
            if ((kernelResult /= (double)N * bw) <= 1.0E-10) {
                kernelResult = 1.0E-10;
            }
            f_ary[i] = kernelResult;
            pool.shutdown();
        }
        this.f_dist = f_ary;
        this.posDistBW = bw;
    }

    public double normalDensity(double curTickMark, double curScore, double h) {
        double res = 0.0;
        double x = (curTickMark - curScore) / h;
        res = NORMAL_CONSTANT * Math.exp(-0.5 * x * x);
        return res;
    }

    private double getMode(double[] ary) {
        double mode = 0.0;
        int Nbins = 2000;
        double binWidth = 1.0E-4;
        double LIMIT = 0.1;
        double[] v = new double[2000];
        block0: for (double L : ary) {
            for (int j = 0; j < Nbins - 1; ++j) {
                double a = -0.1 + (double)j * binWidth;
                double b = a + binWidth;
                if (!(L >= a) || !(L < b)) continue;
                int n = j;
                v[n] = v[n] + (v[j] + 1.0);
                continue block0;
            }
        }
        double maxValue = 0.0;
        int maxValIdx = 0;
        for (int i = 0; i < Nbins; ++i) {
            if (!(v[i] > maxValue)) continue;
            maxValue = v[i];
            maxValIdx = i;
        }
        mode = -0.1 + (double)maxValIdx * binWidth + binWidth / 2.0;
        return mode;
    }

    double getLogNPdensityInt(char ionType, double x) {
        int N = 0;
        double sum = 0.0;
        double[] tickMarksInt = null;
        double[] f_int = null;
        if (ionType == 'b') {
            N = this.bTickMarksInt.length;
            tickMarksInt = this.bTickMarksInt;
            f_int = this.f_int_b;
        } else if (ionType == 'y') {
            N = this.yTickMarksInt.length;
            tickMarksInt = this.yTickMarksInt;
            f_int = this.f_int_y;
        } else if (ionType == 'n') {
            N = this.negTickMarksInt.length;
            tickMarksInt = this.negTickMarksInt;
            f_int = this.f_int_neg;
        }
        double start_tick = tickMarksInt[0];
        double end_tick = tickMarksInt[1999];
        double start_val = f_int[0];
        double end_val = f_int[1999];
        for (int j = 1999; j >= 1; --j) {
            double fx;
            int i = j - 1;
            double a = tickMarksInt[i];
            double b = tickMarksInt[j];
            if (!(x >= a) || !(x < b)) continue;
            double tmp1 = (b - x) / (b - a);
            double tmp2 = (x - a) / (b - a);
            sum = fx = tmp1 * f_int[i] + tmp2 * f_int[j];
            break;
        }
        if (x <= start_tick) {
            sum = start_val;
        } else if (x >= end_tick) {
            sum = end_val;
        }
        return Math.log(sum);
    }

    double getLogNPdensityDistPos(double x) {
        boolean N = false;
        double sum = 0.0;
        double start_tick = this.posTickMarksDist[0];
        double end_tick = this.posTickMarksDist[1999];
        double start_val = this.f_dist[0];
        double end_val = this.f_dist[1999];
        for (int j = 1999; j >= 1; --j) {
            double fx;
            int i = j - 1;
            double a = this.posTickMarksDist[i];
            double b = this.posTickMarksDist[j];
            if (!(x >= a) || !(x < b)) continue;
            double tmp1 = (b - x) / (b - a);
            double tmp2 = (x - a) / (b - a);
            sum = fx = tmp1 * this.f_dist[i] + tmp2 * this.f_dist[j];
            break;
        }
        if (x <= start_tick) {
            sum = start_val;
        } else if (x >= end_tick) {
            sum = end_val;
        }
        return Math.log(sum);
    }

    void writeModelPks() throws IOException {
        String line;
        double normI;
        File debugF = new File("debug_model_pks_HCD.txt");
        FileWriter fw = null;
        BufferedWriter bw = null;
        if (!debugF.exists()) {
            fw = new FileWriter(debugF);
            bw = new BufferedWriter(fw);
            String hdr = "charge\tdataType\tvalue\n";
            bw.write(hdr);
        } else {
            fw = new FileWriter(debugF, true);
            bw = new BufferedWriter(fw);
        }
        for (int b = 0; b < this.b_int.length; ++b) {
            normI = globals.round_dbl(this.b_int[b], 4);
            line = Integer.toString(this.chargeState) + "\tyi\t" + Double.toString(normI) + "\n";
            bw.write(line);
        }
        for (int y = 0; y < this.y_int.length; ++y) {
            normI = globals.round_dbl(this.y_int[y], 4);
            line = Integer.toString(this.chargeState) + "\tyi\t" + Double.toString(normI) + "\n";
            bw.write(line);
        }
        for (int n = 0; n < this.n_int.length; ++n) {
            normI = globals.round_dbl(this.n_int[n], 4);
            line = Integer.toString(this.chargeState) + "\tni\t" + Double.toString(normI) + "\n";
            bw.write(line);
        }
        for (int p = 0; p < this.pos_dist.length; ++p) {
            double dist = globals.round_dbl(this.pos_dist[p], 4);
            line = Integer.toString(this.chargeState) + "\td\t" + Double.toString(dist) + "\n";
            bw.write(line);
        }
        bw.close();
    }

    public void printStats() {
        String line = "Z = " + this.chargeState + ":  " + "b-ions Intensity: (mean, std): (" + globals.round_dbl(this.bIntMean, 4) + ", " + globals.round_dbl(Math.sqrt(this.bIntVar), 4) + ") N = " + this.b_int.length + "\n" + "Z = " + this.chargeState + ":  " + "y-ions Intensity: (mean, std): (" + globals.round_dbl(this.yIntMean, 4) + ", " + globals.round_dbl(Math.sqrt(this.yIntVar), 4) + ") N = " + this.y_int.length + "\n" + "Z = " + this.chargeState + ":  " + "Matched Peak Distance: (mean, std): (" + globals.round_dbl(this.posDistMean, 4) + ", " + globals.round_dbl(Math.sqrt(this.posDistVar), 4) + ") N = " + this.pos_dist.length + "\n" + "Z = " + this.chargeState + ":  " + "Noise peak Intensity: (mean, std): (" + globals.round_dbl(this.negIntMean, 4) + ", " + globals.round_dbl(Math.sqrt(this.negIntVar), 4) + ") N = " + this.n_int.length + "\n";
        System.err.println(line);
    }

    public void write_density_data(int dataType) throws IOException {
        int i;
        String outName = null;
        FileWriter fw = null;
        BufferedWriter bw = null;
        switch (dataType) {
            case 1: {
                outName = "debug_HCD_nonParam_intensity.txt";
                break;
            }
            case 2: {
                outName = "debug_HCD_nonParam_distance.txt";
                break;
            }
        }
        File outF = new File(outName);
        if (!outF.exists()) {
            fw = new FileWriter(outF);
            bw = new BufferedWriter(fw);
            if (dataType == 1) {
                bw.write("dataType\tcharge\ttic\tintensity\n");
            }
            if (dataType == 2) {
                bw.write("dataType\tcharge\ttic\tdistance\n");
            }
        } else {
            fw = new FileWriter(outF, true);
            bw = new BufferedWriter(fw);
        }
        if (dataType == 1) {
            for (i = 0; i < 2000; ++i) {
                bw.write("b\t" + Integer.toString(this.chargeState) + "\t" + Double.toString(this.bTickMarksInt[i]) + "\t" + Double.toString(this.f_int_b[i]) + "\n");
                bw.write("y\t" + Integer.toString(this.chargeState) + "\t" + Double.toString(this.yTickMarksInt[i]) + "\t" + Double.toString(this.f_int_y[i]) + "\n");
                bw.write("n\t" + Integer.toString(this.chargeState) + "\t" + Double.toString(this.negTickMarksInt[i]) + "\t" + Double.toString(this.f_int_neg[i]) + "\n");
            }
        }
        if (dataType == 2) {
            for (i = 0; i < 2000; ++i) {
                bw.write("p\t" + Integer.toString(this.chargeState) + "\t" + Double.toString(this.posTickMarksDist[i]) + "\t" + Double.toString(this.f_dist[i]) + "\n");
            }
        }
        bw.close();
    }
}

