/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import gnu.trove.map.hash.TDoubleObjectHashMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lucxor.PeakClass;
import lucxor.Peptide;
import lucxor.SpectrumClass;
import lucxor.globals;

class PSM {
    String specId;
    String srcFile;
    int scanNum;
    int charge;
    double PSMscore;
    double deltaScore;
    double localFDR;
    double globalFDR;
    boolean isKeeper = false;
    boolean useForModel = false;
    boolean isDecoy = false;
    boolean isUnambiguous = false;
    TIntDoubleHashMap modCoordMap = null;
    THashMap<String, Double> posPermutationScoreMap = null;
    THashMap<String, Double> negPermutationScoreMap = null;
    ArrayList<PeakClass> posPeaks = null;
    ArrayList<PeakClass> negPeaks = null;
    SpectrumClass PeakList = null;
    Peptide origPep = new Peptide();
    Peptide score1pep;
    Peptide score2pep;

    PSM() {
        this.modCoordMap = new TIntDoubleHashMap();
        this.PeakList = new SpectrumClass();
    }

    void process() {
        this.origPep.initialize(this.modCoordMap);
        this.origPep.charge = this.charge;
        int keepingScore = 0;
        if (this.origPep.numPPS > 0) {
            ++keepingScore;
        }
        if (this.origPep.numRPS > 0) {
            ++keepingScore;
        }
        if (this.PSMscore >= globals.scoreTH) {
            ++keepingScore;
        }
        if (this.charge <= globals.maxChargeState) {
            ++keepingScore;
        }
        if (this.origPep.pepLen <= globals.maxPepLen) {
            ++keepingScore;
        }
        if (this.origPep.numPPS == this.origPep.numRPS) {
            this.isUnambiguous = true;
        }
        if (keepingScore == 5) {
            this.isKeeper = true;
        }
        if (this.isKeeper && this.PSMscore >= globals.modelTH) {
            this.useForModel = true;
        }
        if (this.isKeeper) {
            String suffix = "";
            String scanStr = Integer.toString(this.scanNum);
            if (globals.inputType == 0) {
                Pattern r;
                Matcher m;
                if (globals.spectrumSuffix.equalsIgnoreCase("mzXML")) {
                    suffix = "mzXML";
                }
                if (globals.spectrumSuffix.equalsIgnoreCase("mzML")) {
                    suffix = "mzML";
                }
                if (globals.spectrumSuffix.equalsIgnoreCase("mgf")) {
                    suffix = "mgf";
                }
                if ((m = (r = Pattern.compile("(.+)\\.\\d+\\.\\d+\\.\\d$")).matcher(this.specId)).find()) {
                    this.srcFile = m.group(1) + "." + suffix;
                    this.specId = m.group(1) + "." + Integer.toString(this.scanNum) + "." + Integer.toString(this.scanNum) + "." + Integer.toString(this.charge);
                } else {
                    System.err.println("\nERROR: PSM.java::Unable to correctly format specId variable.\n");
                    System.exit(0);
                }
            } else {
                Pattern r = Pattern.compile("(.+)\\.(mgf|mzXML|mzML)$");
                Matcher m = r.matcher(this.srcFile);
                if (m.find()) {
                    this.specId = m.group(1) + "." + Integer.toString(this.scanNum) + "." + Integer.toString(this.scanNum) + "." + Integer.toString(this.charge);
                } else {
                    System.err.println("\nERROR: PSM.java::Unable to correctly format specId variable.\n");
                    System.exit(0);
                }
            }
            this.origPep.build_ion_ladders();
        }
    }

    void recordSpectra(SpectrumClass S) {
        this.PeakList = S;
        if (globals.reduceNL == 1) {
            this.reduceNLpeak();
        }
        this.PeakList.medianNormalizeSpectra();
    }

    private void reduceNLpeak() {
        double mzErr;
        double pepMHplus = globals.getFragmentIonMass(this.origPep.modPeptide, 1.0, 18.01056);
        double NLmass = globals.round_dbl(pepMHplus + globals.precursorNLmass, 3);
        double NLmz = globals.round_dbl(NLmass / (double)this.charge, 3);
        if (!this.origPep.peptide.contains("S") && !this.origPep.peptide.contains("T")) {
            return;
        }
        double maxPk_mz = this.PeakList.mz[this.PeakList.maxI_index];
        double mzDelta = globals.round_dbl(Math.abs(maxPk_mz - NLmz), 5);
        if (mzDelta <= (mzErr = 1.00728)) {
            double orig_maxI = this.PeakList.maxI;
            int orig_maxI_index = this.PeakList.maxI_index;
            this.PeakList.raw_intensity[this.PeakList.maxI_index] = 0.0;
            double new_maxI = 0.0;
            int new_maxI_index = 0;
            for (int i = 0; i < this.PeakList.N; ++i) {
                if (!(this.PeakList.raw_intensity[i] > new_maxI)) continue;
                new_maxI = this.PeakList.raw_intensity[i];
                new_maxI_index = i;
            }
            this.PeakList.maxI = new_maxI;
            this.PeakList.calcRelativeIntensity();
            this.PeakList.raw_intensity[orig_maxI_index] = orig_maxI;
            this.PeakList.rel_intensity[orig_maxI_index] = 50.0;
        }
    }

    private TIntDoubleHashMap getModMap(String modPep) {
        int startAt;
        TIntDoubleHashMap ret = new TIntDoubleHashMap();
        if (this.modCoordMap.containsKey(-100)) {
            ret.put(-100, globals.ntermMass);
        }
        if (this.modCoordMap.containsKey(100)) {
            ret.put(100, globals.ntermMass);
        }
        for (int i = startAt = 0; i < modPep.length(); ++i) {
            double mass = 0.0;
            char c = modPep.charAt(i);
            if (globals.isDecoyResidue(Character.toString(c))) {
                mass = globals.AAmassMap.get(Character.toString(c));
                ret.put(i, mass);
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            mass = globals.AAmassMap.get(Character.toString(c));
            ret.put(i, mass);
        }
        for (int p : this.origPep.nonTargetMods.keySet()) {
            if (p == -100 || p == 100) continue;
            String aa = this.origPep.nonTargetMods.get(p);
            double mass = globals.AAmassMap.get(aa);
            ret.put(p, mass);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    void matchAllPeaks() {
        void var4_8;
        ArrayList ary;
        this.posPeaks = new ArrayList(this.PeakList.N);
        TIntDoubleHashMap mcp = new TIntDoubleHashMap();
        THashMap<String, Double> all_ions = new THashMap<String, Double>();
        for (String string : this.posPermutationScoreMap.keySet()) {
            mcp.clear();
            mcp = this.getModMap(string);
            Peptide curPep = new Peptide();
            curPep.initialize(this.origPep.peptide, string, this.charge, mcp);
            curPep.build_ion_ladders();
            all_ions.putAll(curPep.getIonLadder());
        }
        TDoubleObjectHashMap<ArrayList> candMatchedPks = new TDoubleObjectHashMap<ArrayList>(this.PeakList.N);
        for (String theo_ion : all_ions.keySet()) {
            double theo_mz;
            PeakClass matchedPk = this.getMatchedPeak(theo_ion, theo_mz = ((Double)all_ions.get(theo_ion)).doubleValue());
            if (null == matchedPk) continue;
            if (candMatchedPks.containsKey(matchedPk.mz)) {
                ary = (ArrayList)candMatchedPks.get(matchedPk.mz);
                PeakClass newEntry = new PeakClass(matchedPk);
                ary.add(newEntry);
                candMatchedPks.put(matchedPk.mz, ary);
                continue;
            }
            ary = new ArrayList();
            ary.add(matchedPk);
            candMatchedPks.put(matchedPk.mz, ary);
        }
        for (double mz : candMatchedPks.keys()) {
            ary = (ArrayList)candMatchedPks.get(mz);
            Collections.sort(ary, PeakClass.comparator_mz_abs_dist);
            this.posPeaks.add((PeakClass)ary.get(0));
        }
        candMatchedPks.clear();
        candMatchedPks = null;
        if (this.posPeaks.isEmpty()) {
            this.useForModel = false;
            this.posPeaks.clear();
            return;
        }
        this.negPeaks = new ArrayList(this.PeakList.N);
        boolean bl = false;
        while (var4_8 < this.PeakList.N) {
            PeakClass negPk = this.PeakList.getPeakClassInstance((int)var4_8);
            if (!this.posPeaks.contains(negPk)) {
                double finalDist = 0.0;
                ArrayList<Double> dist = new ArrayList<Double>(this.posPeaks.size());
                ArrayList<Double> absDist = new ArrayList<Double>(this.posPeaks.size());
                int j = 0;
                for (PeakClass matchedPk : this.posPeaks) {
                    double d = matchedPk.mz - negPk.mz;
                    dist.add(d);
                    absDist.add(Math.abs(d));
                    ++j;
                }
                Collections.shuffle(dist);
                Collections.sort(absDist);
                finalDist = (Double)absDist.get(0);
                Iterator<PeakClass> iterator = dist.iterator();
                while (iterator.hasNext()) {
                    double d = (Double)((Object)iterator.next());
                    if (Math.abs(d) != finalDist) continue;
                    negPk.matched = false;
                    negPk.dist = d;
                    this.negPeaks.add(negPk);
                    break;
                }
            }
            ++var4_8;
        }
    }

    private PeakClass getMatchedPeak(String theo_ion, double theo_mz) {
        PeakClass ret = null;
        double matchErr = 0.0;
        double a = 0.0;
        double b = 0.0;
        if (globals.ms2tol_units == 1) {
            double ppmErr = globals.ms2tol / 1.0E-6;
            matchErr = theo_mz * ppmErr;
        } else {
            matchErr = globals.ms2tol;
        }
        a = theo_mz - (matchErr *= 0.5);
        b = theo_mz + matchErr;
        ArrayList<PeakClass> candMatches = new ArrayList<PeakClass>();
        for (int i = 0; i < this.PeakList.N; ++i) {
            if (!(this.PeakList.mz[i] >= a) || !(this.PeakList.mz[i] <= b)) continue;
            PeakClass pk = this.PeakList.getPeakClassInstance(i);
            candMatches.add(pk);
        }
        if (!candMatches.isEmpty()) {
            Collections.sort(candMatches, PeakClass.comparator_intensity_hi2low);
            ret = (PeakClass)candMatches.get(0);
            ret.matched = true;
            ret.dist = ret.mz - theo_mz;
            ret.matchedIonStr = theo_ion;
            ret.matchedIonMZ = theo_mz;
        }
        return ret;
    }

    void generatePermutations(int RN) {
        this.posPermutationScoreMap = new THashMap();
        this.posPermutationScoreMap = this.origPep.getPermutations(0);
        if (!this.isUnambiguous) {
            this.negPermutationScoreMap = new THashMap();
            if (RN == 0) {
                this.negPermutationScoreMap = this.origPep.getPermutations(1);
            }
        }
    }

    private void killThreadResults() {
        this.deltaScore = -1.0;
        this.score1pep = this.origPep;
        this.score2pep = this.origPep;
    }

    void scorePermutations() throws IOException {
        String line;
        Peptide curPep;
        TIntDoubleHashMap mcp = null;
        File debugF = null;
        FileWriter fw = null;
        BufferedWriter bw = null;
        if (Thread.interrupted()) {
            this.killThreadResults();
            return;
        }
        if (globals.debugMode == 2) {
            debugF = new File("all_scores.debug");
            if (!debugF.exists()) {
                fw = new FileWriter(debugF);
                bw = new BufferedWriter(fw);
                bw.write("specId\torigModPep\tcurPermutation\tisDecoy\tscore\n");
            } else {
                fw = new FileWriter(debugF, true);
                bw = new BufferedWriter(fw);
            }
        }
        if (globals.debugMode == 5) {
            debugF = new File("all_matched_pks.debug");
            if (!debugF.exists()) {
                fw = new FileWriter(debugF);
                bw = new BufferedWriter(fw);
                bw.write("specId\tcurPermutation\tisDecoy\tionSeq\tmz\tintensity\tmzDist\tIscore\tDscore\tscore\n");
            } else {
                fw = new FileWriter(debugF, true);
                bw = new BufferedWriter(fw);
            }
        }
        for (String string : this.posPermutationScoreMap.keySet()) {
            mcp = this.getModMap(string);
            curPep = new Peptide();
            curPep.initialize(this.origPep.peptide, string, this.charge, mcp);
            curPep.build_ion_ladders();
            curPep.numPPS = this.origPep.numPPS;
            curPep.numRPS = this.origPep.numRPS;
            curPep.matchPeaks(this.PeakList);
            if (globals.scoringAlgorithm == 0) {
                curPep.calcScore_CID();
            }
            if (globals.scoringAlgorithm == 1) {
                curPep.calcScore_HCD();
            }
            if (globals.debugMode == 2) {
                line = this.specId + "\t" + this.origPep.modPeptide + "\t" + curPep.modPeptide + "\t0\t" + curPep.score + "\n";
                bw.write(line);
            }
            if (globals.debugMode == 5) {
                for (PeakClass pk : curPep.matchedPeaks) {
                    line = this.specId + "\t" + string + "\t" + globals.isDecoySeq(string) + "\t" + pk.matchedIonStr + "\t" + pk.mz + "\t" + pk.rel_intensity + "\t" + pk.dist + "\t" + pk.intensityScore + "\t" + pk.distScore + "\t" + pk.score + "\n";
                    bw.write(line);
                }
                bw.write("\n");
            }
            this.posPermutationScoreMap.put(string, curPep.score);
            curPep = null;
            mcp = null;
        }
        if (!this.isUnambiguous) {
            for (String string : this.negPermutationScoreMap.keySet()) {
                mcp = this.getModMap(string);
                curPep = new Peptide();
                mcp = this.getModMap(string);
                curPep.initialize(this.origPep.modPeptide, string, this.charge, mcp);
                curPep.build_ion_ladders();
                curPep.numPPS = this.origPep.numPPS;
                curPep.numRPS = this.origPep.numRPS;
                curPep.matchPeaks(this.PeakList);
                if (globals.scoringAlgorithm == 0) {
                    curPep.calcScore_CID();
                }
                if (globals.scoringAlgorithm == 1) {
                    curPep.calcScore_HCD();
                }
                if (globals.debugMode == 2) {
                    line = this.specId + "\t" + this.origPep.modPeptide + "\t" + curPep.modPeptide + "\t1\t" + curPep.score + "\n";
                    bw.write(line);
                }
                if (globals.debugMode == 5) {
                    for (PeakClass pk : curPep.matchedPeaks) {
                        line = this.specId + "\t" + string + "\t" + globals.isDecoySeq(string) + "\t" + pk.matchedIonStr + "\t" + pk.mz + "\t" + pk.rel_intensity + "\t" + pk.dist + "\t" + pk.intensityScore + "\t" + pk.distScore + "\t" + pk.score + "\n";
                        bw.write(line);
                    }
                    bw.write("\n");
                }
                this.negPermutationScoreMap.put(string, curPep.score);
                curPep = null;
                mcp = null;
            }
        }
        if (globals.debugMode == 2) {
            bw.close();
        }
        if (globals.debugMode == 5) {
            bw.close();
        }
        ArrayList<Double> allScores = new ArrayList<Double>();
        for (String curSeq : this.posPermutationScoreMap.keySet()) {
            double d = this.posPermutationScoreMap.get(curSeq);
            allScores.add(d);
        }
        if (!this.isUnambiguous) {
            for (String curSeq : this.negPermutationScoreMap.keySet()) {
                double d = this.negPermutationScoreMap.get(curSeq);
                allScores.add(d);
            }
        }
        Collections.sort(allScores);
        Collections.reverse(allScores);
        double d = globals.round_dbl((Double)allScores.get(0), 6);
        double score2 = 0.0;
        if (!this.isUnambiguous) {
            score2 = globals.round_dbl((Double)allScores.get(1), 6);
        }
        String pep1 = "";
        String pep2 = "";
        int numAssigned = 0;
        if (!this.isUnambiguous) {
            double d2;
            double x;
            String curSeq;
            for (Map.Entry<String, Double> e : this.posPermutationScoreMap.entrySet()) {
                curSeq = e.getKey();
                x = e.getValue();
                d2 = globals.round_dbl(x, 6);
                if (d2 == d && pep1.isEmpty()) {
                    pep1 = curSeq;
                    ++numAssigned;
                } else if (d2 == score2 && pep2.isEmpty()) {
                    pep2 = curSeq;
                    ++numAssigned;
                }
                if (numAssigned != 2) continue;
                break;
            }
            if (numAssigned != 2) {
                for (Map.Entry<String, Double> e : this.negPermutationScoreMap.entrySet()) {
                    curSeq = e.getKey();
                    x = e.getValue();
                    d2 = globals.round_dbl(x, 6);
                    if (d2 == d && pep1.isEmpty()) {
                        pep1 = curSeq;
                        ++numAssigned;
                    } else if (d2 == score2 && pep2.isEmpty()) {
                        pep2 = curSeq;
                        ++numAssigned;
                    }
                    if (numAssigned != 2) continue;
                    break;
                }
            }
        } else {
            for (Map.Entry<String, Double> e : this.posPermutationScoreMap.entrySet()) {
                String curSeq;
                pep1 = curSeq = e.getKey();
            }
        }
        mcp = this.getModMap(pep1);
        this.score1pep = new Peptide();
        this.score1pep.initialize(this.origPep.peptide, pep1, this.charge, mcp);
        this.score1pep.score = d;
        this.isDecoy = this.score1pep.isDecoyPep();
        mcp = null;
        if (this.isUnambiguous) {
            mcp = this.getModMap(pep1);
            this.score2pep = new Peptide();
            this.score2pep.initialize(this.origPep.peptide, pep1, this.charge, mcp);
            this.score2pep.score = 0.0;
            mcp = null;
            this.deltaScore = d;
        } else {
            mcp = this.getModMap(pep2);
            this.score2pep = new Peptide();
            this.score2pep.initialize(this.origPep.peptide, pep2, this.charge, mcp);
            this.score2pep.score = score2;
            mcp = null;
            this.deltaScore = d - score2;
        }
    }

    String getResults() {
        String ret = this.specId + "\t";
        if (globals.peptideRepresentation == 0) {
            ret = ret + this.origPep.peptide + "\t";
            ret = ret + this.score1pep.modPeptide + "\t";
            ret = ret + this.score2pep.modPeptide + "\t";
        } else {
            ret = ret + this.origPep.getModPepTPP() + "\t";
            ret = ret + this.score1pep.getModPepTPP() + "\t";
            ret = ret + this.score2pep.getModPepTPP() + "\t";
        }
        ret = ret + Integer.toString(this.origPep.numPPS) + "\t" + Integer.toString(this.origPep.numRPS) + "\t";
        ret = ret + Double.toString(this.PSMscore) + "\t";
        if (globals.runMode == 1) {
            ret = ret + (this.score1pep.isDecoyPep() ? 1 : 0) + "\t" + (this.score2pep.isDecoyPep() ? 1 : 0) + "\t";
        }
        ret = ret + Double.toString(this.deltaScore) + "\t";
        ret = ret + Double.toString(this.score1pep.score) + "\t" + Double.toString(this.score2pep.score) + "\t";
        ret = ret + Double.toString(this.globalFDR) + "\t" + Double.toString(this.localFDR);
        ret = ret + "\n";
        return ret;
    }

    void debug_writeScoredPeaks() throws IOException {
        String dist;
        String score;
        String Dscore;
        String Iscore;
        String normI;
        String relI;
        String mz;
        String tsvFileName = "";
        if (globals.inputType == 0) {
            tsvFileName = this.specId + ".tsv";
        } else {
            int i = this.srcFile.lastIndexOf(globals.spectrumSuffix);
            String k = String.format("%05d", this.scanNum) + Integer.toString(this.charge);
            tsvFileName = this.srcFile.substring(0, i) + k + ".tsv";
        }
        String outDirName = "debug_scored_peaks." + globals.dateStamp;
        String outFileStr = outDirName + "/" + tsvFileName;
        File outF = new File(outFileStr);
        outF.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(outF.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("num\tmodPeptide\tfragmentIon\tobs m/z\tmatchDist\trelIntensity\tnormIntensity\tDscore\tIscore\tfinalScore\n");
        this.score1pep.build_ion_ladders();
        this.score1pep.matchPeaks(this.PeakList);
        if (globals.scoringAlgorithm == 0) {
            this.score1pep.calcScore_CID();
        }
        if (globals.scoringAlgorithm == 1) {
            this.score1pep.calcScore_HCD();
        }
        ArrayList<PeakClass> mPK = this.score1pep.matchedPeaks;
        Collections.sort(mPK, PeakClass.comparator_mz);
        for (PeakClass pk : mPK) {
            if (!pk.matched) continue;
            mz = Double.toString(globals.round_dbl(pk.mz, 4));
            relI = Double.toString(globals.round_dbl(pk.rel_intensity, 4));
            normI = Double.toString(globals.round_dbl(pk.norm_intensity, 4));
            Iscore = Double.toString(globals.round_dbl(pk.intensityScore, 4));
            Dscore = Double.toString(globals.round_dbl(pk.distScore, 4));
            score = Double.toString(globals.round_dbl(pk.score, 4));
            dist = Double.toString(globals.round_dbl(pk.dist, 4));
            bw.write("0\t" + this.score1pep.modPeptide + "\t" + pk.matchedIonStr + "\t" + mz + "\t" + dist + "\t" + relI + "\t" + normI + "\t" + Dscore + "\t" + Iscore + "\t" + score + "\n");
        }
        this.score2pep.build_ion_ladders();
        this.score2pep.matchPeaks(this.PeakList);
        if (globals.scoringAlgorithm == 0) {
            this.score2pep.calcScore_CID();
        }
        if (globals.scoringAlgorithm == 1) {
            this.score2pep.calcScore_HCD();
        }
        mPK.clear();
        mPK = this.score2pep.matchedPeaks;
        Collections.sort(mPK, PeakClass.comparator_mz);
        for (PeakClass pk : mPK) {
            if (!pk.matched) continue;
            mz = Double.toString(globals.round_dbl(pk.mz, 4));
            relI = Double.toString(globals.round_dbl(pk.rel_intensity, 4));
            normI = Double.toString(globals.round_dbl(pk.norm_intensity, 4));
            Iscore = Double.toString(globals.round_dbl(pk.intensityScore, 4));
            Dscore = Double.toString(globals.round_dbl(pk.distScore, 4));
            score = Double.toString(globals.round_dbl(pk.score, 4));
            dist = Double.toString(globals.round_dbl(pk.dist, 4));
            bw.write("1\t" + this.score2pep.modPeptide + "\t" + pk.matchedIonStr + "\t" + mz + "\t" + dist + "\t" + relI + "\t" + normI + "\t" + Dscore + "\t" + Iscore + "\t" + score + "\n");
        }
        bw.close();
    }

    String writeMatchedPks() {
        String score;
        String Dscore;
        String Iscore;
        String relI;
        String mz;
        String ret = "";
        this.score1pep.build_ion_ladders();
        this.score1pep.matchPeaks(this.PeakList);
        if (globals.scoringAlgorithm == 0) {
            this.score1pep.calcScore_CID();
        }
        if (globals.scoringAlgorithm == 1) {
            this.score1pep.calcScore_HCD();
        }
        ArrayList<PeakClass> mPK = this.score1pep.matchedPeaks;
        Collections.sort(mPK, PeakClass.comparator_mz);
        for (PeakClass pk : mPK) {
            if (!pk.matched) continue;
            mz = Double.toString(globals.round_dbl(pk.mz, 4));
            relI = Double.toString(globals.round_dbl(pk.rel_intensity, 4));
            Iscore = Double.toString(globals.round_dbl(pk.intensityScore, 4));
            Dscore = Double.toString(globals.round_dbl(pk.distScore, 4));
            score = Double.toString(globals.round_dbl(pk.score, 4));
            ret = ret + this.specId + "\t1\t" + this.score1pep.modPeptide + "\t" + pk.matchedIonStr + "\t" + mz + "\t" + relI + "\t" + Dscore + "\t" + Iscore + "\t" + score + "\n";
        }
        this.score2pep.build_ion_ladders();
        this.score2pep.matchPeaks(this.PeakList);
        if (globals.scoringAlgorithm == 0) {
            this.score2pep.calcScore_CID();
        }
        if (globals.scoringAlgorithm == 1) {
            this.score2pep.calcScore_HCD();
        }
        mPK.clear();
        mPK = this.score2pep.matchedPeaks;
        Collections.sort(mPK, PeakClass.comparator_mz);
        for (PeakClass pk : mPK) {
            if (!pk.matched) continue;
            mz = Double.toString(globals.round_dbl(pk.mz, 4));
            relI = Double.toString(globals.round_dbl(pk.rel_intensity, 4));
            Iscore = Double.toString(globals.round_dbl(pk.intensityScore, 4));
            Dscore = Double.toString(globals.round_dbl(pk.distScore, 4));
            score = Double.toString(globals.round_dbl(pk.score, 4));
            ret = ret + this.specId + "\t2\t" + this.score2pep.modPeptide + "\t" + pk.matchedIonStr + "\t" + mz + "\t" + relI + "\t" + Dscore + "\t" + Iscore + "\t" + score + "\n";
        }
        return ret;
    }

    public void clearScores() {
        this.deltaScore = 0.0;
        this.globalFDR = Double.NaN;
        this.localFDR = Double.NaN;
        this.isDecoy = false;
        this.score1pep = null;
        this.score2pep = null;
        this.posPermutationScoreMap = null;
        this.negPermutationScoreMap = null;
    }
}

