/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import java.util.Comparator;

public class PeakClass {
    double mz;
    double raw_intensity;
    double rel_intensity;
    double norm_intensity;
    double distScore;
    double intensityScore;
    double dist;
    double score;
    boolean matched;
    String matchedIonStr;
    double matchedIonMZ;
    public static Comparator comparator_RAW_intensity_hi2low = new Comparator<PeakClass>(){

        @Override
        public int compare(PeakClass o1, PeakClass o2) {
            return Double.compare(o2.raw_intensity, o1.raw_intensity);
        }
    };
    public static Comparator comparator_intensity_hi2low = new Comparator<PeakClass>(){

        @Override
        public int compare(PeakClass o1, PeakClass o2) {
            return Double.compare(o2.rel_intensity, o1.rel_intensity);
        }
    };
    public static Comparator comparator_intensity_low2hi = new Comparator<PeakClass>(){

        @Override
        public int compare(PeakClass o1, PeakClass o2) {
            return Double.compare(o1.rel_intensity, o2.rel_intensity);
        }
    };
    public static Comparator comparator_mz = new Comparator<PeakClass>(){

        @Override
        public int compare(PeakClass o1, PeakClass o2) {
            return Double.compare(o1.mz, o2.mz);
        }
    };
    public static Comparator comparator_mz_abs_dist = new Comparator<PeakClass>(){

        @Override
        public int compare(PeakClass o1, PeakClass o2) {
            return Double.compare(Math.abs(o1.dist), Math.abs(o2.dist));
        }
    };

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeakClass other = (PeakClass)obj;
        return Double.doubleToLongBits(this.mz) == Double.doubleToLongBits(other.mz);
    }

    PeakClass(double x, double y) {
        this.mz = x;
        this.raw_intensity = y;
    }

    public PeakClass() {
        this.mz = 0.0;
        this.rel_intensity = 0.0;
        this.distScore = 0.0;
        this.dist = 0.0;
        this.intensityScore = 0.0;
        this.matchedIonMZ = 0.0;
        this.score = 0.0;
        this.matched = false;
    }

    public PeakClass(PeakClass other) {
        this.mz = other.mz;
        this.raw_intensity = other.raw_intensity;
        this.rel_intensity = other.rel_intensity;
        this.norm_intensity = other.norm_intensity;
        this.distScore = other.distScore;
        this.intensityScore = other.intensityScore;
        this.dist = other.dist;
        this.score = other.score;
        this.matched = other.matched;
        this.matchedIonStr = new String(other.matchedIonStr);
        this.matchedIonMZ = other.matchedIonMZ;
    }

    public void clear() {
        this.distScore = 0.0;
        this.dist = 0.0;
        this.score = 0.0;
        this.intensityScore = 0.0;
        this.matchedIonMZ = 0.0;
        this.matchedIonStr = "";
        this.matched = false;
    }
}

