/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lucxor.PSM;
import lucxor.globals;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PepXML
extends DefaultHandler {
    HashMap<String, Double> variableMods = new HashMap();
    HashMap<String, Double> fixedMods = new HashMap();
    String temp;
    String searchEngine;
    String AA_alphabet = "ACDEFGHIKLMNPQRSTVWY";
    PSM curPSM = null;
    boolean recordMods = true;

    PepXML(File inputXML) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(inputXML, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        double modMass;
        this.temp = "";
        if (qName.equalsIgnoreCase("search_summary")) {
            String se = attr.getValue("search_engine");
            if (se.startsWith("Hydra")) {
                this.searchEngine = "hydra";
            } else if (se.equalsIgnoreCase("MASCOT")) {
                this.searchEngine = "mascot";
            } else if (se.contains("Tandem")) {
                this.searchEngine = "tandem";
            } else if (se.equalsIgnoreCase("Comet")) {
                this.searchEngine = "comet";
            } else if (se.equalsIgnoreCase("Sequest")) {
                this.searchEngine = "sequest";
            }
        }
        if (qName.equalsIgnoreCase("aminoacid_modification")) {
            String aa = attr.getValue("aminoacid");
            modMass = Double.valueOf(attr.getValue("massdiff"));
            String varStatus = attr.getValue("variable");
            if (this.AA_alphabet.contains(aa)) {
                if (varStatus.equalsIgnoreCase("y")) {
                    if (!globals.varModMap.containsKey(aa.toLowerCase())) {
                        globals.varModMap.put(aa.toLowerCase(), modMass);
                    }
                } else if (!globals.fixedModMap.containsKey(aa.toUpperCase())) {
                    globals.fixedModMap.put(aa.toUpperCase(), modMass);
                }
            }
        }
        if (qName.equalsIgnoreCase("terminal_modification")) {
            String terminus = attr.getValue("terminus");
            modMass = Double.valueOf(attr.getValue("massdiff"));
            String aa = "x";
            if (terminus.equalsIgnoreCase("n")) {
                globals.ntermMass = modMass;
            }
            if (terminus.equalsIgnoreCase("c")) {
                globals.ctermMass = modMass;
            }
        }
        if (qName.equalsIgnoreCase("spectrum_query")) {
            this.curPSM = new PSM();
            this.curPSM.specId = attr.getValue("spectrum");
            this.curPSM.scanNum = Integer.valueOf(attr.getValue("start_scan"));
            this.curPSM.charge = Integer.valueOf(attr.getValue("assumed_charge"));
        }
        if (qName.equalsIgnoreCase("search_hit")) {
            this.curPSM.origPep.peptide = attr.getValue("peptide");
        }
        if (qName.equalsIgnoreCase("modification_info")) {
            if (attr.getLocalName(0).equalsIgnoreCase("mod_nterm_mass")) {
                double nterm = Double.valueOf(attr.getValue("mod_nterm_mass"));
                this.curPSM.modCoordMap.put(-100, nterm);
            } else if (attr.getLocalName(0).equalsIgnoreCase("mod_cterm_mass")) {
                double cterm = Double.valueOf(attr.getValue("mod_cterm_mass"));
                this.curPSM.modCoordMap.put(100, cterm);
            }
        }
        if (qName.equalsIgnoreCase("mod_aminoacid_mass")) {
            int pos = Integer.valueOf(attr.getValue("position")) - 1;
            double mass = Double.valueOf(attr.getValue("mass"));
            this.curPSM.modCoordMap.put(pos, mass);
        }
        if (qName.equalsIgnoreCase("search_score") && globals.scoringMethod != 0) {
            for (int i = 0; i < attr.getLength() - 1; ++i) {
                int j = i + 1;
                String k = attr.getValue(i);
                double score = Double.valueOf(attr.getValue(j));
                if (globals.scoringMethod == 2 && k.equalsIgnoreCase("expect")) {
                    this.curPSM.PSMscore = -1.0 * Math.log(score);
                }
                if (globals.scoringMethod == 1 && k.equalsIgnoreCase("ionscore")) {
                    this.curPSM.PSMscore = score;
                }
                if (globals.scoringMethod == 3 && k.equalsIgnoreCase("hyperscore")) {
                    this.curPSM.PSMscore = score;
                }
                if (globals.scoringMethod != 4 || !k.equalsIgnoreCase("xcorr")) continue;
                this.curPSM.PSMscore = score;
            }
        }
        if (qName.equalsIgnoreCase("peptideprophet_result") && globals.scoringMethod == 0) {
            this.curPSM.PSMscore = Double.valueOf(attr.getValue("probability"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.temp = null;
        if (qName.equalsIgnoreCase("search_summary") && this.recordMods) {
            globals.recordModsFromPepXML();
            this.recordMods = false;
        }
        if (qName.equalsIgnoreCase("search_hit")) {
            String x = this.curPSM.origPep.peptide;
            int numBadChars = 0;
            for (int i = 0; i < x.length(); ++i) {
                String c = Character.toString(x.charAt(i));
                if ("ACDEFGHIKLMNPQRSTVWY".contains(c)) continue;
                ++numBadChars;
            }
            if (this.curPSM.origPep.getNumPerm() > globals.max_num_permutations) {
                numBadChars = 100;
            }
            if (numBadChars == 0) {
                this.curPSM.process();
                if (this.curPSM.isKeeper) {
                    globals.PSM_list.add(this.curPSM);
                }
                this.curPSM = null;
            }
        }
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.temp = new String(buffer, start, length);
    }
}

