/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TDoubleObjectHashMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import lucxor.ModelData_CID;
import lucxor.ModelData_HCD;
import lucxor.PeakClass;
import lucxor.SpectrumClass;
import lucxor.globals;
import org.apache.commons.math3.util.FastMath;

class Peptide {
    String peptide;
    String modPeptide;
    int charge = 0;
    TIntDoubleHashMap modPosMap = new TIntDoubleHashMap();
    THashMap<Integer, String> nonTargetMods = new THashMap();
    THashMap<String, Double> b_ions = null;
    THashMap<String, Double> y_ions = null;
    int pepLen = 0;
    int numRPS;
    int numPPS;
    boolean is_unambiguous = false;
    double numPermutations = 0.0;
    double numDecoyPermutations = 0.0;
    double score = 0.0;
    ArrayList<PeakClass> matchedPeaks;

    Peptide() {
    }

    void initialize(TIntDoubleHashMap modCoordMap) {
        int i;
        String origPepStr;
        this.pepLen = this.peptide.length();
        this.peptide = origPepStr = this.peptide.toUpperCase();
        for (int pos : modCoordMap.keys()) {
            double mass = modCoordMap.get(pos);
            if (pos == -100 || pos == 100) {
                this.modPosMap.put(pos, mass);
                continue;
            }
            String C = Character.toString(this.peptide.charAt(pos));
            String c = C.toLowerCase();
            if (globals.fixedModMap.containsKey(C)) continue;
            if (globals.targetModMap.containsKey(C)) {
                this.modPosMap.put(pos, mass);
                continue;
            }
            if (!globals.varModMap.containsKey(c)) continue;
            this.nonTargetMods.put(pos, c);
        }
        this.modPeptide = "";
        for (i = 0; i < this.pepLen; ++i) {
            String c;
            String AA = Character.toString(this.peptide.charAt(i));
            if (this.nonTargetMods.containsKey(i)) {
                AA = this.nonTargetMods.get(i);
            } else if (this.modPosMap.containsKey(i) && !globals.isDecoyResidue(c = AA)) {
                AA = c.toLowerCase();
            }
            this.modPeptide = this.modPeptide + AA;
        }
        this.numPPS = 0;
        for (i = 0; i < this.pepLen; ++i) {
            String AA = Character.toString(this.peptide.charAt(i));
            if (!globals.targetModMap.containsKey(AA)) continue;
            ++this.numPPS;
        }
        this.numRPS = 0;
        for (i = 0; i < this.pepLen; ++i) {
            String aa = Character.toString(this.modPeptide.charAt(i));
            int score = 0;
            if (globals.targetModMap.containsKey(aa.toUpperCase())) {
                ++score;
            }
            if (Character.isLowerCase(aa.charAt(0))) {
                ++score;
            }
            if (score != 2) continue;
            ++this.numRPS;
        }
        this.numPermutations = globals.SF.combinatorial(this.numPPS, this.numRPS);
        this.calcNumDecoyPermutations();
        if (this.numPPS == this.numRPS) {
            this.is_unambiguous = true;
        }
    }

    void initialize(String origPep, String curSeq, int z, TIntDoubleHashMap mcp) {
        this.peptide = origPep;
        this.pepLen = this.peptide.length();
        this.charge = z;
        this.modPosMap = mcp;
        if (curSeq.startsWith("[")) {
            this.modPosMap.put(-100, globals.ntermMass);
            this.modPeptide = curSeq;
        } else {
            this.modPeptide = curSeq;
        }
        if (curSeq.endsWith("]")) {
            this.modPosMap.put(100, globals.ctermMass);
        }
    }

    public String getModPepTPP() {
        int d;
        String ret = "";
        int pepLen_local = this.pepLen;
        if (this.modPeptide.startsWith("[")) {
            d = (int)Math.round(globals.ntermMass);
            ret = "n[" + String.valueOf(d) + "]";
            ++pepLen_local;
        }
        for (int i = 0; i < pepLen_local; ++i) {
            String aa = Character.toString(this.modPeptide.charAt(i));
            if (aa.equals("[") || aa.equals("]")) continue;
            ret = Character.isLowerCase(this.modPeptide.charAt(i)) ? ret + globals.getTPPresidue(aa) : ret + aa;
        }
        if (this.modPeptide.endsWith("]")) {
            d = (int)Math.round(globals.ctermMass);
            ret = ret + "c[" + String.valueOf(d) + "]";
        }
        return ret;
    }

    void build_ion_ladders() {
        this.b_ions = new THashMap();
        this.y_ions = new THashMap();
        String b = null;
        String y = null;
        double bm = 0.0;
        double ym = 0.0;
        double bmz = 0.0;
        double ymz = 0.0;
        double ntermM = 0.0;
        double ctermM = 0.0;
        int minLen = 2;
        if (this.modPosMap.containsKey(-100)) {
            ntermM = globals.ntermMass;
        }
        if (this.modPosMap.containsKey(100)) {
            ctermM = globals.ctermMass;
        }
        for (double Z = 1.0; Z < (double)this.charge; Z += 1.0) {
            for (int i = 1; i < this.pepLen; ++i) {
                String prefix = this.modPeptide.substring(0, i);
                String suffix = this.modPeptide.substring(i);
                String prefix_len = Integer.toString(prefix.length());
                String suffix_len = Integer.toString(suffix.length());
                if (prefix.length() >= 2) {
                    b = "b" + prefix_len + ":" + prefix;
                    bm = globals.getFragmentIonMass(b, Z, 0.0) + ntermM;
                    bmz = bm / Z;
                    if (Z > 1.0) {
                        b = b + "/+" + Integer.toString((int)Z);
                    }
                    if (bmz > globals.minMZ) {
                        this.b_ions.put(b, bmz);
                        this.record_NL_ions(b, Z, bm);
                    }
                }
                if (suffix.length() < 2 || suffix.equalsIgnoreCase(this.modPeptide)) continue;
                y = "y" + suffix_len + ":" + suffix;
                ym = globals.getFragmentIonMass(y, Z, 18.01056) + ctermM;
                ymz = ym / Z;
                if (Z > 1.0) {
                    y = y + "/+" + Integer.toString((int)Z);
                }
                if (!(ymz > globals.minMZ)) continue;
                this.y_ions.put(y, ymz);
                this.record_NL_ions(y, Z, ym);
            }
        }
    }

    private void record_NL_ions(String ion, double z, double orig_ion_mass) {
        String x;
        int start = ion.indexOf(":") + 1;
        int end = ion.length();
        if (ion.contains("/")) {
            end = ion.indexOf("/") - 1;
        }
        if (!globals.isDecoySeq(x = ion.substring(start, end))) {
            for (String nlr : globals.nlMap.keySet()) {
                String candResidues = nlr.substring(0, nlr.indexOf("-"));
                int numCandRes = 0;
                for (int i = 0; i < x.length(); ++i) {
                    String residue = Character.toString(x.charAt(i));
                    if (!candResidues.contains(residue)) continue;
                    ++numCandRes;
                }
                if (numCandRes <= 0) continue;
                double nl_mass = globals.nlMap.get(nlr);
                String NL_tag = nlr.substring(nlr.indexOf("-"));
                String nl_str = ion + NL_tag;
                double mass = orig_ion_mass + nl_mass;
                double mz = globals.round_dbl(mass / z, 4);
                if (!(mz > globals.minMZ)) continue;
                if (ion.startsWith("b")) {
                    this.b_ions.put(nl_str, mz);
                }
                if (!ion.startsWith("y")) continue;
                this.y_ions.put(nl_str, mz);
            }
        } else {
            for (Map.Entry<String, Double> e : globals.decoyNLmap.entrySet()) {
                String NL_tag = e.getKey();
                double nl_mass = e.getValue();
                String nl_str = ion + NL_tag;
                double mass = orig_ion_mass + nl_mass;
                double mz = globals.round_dbl(mass / z, 4);
                if (!(mz > globals.minMZ)) continue;
                if (ion.startsWith("b")) {
                    this.b_ions.put(nl_str, mz);
                }
                if (!ion.startsWith("y")) continue;
                this.y_ions.put(nl_str, mz);
            }
        }
    }

    private void calcNumDecoyPermutations() {
        double ctr = 0.0;
        double p = this.numPPS;
        double k = this.numRPS;
        for (int i = 0; i < this.pepLen; ++i) {
            String aa = Character.toString(this.peptide.charAt(i));
            if (globals.targetModMap.containsKey(aa)) continue;
            ctr += 1.0;
        }
        this.numDecoyPermutations = ctr >= p ? globals.SF.combinatorial(ctr, k) : 0.0;
    }

    double getNumPerm() {
        return this.numPermutations + this.numDecoyPermutations;
    }

    void printIons() {
        double m;
        for (String p : this.b_ions.keySet()) {
            m = globals.round_dbl(this.b_ions.get(p), 4);
            System.out.println(this.modPeptide + "\t" + p + "\t" + m);
        }
        for (String p : this.y_ions.keySet()) {
            m = globals.round_dbl(this.y_ions.get(p), 4);
            System.out.println(this.modPeptide + "\t" + p + "\t" + m);
        }
    }

    THashMap<String, Double> getPermutations(int permType) {
        THashMap<String, Double> ret = new THashMap<String, Double>();
        TIntArrayList candModSites = new TIntArrayList();
        ArrayList<Object> x = new ArrayList();
        int i = 0;
        if (permType == 0) {
            for (i = 0; i < this.pepLen; ++i) {
                String aa = Character.toString(this.peptide.charAt(i));
                if (!globals.targetModMap.containsKey(aa)) continue;
                candModSites.add(i);
            }
            x = globals.SF.getAllCombinations(candModSites, this.numRPS);
            for (TIntList tIntList : x) {
                String modPep = "";
                if (this.modPosMap.containsKey(-100)) {
                    modPep = "[";
                }
                for (i = 0; i < this.pepLen; ++i) {
                    String aa = Character.toString(this.peptide.charAt(i)).toLowerCase();
                    modPep = tIntList.contains(i) ? modPep + aa : (this.nonTargetMods.containsKey(i) ? modPep + aa : modPep + aa.toUpperCase());
                }
                if (this.modPosMap.containsKey(100)) {
                    modPep = "]";
                }
                ret.put(modPep, 0.0);
            }
        } else {
            for (i = 0; i < this.pepLen; ++i) {
                String AA = Character.toString(this.peptide.charAt(i));
                String string = AA.toLowerCase();
                int score = 0;
                if (!globals.targetModMap.containsKey(AA)) {
                    ++score;
                }
                if (!this.nonTargetMods.containsKey(string)) {
                    ++score;
                }
                if (score != 2) continue;
                candModSites.add(i);
            }
            x = globals.SF.getAllCombinations(candModSites, this.numRPS);
            for (TIntList tIntList : x) {
                String modPep = "";
                if (this.modPosMap.containsKey(-100)) {
                    modPep = "[";
                }
                for (i = 0; i < this.pepLen; ++i) {
                    String aa = Character.toString(this.peptide.charAt(i)).toLowerCase();
                    if (tIntList.contains(i)) {
                        String decoyChar = globals.getDecoySymbol(this.peptide.charAt(i));
                        modPep = modPep + decoyChar;
                        continue;
                    }
                    modPep = this.nonTargetMods.containsKey(i) ? modPep + aa : modPep + aa.toUpperCase();
                }
                if (this.modPosMap.containsKey(100)) {
                    modPep = "]";
                }
                ret.put(modPep, 0.0);
            }
        }
        return ret;
    }

    public THashMap<String, Double> getIonLadder() {
        THashMap<String, Double> ret = new THashMap<String, Double>();
        ret.putAll(this.b_ions);
        ret.putAll(this.y_ions);
        return ret;
    }

    void calcScore_CID() {
        if (this.matchedPeaks.isEmpty()) {
            this.score = 0.0;
        } else {
            ModelData_CID MD = globals.modelingMap_CID.get(this.charge);
            double intensityM = 0.0;
            double intensityU = 0.0;
            double distM = 0.0;
            double distU = 0.0;
            double Iscore = 0.0;
            double Dscore = 0.0;
            this.score = 0.0;
            for (PeakClass pk : this.matchedPeaks) {
                intensityU = globals.SF.log_gaussianProb(MD.mu_int_U, MD.var_int_U, pk.norm_intensity);
                distU = globals.SF.log_gaussianProb(MD.mu_dist_U, MD.var_dist_U, pk.dist);
                if (pk.matchedIonStr.startsWith("b")) {
                    intensityM = globals.SF.log_gaussianProb(MD.mu_int_B, MD.var_int_B, pk.norm_intensity);
                    distM = globals.SF.log_gaussianProb(MD.mu_dist_B, MD.var_dist_B, pk.dist);
                }
                if (pk.matchedIonStr.startsWith("y")) {
                    intensityM = globals.SF.log_gaussianProb(MD.mu_int_Y, MD.var_int_Y, pk.norm_intensity);
                    distM = globals.SF.log_gaussianProb(MD.mu_dist_Y, MD.var_dist_Y, pk.dist);
                }
                Iscore = intensityM - intensityU;
                Dscore = distM - distU;
                double intense_wt = 1.0 / (1.0 + FastMath.exp(-Iscore));
                double x = 0.0;
                x = Double.isNaN(Dscore) || Double.isInfinite(Dscore) ? 0.0 : intense_wt * Dscore;
                if (x < 0.0) {
                    x = 0.0;
                }
                pk.score = x;
                pk.distScore = Dscore;
                pk.intensityScore = Iscore;
                this.score += x;
            }
        }
    }

    boolean isDecoyPep() {
        boolean ret = false;
        int score = 0;
        for (int i = 0; i < this.pepLen; ++i) {
            String aa = Character.toString(this.modPeptide.charAt(i));
            if (!globals.isDecoyResidue(aa)) continue;
            ++score;
        }
        if (score > 0) {
            ret = true;
        }
        return ret;
    }

    void calcScore_HCD() {
        if (this.matchedPeaks.isEmpty()) {
            this.score = 0.0;
        } else {
            ModelData_HCD MD = globals.modelingMap_HCD.get(this.charge);
            double matchErr = 0.0;
            double decoyPadding = 1.0;
            double a = 0.0;
            double b = 0.0;
            if (this.isDecoyPep()) {
                decoyPadding = 2.0;
            }
            double intensityM = 0.0;
            double intensityU = 0.0;
            double distM = 0.0;
            double distU = 0.0;
            double Iscore = 0.0;
            double Dscore = 0.0;
            this.score = 0.0;
            for (PeakClass pk : this.matchedPeaks) {
                double x;
                intensityU = MD.getLogNPdensityInt('n', pk.norm_intensity);
                distU = 0.0;
                char ionType = pk.matchedIonStr.charAt(0);
                intensityM = MD.getLogNPdensityInt(ionType, pk.norm_intensity);
                distM = MD.getLogNPdensityDistPos(pk.dist);
                Iscore = intensityM - intensityU;
                Dscore = distM - distU;
                if (Double.isNaN(Iscore) || Double.isInfinite(Iscore)) {
                    Iscore = 0.0;
                }
                if (Double.isNaN(Dscore) || Double.isInfinite(Dscore)) {
                    Dscore = 0.0;
                }
                if ((x = Iscore + Dscore) < 0.0) {
                    x = 0.0;
                }
                pk.score = x;
                pk.distScore = Dscore;
                pk.intensityScore = Iscore;
                this.score += x;
            }
        }
    }

    public void matchPeaks(SpectrumClass obsPeakList) {
        ArrayList<PeakClass> cand;
        double theo_mz;
        double matchErr = 0.0;
        double a = 0.0;
        double b = 0.0;
        this.matchedPeaks = new ArrayList();
        int N = this.b_ions.size() + this.y_ions.size();
        TDoubleObjectHashMap<PeakClass> bestMatchMap = new TDoubleObjectHashMap<PeakClass>(N);
        for (String theo_ion : this.y_ions.keySet()) {
            theo_mz = this.y_ions.get(theo_ion);
            if (globals.ms2tol_units == 1) {
                double ppmErr = globals.ms2tol / 1.0E-6;
                matchErr = theo_mz * ppmErr;
            } else {
                matchErr = globals.ms2tol;
            }
            a = globals.round_dbl(theo_mz - (matchErr *= 0.5), 4);
            b = globals.round_dbl(theo_mz + matchErr, 4);
            cand = new ArrayList<PeakClass>();
            for (int i = 0; i < obsPeakList.N; ++i) {
                double obsMZ = globals.round_dbl(obsPeakList.mz[i], 4);
                if (!(obsMZ >= a) || !(obsMZ <= b)) continue;
                cand.add(obsPeakList.getPeakClassInstance(i));
            }
            if (!cand.isEmpty()) {
                Collections.sort(cand, PeakClass.comparator_intensity_hi2low);
                PeakClass pk = (PeakClass)cand.get(0);
                pk.matched = true;
                pk.matchedIonStr = theo_ion;
                pk.dist = pk.mz - theo_mz;
                if (bestMatchMap.containsKey(pk.mz)) {
                    PeakClass oldPK = (PeakClass)bestMatchMap.get(pk.mz);
                    if (Math.abs(oldPK.dist) > Math.abs(pk.dist)) {
                        bestMatchMap.put(pk.mz, pk);
                    }
                    oldPK = null;
                } else {
                    bestMatchMap.put(pk.mz, pk);
                }
            }
            cand.clear();
        }
        for (String theo_ion : this.b_ions.keySet()) {
            theo_mz = this.b_ions.get(theo_ion);
            if (globals.ms2tol_units == 1) {
                double ppmErr = globals.ms2tol / 1.0E-6;
                matchErr = theo_mz * ppmErr;
            } else {
                matchErr = globals.ms2tol;
            }
            a = globals.round_dbl(theo_mz - (matchErr *= 0.5), 4);
            b = globals.round_dbl(theo_mz + matchErr, 4);
            cand = new ArrayList();
            for (int i = 0; i < obsPeakList.N; ++i) {
                double obsMZ = globals.round_dbl(obsPeakList.mz[i], 4);
                if (!(obsMZ >= a) || !(obsMZ <= b)) continue;
                cand.add(obsPeakList.getPeakClassInstance(i));
            }
            if (!cand.isEmpty()) {
                Collections.sort(cand, PeakClass.comparator_intensity_hi2low);
                PeakClass pk = (PeakClass)cand.get(0);
                pk.matched = true;
                pk.matchedIonStr = theo_ion;
                pk.dist = pk.mz - theo_mz;
                if (bestMatchMap.containsKey(pk.mz)) {
                    PeakClass oldPK = (PeakClass)bestMatchMap.get(pk.mz);
                    if (Math.abs(oldPK.dist) > Math.abs(pk.dist)) {
                        bestMatchMap.put(pk.mz, pk);
                    }
                    oldPK = null;
                } else {
                    bestMatchMap.put(pk.mz, pk);
                }
            }
            cand.clear();
        }
        for (Object mz : (Object)bestMatchMap.keys()) {
            this.matchedPeaks.add((PeakClass)bestMatchMap.get((double)mz));
        }
        bestMatchMap.clear();
        bestMatchMap = null;
    }
}

