/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import lucxor.PeakClass;
import org.apache.commons.math3.util.FastMath;

public class SpectrumClass {
    public int N;
    public int maxI_index;
    public double maxI;
    public double[] mz = null;
    public double[] raw_intensity = null;
    public double[] rel_intensity = null;
    public double[] norm_intensity = null;

    public SpectrumClass(double[] mz_, double[] intensities_) {
        int i;
        this.N = mz_.length;
        this.maxI = 0.0;
        this.maxI_index = 0;
        if (mz_.length != intensities_.length) {
            this.N = Math.min(mz_.length, intensities_.length);
        }
        TIntArrayList candPks = new TIntArrayList(this.N);
        for (i = 0; i < this.N; ++i) {
            if (intensities_[i] == 0.0) continue;
            candPks.add(i);
        }
        this.N = candPks.size();
        this.mz = new double[this.N];
        this.raw_intensity = new double[this.N];
        this.norm_intensity = new double[this.N];
        this.rel_intensity = new double[this.N];
        for (i = 0; i < this.N; ++i) {
            int curIdx = candPks.get(i);
            if (intensities_[curIdx] > this.maxI) {
                this.maxI = intensities_[curIdx];
                this.maxI_index = curIdx;
            }
            this.mz[i] = mz_[curIdx];
            this.raw_intensity[i] = intensities_[curIdx];
        }
        candPks.clear();
        candPks = null;
        for (i = 0; i < this.N; ++i) {
            this.rel_intensity[i] = this.raw_intensity[i] / this.maxI * 100.0;
        }
    }

    public SpectrumClass() {
    }

    public void calcRelativeIntensity() {
        for (int i = 0; i < this.N; ++i) {
            this.rel_intensity[i] = this.raw_intensity[i] / this.maxI * 100.0;
        }
    }

    public void medianNormalizeSpectra() {
        int i;
        int mid = this.N / 2;
        double medianI = 0.0;
        ArrayList<Double> pksI = new ArrayList<Double>(this.N);
        for (i = 0; i < this.N; ++i) {
            pksI.add(this.rel_intensity[i]);
        }
        Collections.sort(pksI);
        if (this.N % 2 == 0) {
            int a = mid - 1;
            int b = mid;
            double aI = (Double)pksI.get(a);
            double bI = (Double)pksI.get(b);
            medianI = (aI + bI) / 2.0;
        } else {
            medianI = (Double)pksI.get(mid);
        }
        for (i = 0; i < this.N; ++i) {
            double d = this.rel_intensity[i] / medianI;
            this.norm_intensity[i] = FastMath.log(d);
        }
    }

    public double getPeak(int idx, int dt) {
        double ret = 0.0;
        switch (dt) {
            case 1: {
                ret = this.mz[idx];
                break;
            }
            case 2: {
                ret = this.raw_intensity[idx];
                break;
            }
            case 3: {
                ret = this.rel_intensity[idx];
                break;
            }
            case 4: {
                ret = this.norm_intensity[idx];
            }
        }
        return ret;
    }

    public boolean isEmpty() {
        if (null == this.mz) {
            return true;
        }
        return this.mz.length == 0;
    }

    public int findIndexByMZ(double passed_mz) {
        int ret = -1;
        for (int i = 0; i < this.N; ++i) {
            if (this.mz[i] != passed_mz) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public PeakClass getPeakClassInstance(int idx) {
        PeakClass ret = new PeakClass();
        ret.mz = this.mz[idx];
        ret.raw_intensity = this.raw_intensity[idx];
        ret.rel_intensity = this.rel_intensity[idx];
        ret.norm_intensity = this.norm_intensity[idx];
        return ret;
    }
}

