/*
 * Decompiled with CFR 0.152.
 */
package lucxor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.xml.parsers.ParserConfigurationException;
import lucxor.ModelData_CID;
import lucxor.ModelData_HCD;
import lucxor.PSM;
import lucxor.SpectrumClass;
import lucxor.statsFunctions;
import org.xml.sax.SAXException;
import umich.ms.datatypes.LCMSData;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.scancollection.ScanIndex;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLFile;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;

public class globals {
    static File spectrumPath = null;
    static String spectrumSuffix = null;
    static String matchedPkFile = null;
    static File inputFile = null;
    static String outputFile = null;
    static String timeStamp = null;
    static String dateStamp = null;
    static int ms2tol_units;
    static int inputType;
    static int debugMode;
    static int reduceNL;
    static int peptideRepresentation;
    static int scoringMethod;
    static int scoringAlgorithm;
    static int maxChargeState;
    static int minNumPSMsForModeling;
    static int numThreads;
    static int runMode;
    static int tsvHdr;
    static int maxPepLen;
    static double ms2tol;
    static double modelTH;
    static double scoreTH;
    static double decoyMass;
    static double minMZ;
    static double max_num_permutations;
    static double precursorNLmass;
    static double ntermMass;
    static double ctermMass;
    static double minRelIntensity;
    static boolean writeMatchedPeaks;
    static ArrayList<PSM> PSM_list;
    static THashMap<String, Double> targetModMap;
    static THashMap<String, Double> fixedModMap;
    static THashMap<String, Double> varModMap;
    static THashMap<String, Double> nlMap;
    static THashMap<String, Double> decoyNLmap;
    static THashMap<Double, double[]> FLRestimateMap;
    static THashMap<String, Double> AAmassMap;
    static THashMap<String, String> decoyAAMap;
    static THashMap<Integer, ModelData_CID> modelingMap_CID;
    static THashMap<Integer, ModelData_HCD> modelingMap_HCD;
    static statsFunctions SF;

    static void parse_input_file(String str) throws FileNotFoundException, IOException {
        String line;
        File inF = new File(str);
        if (!inF.exists()) {
            System.err.print("\nERROR! Unable to open " + str + "\n\n");
            System.exit(0);
        }
        debugMode = 0;
        runMode = 0;
        minRelIntensity = 0.0;
        minNumPSMsForModeling = 50;
        maxPepLen = 40;
        reduceNL = 0;
        numThreads = Runtime.getRuntime().availableProcessors();
        tsvHdr = 0;
        writeMatchedPeaks = false;
        BufferedReader br = new BufferedReader(new FileReader(inF));
        while ((line = br.readLine()) != null) {
            String[] ary;
            String s;
            if (line.startsWith("#") || line.length() < 2) continue;
            if (line.startsWith("SPECTRUM_PATH")) {
                s = globals.parse_input_line(line);
                spectrumPath = new File(s).getCanonicalFile();
            }
            if (line.startsWith("SPECTRUM_SUFFIX")) {
                s = globals.parse_input_line(line);
                spectrumSuffix = s.toLowerCase();
            }
            if (line.startsWith("INPUT_DATA")) {
                s = globals.parse_input_line(line);
                inputFile = new File(s);
            }
            if (line.startsWith("OUTPUT_FILE")) {
                outputFile = s = globals.parse_input_line(line);
            }
            if (line.startsWith("INPUT_TYPE")) {
                s = globals.parse_input_line(line);
                inputType = Integer.valueOf(s);
            }
            if (line.startsWith("MAX_PEP_LEN")) {
                s = globals.parse_input_line(line);
                maxPepLen = Integer.valueOf(s);
            }
            if (line.startsWith("MAX_NUM_PERM")) {
                s = globals.parse_input_line(line);
                max_num_permutations = Double.valueOf(s);
            }
            if (line.startsWith("MIN_NUM_PSMS_MODEL")) {
                s = globals.parse_input_line(line);
                minNumPSMsForModeling = Integer.valueOf(s);
            }
            if (line.startsWith("MS2_TOL") && !line.contains("_UNITS")) {
                s = globals.parse_input_line(line);
                ms2tol = Double.valueOf(s);
            }
            if (line.startsWith("MS2_TOL_UNITS")) {
                s = globals.parse_input_line(line);
                ms2tol_units = Integer.valueOf(s);
            }
            if (line.startsWith("ALGORITHM")) {
                s = globals.parse_input_line(line);
                scoringAlgorithm = Integer.valueOf(s);
            }
            if (line.startsWith("TSV_HEADER")) {
                s = globals.parse_input_line(line);
                tsvHdr = Integer.valueOf(s);
            }
            if (line.startsWith("REDUCE_PRECURSOR_NL")) {
                s = globals.parse_input_line(line);
                reduceNL = Integer.valueOf(s);
            }
            if (line.startsWith("PRECURSOR_NL_MASS_DIFF")) {
                s = globals.parse_input_line(line);
                precursorNLmass = Double.valueOf(s);
            }
            if (line.startsWith("SELECTION_METHOD")) {
                s = globals.parse_input_line(line);
                scoringMethod = Integer.valueOf(s);
            }
            if (line.startsWith("MODELING_SCORE_THRESHOLD")) {
                s = globals.parse_input_line(line);
                modelTH = Double.valueOf(s);
            }
            if (line.startsWith("MAX_CHARGE_STATE")) {
                s = globals.parse_input_line(line);
                maxChargeState = Integer.valueOf(s);
            }
            if (line.startsWith("NUM_THREADS")) {
                s = globals.parse_input_line(line);
                int x = Integer.valueOf(s);
                numThreads = x < 0 ? 1 : (x > 1 ? x - 1 : (x == 0 ? Runtime.getRuntime().availableProcessors() : x));
            }
            if (line.startsWith("DEBUG_MODE")) {
                s = globals.parse_input_line(line);
                debugMode = Integer.valueOf(s);
            }
            if (line.startsWith("WRITE_MATCHED_PEAKS_FILE") && (s = globals.parse_input_line(line)).equals("1")) {
                writeMatchedPeaks = true;
            }
            if (line.startsWith("RUN_MODE") && (runMode = Integer.valueOf(s = globals.parse_input_line(line)).intValue()) > 1) {
                runMode = 0;
            }
            if (line.startsWith("SCORING_THRESHOLD")) {
                s = globals.parse_input_line(line);
                scoreTH = Double.valueOf(s);
            }
            if (line.startsWith("DECOY_MASS")) {
                s = globals.parse_input_line(line);
                decoyMass = Double.valueOf(s);
            }
            if (line.startsWith("DECOY_NL")) {
                ary = globals.parse_NL_line(line);
                String k = ary[0].substring(1);
                double m = Double.valueOf(ary[1]);
                decoyNLmap.put(k, m);
            }
            if (line.startsWith("NL")) {
                ary = globals.parse_NL_line(line);
                double m = Double.valueOf(ary[1]);
                nlMap.put(ary[0], m);
            }
            if (line.startsWith("MIN_MZ")) {
                s = globals.parse_input_line(line);
                minMZ = Double.valueOf(s);
            }
            if (line.startsWith("MOD_PEP_REP")) {
                s = globals.parse_input_line(line);
                peptideRepresentation = Integer.valueOf(s);
            }
            if (line.startsWith("TARGET_MOD")) {
                ary = globals.parse_input_mod_line(line);
                double m = Double.valueOf(ary[1]);
                targetModMap.put(ary[0].toUpperCase(), m);
            }
            if (inputType != 1) continue;
            if (line.startsWith("VAR_MOD")) {
                ary = globals.parse_input_mod_line(line);
                double m = Double.valueOf(ary[1]);
                varModMap.put(ary[0].toLowerCase(), m);
            }
            if (!line.startsWith("FIXED_MOD")) continue;
            ary = globals.parse_input_mod_line(line);
            double m = Double.valueOf(ary[1]);
            fixedModMap.put(ary[0].toUpperCase(), m);
        }
        br.close();
        if (null == outputFile || outputFile.isEmpty()) {
            outputFile = "luciphor_results.tsv";
        }
        String classStr = "";
        switch (scoringMethod) {
            case 0: {
                classStr = "Peptide Prophet Prob.";
                break;
            }
            case 1: {
                classStr = "Mascot Ion Score";
                break;
            }
            case 2: {
                classStr = "-log(Expect Value) (X!Tandem or Comet)";
                break;
            }
            case 3: {
                classStr = "X!Tandem Hyperscore";
                break;
            }
            case 4: {
                classStr = "Sequest XCorr";
                break;
            }
            default: {
                System.err.print("\nERROR! Unknown scoring method: " + scoringMethod + "\n\n");
                System.exit(0);
            }
        }
        int NCPU = numThreads;
        if (numThreads > 1 && numThreads < Runtime.getRuntime().availableProcessors()) {
            NCPU = numThreads + 1;
        }
        System.err.println("Spectrum Path:           " + spectrumPath.getAbsolutePath());
        System.err.println("Spectrum Suffix:         " + spectrumSuffix);
        System.err.println("Input file:              " + inputFile);
        System.err.println("Input type:              " + (inputType == 0 ? "pepXML" : "tsv"));
        System.err.println("MS2 tolerance:           " + ms2tol + (ms2tol_units == 0 ? " Da" : " ppm"));
        System.err.println("Luciphor Algorithm:      " + (scoringAlgorithm == 0 ? "CID" : "HCD"));
        System.err.println("Classifying on:          " + classStr);
        System.err.println("Run Mode:                " + (runMode == 0 ? "Default" : "Report Decoys"));
        System.err.println("Num of Threads:          " + NCPU);
        System.err.println("Modeling Threshold:      " + modelTH);
        System.err.println("Scoring Threshold:       " + scoreTH);
        System.err.println("Permutation Limit:       " + max_num_permutations);
        System.err.println("Max peptide length:      " + maxPepLen);
        System.err.println("Min num PSMs for model:  " + minNumPSMsForModeling);
        System.err.println("Decoy Mass Adduct:       " + decoyMass);
        System.err.println("Max Charge State:        " + maxChargeState);
        System.err.println("Reduce NL:               " + (reduceNL == 0 ? "no" : "yes"));
        System.err.println("Output File:             " + outputFile);
        System.err.println("Write matched Peaks:     " + (writeMatchedPeaks ? "yes" : "no"));
        System.err.print("\n");
        if (debugMode != 0) {
            System.err.println("Debug mode:              " + debugMode + "  (Limiting to 1 CPU)\n");
            numThreads = 1;
        }
        System.err.println("Mods to score:");
        for (String s : targetModMap.keySet()) {
            System.err.println(s + "\t" + targetModMap.get(s));
        }
        if (!nlMap.isEmpty()) {
            System.err.println("\nAllowed Neutral Losses:");
            for (String s : nlMap.keySet()) {
                System.err.println(s + "\t" + nlMap.get(s));
            }
            for (String s : decoyNLmap.keySet()) {
                System.err.println("<X>" + s + "\t" + decoyNLmap.get(s) + "  (Decoy NL)");
            }
        }
    }

    static String parse_input_line(String line) {
        int b;
        char c;
        String ret = "";
        StringBuilder sb = new StringBuilder();
        int N = line.length();
        for (int i = b = line.indexOf("=") + 1; i < N && (c = line.charAt(i)) != '#'; ++i) {
            if (c == ' ') continue;
            sb.append(c);
        }
        ret = sb.toString();
        return ret;
    }

    static String[] parse_input_mod_line(String line) {
        int b;
        char c;
        String[] ret = new String[2];
        char aa = '\u0000';
        StringBuilder sb = new StringBuilder();
        double mass = 0.0;
        int N = line.length();
        for (int i = b = line.indexOf("=") + 1; i < N && (c = line.charAt(i)) != '#'; ++i) {
            if (c == ' ') continue;
            if (Character.isAlphabetic(c)) {
                aa = c;
                continue;
            }
            if (c == '[' || c == ']') {
                aa = c;
                continue;
            }
            sb.append(c);
        }
        mass = Double.valueOf(sb.toString());
        ret[0] = Character.toString(aa);
        ret[1] = String.valueOf(mass);
        return ret;
    }

    static String[] parse_NL_line(String line) {
        String[] ret = new String[2];
        line = line.replaceAll("#", "");
        String[] tmp = line.split("\\s+");
        ret[0] = tmp[2] + tmp[3];
        ret[1] = tmp[4];
        return ret;
    }

    static void initialize() {
        PSM_list = new ArrayList();
        decoyAAMap = new THashMap();
        AAmassMap = new THashMap();
        targetModMap = new THashMap();
        fixedModMap = new THashMap();
        varModMap = new THashMap();
        nlMap = new THashMap();
        decoyNLmap = new THashMap();
        ntermMass = 0.0;
        ctermMass = 0.0;
        timeStamp = "";
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMMdd-hh_mm_ss");
        timeStamp = sdf.format(date);
        sdf = new SimpleDateFormat("yyyMMMdd");
        dateStamp = sdf.format(date);
        SF = new statsFunctions();
        AAmassMap.put("A", 71.03711);
        AAmassMap.put("R", 156.10111);
        AAmassMap.put("N", 114.04293);
        AAmassMap.put("D", 115.02694);
        AAmassMap.put("C", 103.00919);
        AAmassMap.put("E", 129.04259);
        AAmassMap.put("Q", 128.05858);
        AAmassMap.put("G", 57.02146);
        AAmassMap.put("H", 137.05891);
        AAmassMap.put("I", 113.08406);
        AAmassMap.put("L", 113.08406);
        AAmassMap.put("K", 128.09496);
        AAmassMap.put("M", 131.04049);
        AAmassMap.put("F", 147.06841);
        AAmassMap.put("P", 97.05276);
        AAmassMap.put("S", 87.03203);
        AAmassMap.put("T", 101.04768);
        AAmassMap.put("W", 186.07931);
        AAmassMap.put("Y", 163.06333);
        AAmassMap.put("V", 99.06841);
        decoyAAMap.put("2", "A");
        decoyAAMap.put("3", "R");
        decoyAAMap.put("4", "N");
        decoyAAMap.put("5", "D");
        decoyAAMap.put("6", "C");
        decoyAAMap.put("7", "E");
        decoyAAMap.put("8", "Q");
        decoyAAMap.put("9", "G");
        decoyAAMap.put("0", "H");
        decoyAAMap.put("@", "I");
        decoyAAMap.put("#", "L");
        decoyAAMap.put("$", "K");
        decoyAAMap.put("%", "M");
        decoyAAMap.put("&", "F");
        decoyAAMap.put(";", "P");
        decoyAAMap.put("?", "W");
        decoyAAMap.put("~", "V");
        decoyAAMap.put("^", "S");
        decoyAAMap.put("*", "T");
        decoyAAMap.put("=", "Y");
    }

    public static void loadUserMods() {
        String symbol;
        double mass;
        for (String c : targetModMap.keySet()) {
            mass = AAmassMap.get(c) + targetModMap.get(c);
            symbol = c.toLowerCase();
            AAmassMap.put(symbol, mass);
        }
        for (String c : fixedModMap.keySet()) {
            mass = AAmassMap.get(c) + fixedModMap.get(c);
            symbol = c.toUpperCase();
            AAmassMap.put(symbol, mass);
        }
        for (String c : varModMap.keySet()) {
            if (c.equalsIgnoreCase("[")) {
                ntermMass = varModMap.get(c);
                continue;
            }
            if (c.equalsIgnoreCase("]")) {
                ctermMass = varModMap.get(c);
                continue;
            }
            mass = AAmassMap.get(c.toUpperCase()) + varModMap.get(c);
            AAmassMap.put(c, mass);
        }
        for (String c : decoyAAMap.keySet()) {
            String trueAA = decoyAAMap.get(c);
            if (varModMap.containsKey(trueAA) || targetModMap.containsKey(trueAA)) continue;
            double mass2 = AAmassMap.get(trueAA) + decoyMass;
            AAmassMap.put(c, mass2);
        }
    }

    static void recordModsFromPepXML() {
        String C;
        String alphabet = "ACDEFGHIKLMNPQRSTVWY";
        for (String c : fixedModMap.keySet()) {
            if (!alphabet.contains(c)) continue;
            double mass = AAmassMap.get(c) + fixedModMap.get(c);
            String symbol = c.toUpperCase();
            AAmassMap.put(symbol, mass);
        }
        HashMap<String, Double> tmp = new HashMap<String, Double>();
        tmp.putAll(varModMap);
        varModMap.clear();
        for (String c : tmp.keySet()) {
            C = c.toUpperCase();
            double mass = (Double)tmp.get(c);
            if (!alphabet.contains(C) || targetModMap.containsKey(C)) continue;
            varModMap.put(c, mass);
        }
        tmp = null;
        for (String c : varModMap.keySet()) {
            C = c.toUpperCase();
            double mass = AAmassMap.get(C) + varModMap.get(c);
            AAmassMap.put(c, mass);
        }
    }

    public static double round_dbl(double value, int numPlaces) {
        double ret = 0.0;
        double N = Math.pow(10.0, numPlaces);
        ret = (double)Math.round(value * N) / N;
        return ret;
    }

    static void read_in_spectra() throws IOException, IllegalStateException, SAXException, ParserConfigurationException, DataFormatException, FileParsingException {
        System.err.println("\nReading spectra from " + spectrumPath.getCanonicalPath() + "  (" + spectrumSuffix.toUpperCase() + " format)");
        System.err.println("This can take a while so please be patient.");
        ArrayListMultimap<String, Integer> scanMap = ArrayListMultimap.create();
        int droppedPSMs = 0;
        Iterator<PSM> iter = PSM_list.iterator();
        while (iter.hasNext()) {
            PSM p = iter.next();
            String pathStr = spectrumPath + "/" + p.srcFile;
            File f = new File(pathStr);
            if (!f.exists()) {
                ++droppedPSMs;
                iter.remove();
                continue;
            }
            scanMap.put(f.getAbsolutePath(), p.scanNum);
        }
        if (spectrumSuffix.equalsIgnoreCase("mgf")) {
            TIntObjectHashMap<SpectrumClass> curSpectra = null;
            for (String specFile : scanMap.keySet()) {
                curSpectra = globals.read_mgf(specFile);
                String fn = new File(specFile).getName();
                int assignedSpectraCtr = 0;
                for (PSM p : PSM_list) {
                    if (!p.srcFile.equalsIgnoreCase(fn) || !curSpectra.containsKey(p.scanNum)) continue;
                    p.recordSpectra(curSpectra.get(p.scanNum));
                    ++assignedSpectraCtr;
                }
                System.err.println(fn + ": " + assignedSpectraCtr + " spectra read in.");
            }
        } else if (spectrumSuffix.equalsIgnoreCase("mzXML")) {
            globals.read_mzXML(scanMap);
        } else if (spectrumSuffix.equalsIgnoreCase("mzML")) {
            globals.read_mzML(scanMap);
        }
    }

    private static void read_mzML(Multimap<String, Integer> scanMap) throws FileParsingException {
        for (String fn : scanMap.keySet()) {
            String baseFN = new File(fn).getName();
            System.err.print("\n" + baseFN + ":  ");
            int ctr = 0;
            int iter = 0;
            List scanNums = (List)scanMap.get(fn);
            Collections.sort(scanNums);
            String mzML_path = spectrumPath + "/" + baseFN;
            MZMLFile curMZML = new MZMLFile(mzML_path);
            Iterator iterator = scanNums.iterator();
            while (iterator.hasNext()) {
                double[] intensities;
                IScan scan;
                ISpectrum spectrum;
                int N;
                int scanNum = (Integer)iterator.next();
                if (++iter % 100 == 0) {
                    System.err.print("\r" + baseFN + ":  " + iter + "... ");
                }
                if ((N = (spectrum = (scan = curMZML.parseScan(scanNum, true)).getSpectrum()).getMZs().length) == 0) continue;
                double[] mz = spectrum.getMZs();
                if (mz.length != (intensities = spectrum.getIntensities()).length) {
                    System.err.print("\nERROR:" + baseFN + " Scan: " + scanNum + "\n# of mz values != # intensity values: " + mz.length + " != " + intensities.length + "\nSkipping this scan...\n");
                    continue;
                }
                SpectrumClass X = new SpectrumClass(mz, intensities);
                for (PSM p : PSM_list) {
                    if (!p.srcFile.equalsIgnoreCase(baseFN) || p.scanNum != scanNum) continue;
                    p.recordSpectra(X);
                    ++ctr;
                    break;
                }
                X = null;
            }
            System.err.print("\r" + baseFN + ":  " + ctr + " spectra read in.            ");
        }
    }

    static double getFragmentIonMass(String x, double z, double addl_mass) {
        double ret = 1.00728 * z;
        int start = x.indexOf(":") + 1;
        int stop = x.length();
        if (x.contains("-")) {
            stop = x.indexOf("-");
        }
        for (int i = start; i < stop; ++i) {
            String c = Character.toString(x.charAt(i));
            if (!AAmassMap.containsKey(c)) continue;
            double mass = AAmassMap.get(c);
            ret += mass;
        }
        return ret += addl_mass;
    }

    private static TIntObjectHashMap<SpectrumClass> read_mgf(String specFile) throws FileNotFoundException, IOException {
        String line;
        TIntObjectHashMap<SpectrumClass> ret = new TIntObjectHashMap<SpectrumClass>();
        File mgf = new File(specFile);
        BufferedReader br = new BufferedReader(new FileReader(mgf));
        int scanNum = 0;
        SpectrumClass S = null;
        ArrayList<Double> mzAL = null;
        ArrayList<Double> intensityAL = null;
        while ((line = br.readLine()) != null) {
            if (line.length() < 2) continue;
            if (line.startsWith("END IONS")) {
                if (null != mzAL && !mzAL.isEmpty()) {
                    int N = mzAL.size();
                    double[] mz = new double[N];
                    double[] I = new double[N];
                    for (int i = 0; i < N; i = (int)((short)(i + 1))) {
                        mz[i] = (Double)mzAL.get(i);
                        I[i] = (Double)intensityAL.get(i);
                    }
                    S = new SpectrumClass(mz, I);
                    ret.put(scanNum, S);
                    mzAL = null;
                    intensityAL = null;
                    mz = null;
                    I = null;
                }
                S = null;
                scanNum = 0;
            }
            if (line.startsWith("BEGIN IONS")) {
                mzAL = new ArrayList<Double>();
                intensityAL = new ArrayList<Double>();
            }
            if (line.startsWith("TITLE=")) {
                int i = line.indexOf(".") + 1;
                int j = line.indexOf(".", i);
                String s = line.substring(i, j);
                scanNum = Integer.valueOf(s);
            }
            if (line.startsWith("CHARGE") || line.startsWith("PEPMASS") || !Character.isDigit(line.charAt(0))) continue;
            String[] ary = line.split("\\s+");
            double mz = globals.round_dbl(Double.valueOf(ary[0]), 8);
            double I = globals.round_dbl(Double.valueOf(ary[1]), 8);
            mzAL.add(mz);
            intensityAL.add(I);
        }
        return ret;
    }

    private static void read_mzXML(Multimap<String, Integer> scanMap) throws IllegalStateException, IOException, SAXException, ParserConfigurationException, DataFormatException, FileParsingException {
        for (String fn : scanMap.keySet()) {
            String baseFN = new File(fn).getName();
            System.err.print(baseFN + ":  ");
            int ctr = 0;
            List scanNums = (List)scanMap.get(fn);
            Collections.sort(scanNums);
            int N = numThreads;
            if (numThreads > 1) {
                --N;
            }
            MZXMLFile mzxml = new MZXMLFile(fn, false);
            mzxml.setNumThreadsForParsing(N);
            mzxml.setParsingTimeout(60L);
            LCMSData lcmsData = new LCMSData(mzxml);
            lcmsData.load(LCMSDataSubset.MS2_WITH_SPECTRA);
            IScanCollection scans = lcmsData.getScans();
            ScanIndex ms2ScanIndex = scans.getMapMsLevel2index().get(2);
            if (ms2ScanIndex == null || ms2ScanIndex.getNum2scan().isEmpty()) {
                System.err.println("\nERROR: globals.read_mzXML(): Unable to read MS2 scans from '" + fn + "'\n");
                System.exit(0);
            }
            block1: for (Map.Entry<Integer, IScan> num2scan : ms2ScanIndex.getNum2scan().entrySet()) {
                int scanNum = num2scan.getKey();
                IScan scan = num2scan.getValue();
                double[] mz = scan.getSpectrum().getMZs();
                double[] intensities = scan.getSpectrum().getIntensities();
                SpectrumClass curSpectrum = new SpectrumClass(mz, intensities);
                for (PSM p : PSM_list) {
                    if (!p.srcFile.equalsIgnoreCase(baseFN) || p.scanNum != scanNum) continue;
                    p.recordSpectra(curSpectrum);
                    ++ctr;
                    continue block1;
                }
            }
            System.err.println(ctr + " spectra read in.");
        }
    }

    static String getDecoySymbol(char c) {
        String ret = "";
        String srcChar = Character.toString(c);
        for (String k : decoyAAMap.keySet()) {
            String v = decoyAAMap.get(k);
            if (!v.equalsIgnoreCase(srcChar)) continue;
            ret = k;
            break;
        }
        return ret;
    }

    static String getTPPresidue(String c) {
        String ret = "";
        String orig = "";
        if (c.equalsIgnoreCase("[")) {
            int d = (int)Math.round(ntermMass) + 1;
            ret = "n[" + String.valueOf(d) + "]";
        } else if (c.equals("]")) {
            int d = (int)Math.round(ctermMass);
            ret = ret + "c[" + String.valueOf(d) + "]";
        } else {
            int i = (int)Math.round(AAmassMap.get(c));
            orig = globals.isDecoyResidue(c) ? decoyAAMap.get(c) : c.toUpperCase();
            ret = orig + "[" + String.valueOf(i) + "]";
        }
        return ret;
    }

    static boolean isDecoySeq(String seq) {
        boolean ret = false;
        int score = 0;
        for (int i = 0; i < seq.length(); ++i) {
            String c = Character.toString(seq.charAt(i));
            if (c.equalsIgnoreCase("[") || c.equalsIgnoreCase("]") || !globals.isDecoyResidue(c)) continue;
            ++score;
        }
        if (score > 0) {
            ret = true;
        }
        return ret;
    }

    static boolean isDecoyResidue(String AA) {
        boolean ret = false;
        if (decoyAAMap.containsKey(AA)) {
            ret = true;
        }
        return ret;
    }

    static void writeTemplateInputFile() throws IOException {
        File outF = new File("luciphor2_input_template.txt");
        FileWriter fw = new FileWriter(outF.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("## Input file for Luciphor2 (aka: LucXor).\n## Anything after a hash '#' is ignored\n");
        bw.write("## By default, these initial parameters are for performing a phosphorylation search\n\n");
        bw.write("SPECTRUM_PATH = <fill_in> ## specify the path to the spectra here\n");
        bw.write("SPECTRUM_SUFFIX = MGF     ## available options are MGF, mzML, or mzXML\n\n");
        bw.write("## Specify your input PSM results format\nINPUT_DATA = <fill_in> ## specify the path to the pepXML or tab-delimited file here\nINPUT_TYPE = 0   ## 0 = TPP pepXML, 1 = tab-delimited file\n");
        bw.write("ALGORITHM = 0    ## 0 = CID method, 1 = HCD method\n\n");
        bw.write("TSV_HEADER = 0 ## This pertains ONLY to tab-delimited (TSV) input data\n               ## 0 = the input file does NOT contain column names as the first row\n               ## 1 = the first row of the input file is the column names\n\n");
        bw.write("MS2_TOL = 0.5      ## MS/MS fragment ion tolerance\nMS2_TOL_UNITS = 0  ## 0 = Daltons, 1 = PPM\n\n");
        bw.write("MIN_MZ = 150.0 ## do not consider peaks below this value for matching fragment ions\n\n");
        bw.write("OUTPUT_FILE =  ## Specify the path to your desired output filename here\n               ## A default value will be used if nothing is specified here.\n\n");
        bw.write("WRITE_MATCHED_PEAKS_FILE = 0 ## Generate a tab-delimited file of all the matched peaks\n                             ## for the top 2 predictions of each spectra\n                             ## Useful for plotting spectra\n                             ## 0 = no, 1 = yes\n\n");
        bw.write("## Place here any FIXED modifications that were used in your search\n## This field is ONLY used for tab-delimited input\n## Syntax: FIXED_MOD = <RESIDUE> <MODIFICATION_MASS>\n## For N-terminal modifications use '[' for the residue character\n## For C-terminal modifications use ']' for the residue character\nFIXED_MOD = C 57.021464\n\n");
        bw.write("## Place here any VARIABLE modifications that might be encountered that you don't\n## want luciphor to score.\n## This field is ONLY used for tab-delimited input\n## Syntax: VAR_MOD = <RESIDUE> <MODIFICATION_MASS>\n## For N-terminal modifications use '[' for the residue character\n## For C-terminal modifications use ']' for the residue character\nVAR_MOD = M 15.994915\n\n");
        bw.write("## List the amino acids to be searched for and their mass modifications\n## Syntax: TARGET_MOD = <RESIDUE> <MODIFICATION_MASS>\nTARGET_MOD = S 79.966331\nTARGET_MOD = T 79.966331\nTARGET_MOD = Y 79.966331\n\n");
        bw.write("## List the types of neutral losses that you want to consider\n## The residue field is case sensitive. For example: lower case 'sty' implies\n## that the neutral loss can only occur if the specified modification is present\n## Syntax: NL = <RESDIUES> -<NEUTRAL_LOSS_MOLECULAR_FORMULA> <MASS_LOST>\n#NL = STE -H2O -18.01056    ## a correctly formatted example, (not actually recommended for phospho-searches)\n#NL = RKQN -NH3 -17.026548  ## another correctly formatted example, (again not recommended for phospho-searches)\nNL = sty -H3PO4 -97.97690\n\n");
        bw.write("DECOY_MASS = 79.966331  ## how much to add to an amino acid to make it a decoy\n\n");
        bw.write("## For handling the neutral loss from a decoy sequence.\n## The syntax for this is identical to that of the normal neutral losses given\n## above except that the residue is always 'X'\n## Syntax: DECOY_NL = X -<NEUTRAL_LOSS_MOLECULAR_FORMULA> <MASS_LOST>\nDECOY_NL = X -H3PO4 -97.97690\n\n");
        bw.write("MAX_CHARGE_STATE = 5 ## do not consider PSMs with a charge state above this value\n");
        bw.write("MAX_PEP_LEN = 40 ## restrict scoring to peptides with a length shorter than this value\n");
        bw.write("MAX_NUM_PERM = 16384 ## the maximum number of permutations a sequence can have\n\n");
        bw.write("SELECTION_METHOD = 0   ## 0 = Peptide Prophet probability (default)\n                       ## 1 = Mascot Ion Score\n                       ## 2 = -log(E-value)\n                       ## 3 = X!Tandem Hyperscore\n                       ## 4 = Sequest Xcorr\n\n");
        bw.write("MODELING_SCORE_THRESHOLD = 0.95 ## minimum score a PSM needs to be considered for modeling\n");
        bw.write("SCORING_THRESHOLD = 0    ## PSMs below this value will be discarded\n");
        bw.write("MIN_NUM_PSMS_MODEL = 50  ## The minimum number of PSMs you need for any charge state in order to build a model for it\n\n");
        bw.write("MOD_PEP_REP = 0 ## 0 = show single character modifications, 1 = show TPP-formatted modifications\n\n");
        bw.write("NUM_THREADS = 0 ## For multi-threading, zero = use all CPU found by JAVA\n\n");
        bw.write("RUN_MODE = 0 ## Determines how Luciphor will run.\n             ## 0 = Default: calculate FLR then rerun scoring without decoys (two iterations)\n             ## 1 = Report Decoys: calculate FLR but don't rescore PSMs, all decoy hits will be reported\n\n");
        bw.write("## This option can be used to help diagnose problems with Luciphor. Multi-threading is disabled in debug mode.\nDEBUG_MODE = 0 ## 0 = default: turn off debugging\n               ## 1 = write peaks selected for modeling to disk\n               ## 2 = write the scores of all permutations for each PSM to disk\n               ## 3 = write the matched peaks for the top scoring permutation to disk\n               ## 4 = write HCD non-parametric models to disk (HCD-mode only option)\n\n");
        bw.close();
        System.err.print("\nPlease edit the input file: " + outF.getPath() + " with your favorite text editor\n\n");
        System.exit(0);
    }

    public static void recordFLRestimates() {
        FLRestimateMap = new THashMap();
        for (PSM p : PSM_list) {
            if (p.isDecoy) continue;
            double[] d = new double[]{p.globalFDR, p.localFDR};
            FLRestimateMap.put(p.deltaScore, d);
        }
    }

    public static void assignFLR() {
        ArrayList<Double> obsDeltaScores = new ArrayList<Double>(FLRestimateMap.keySet());
        Collections.sort(obsDeltaScores);
        int N = obsDeltaScores.size();
        for (PSM p : PSM_list) {
            double obs_ds = p.deltaScore;
            boolean assigned = false;
            int i = 0;
            for (i = 1; i < N; ++i) {
                double curDS = obsDeltaScores.get(i);
                if (!(curDS > obs_ds)) continue;
                double[] d = FLRestimateMap.get(obsDeltaScores.get(i - 1));
                p.globalFDR = d[0];
                p.localFDR = d[1];
                assigned = true;
                break;
            }
            if (assigned) continue;
            double[] d = FLRestimateMap.get(obsDeltaScores.get(N - 1));
            p.globalFDR = d[0];
            p.localFDR = d[1];
        }
    }

    public static void clearPSMs() {
        for (PSM p : PSM_list) {
            p.clearScores();
        }
    }

    static {
        PSM_list = null;
        targetModMap = null;
        fixedModMap = null;
        varModMap = null;
        nlMap = null;
        decoyNLmap = null;
        FLRestimateMap = null;
        AAmassMap = null;
        decoyAAMap = null;
        modelingMap_CID = null;
        modelingMap_HCD = null;
        SF = null;
    }
}

