/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.util.StringBuilderFormattable;

@Plugin(name="MessagePatternConverter", category="Converter")
@ConverterKeys(value={"m", "msg", "message"})
public final class MessagePatternConverter
extends LogEventPatternConverter {
    private final String[] formats;
    private final Configuration config;

    private MessagePatternConverter(Configuration config, String[] options) {
        super("Message", "message");
        this.formats = options;
        this.config = config;
    }

    public static MessagePatternConverter newInstance(Configuration config, String[] options) {
        return new MessagePatternConverter(config, options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        Message msg = event.getMessage();
        if (msg instanceof StringBuilderFormattable) {
            int offset = toAppendTo.length();
            ((StringBuilderFormattable)((Object)msg)).formatTo(toAppendTo);
            if (this.config != null) {
                for (int i = offset; i < toAppendTo.length() - 1; ++i) {
                    if (toAppendTo.charAt(i) != '$' || toAppendTo.charAt(i + 1) != '{') continue;
                    String value = toAppendTo.substring(offset, toAppendTo.length());
                    toAppendTo.setLength(offset);
                    toAppendTo.append(this.config.getStrSubstitutor().replace(event, value));
                }
            }
            return;
        }
        if (msg != null) {
            String result = msg instanceof MultiformatMessage ? ((MultiformatMessage)msg).getFormattedMessage(this.formats) : msg.getFormattedMessage();
            if (result != null) {
                toAppendTo.append(this.config != null && result.contains("${") ? this.config.getStrSubstitutor().replace(event, result) : result);
            } else {
                toAppendTo.append("null");
            }
        }
    }
}

