/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.biojava.nbio.ontology.IntegerOntology;
import org.biojava.nbio.ontology.Ontology;
import org.biojava.nbio.ontology.OntologyException;
import org.biojava.nbio.ontology.OntologyFactory;
import org.biojava.nbio.ontology.Term;
import org.biojava.nbio.ontology.io.TabDelimParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OntoTools {
    private static final Logger logger = LoggerFactory.getLogger(OntoTools.class);
    private static final Ontology CORE_ONTOLOGY;
    private static final OntologyFactory DEFAULT_FACTORY;
    private static final IntegerOntology CORE_INTEGER;
    public static final Term RELATION;
    public static final Term ANY;
    public static final Term NONE;
    public static final Term IS_A;
    public static final Term PART_OF;
    public static final Term REFLEXIVE;
    public static final Term SYMMETRIC;
    public static final Term TRANSITIVE;
    public static final Term EQUIVALENCE;
    public static final Term PARTIAL_ORDER;

    private OntoTools() {
    }

    public static Ontology getCoreOntology() {
        return CORE_ONTOLOGY;
    }

    public static IntegerOntology getIntegerOntology() {
        return CORE_INTEGER;
    }

    public static OntologyFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    static {
        DEFAULT_FACTORY = new OntologyFactory(){

            @Override
            public Ontology createOntology(String name, String desc) throws OntologyException {
                return new Ontology.Impl(name, desc);
            }
        };
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(OntoTools.class.getResourceAsStream("/ontology/core.onto")));
            CORE_INTEGER = new IntegerOntology();
            CORE_ONTOLOGY = new TabDelimParser().parse(reader, DEFAULT_FACTORY);
            RELATION = CORE_ONTOLOGY.getTerm("relation");
            ANY = CORE_ONTOLOGY.getTerm("any");
            NONE = CORE_ONTOLOGY.getTerm("none");
            IS_A = CORE_ONTOLOGY.getTerm("is-a");
            PART_OF = CORE_ONTOLOGY.getTerm("part-of");
            REFLEXIVE = CORE_ONTOLOGY.getTerm("reflexive");
            EQUIVALENCE = CORE_ONTOLOGY.getTerm("equivalence");
            SYMMETRIC = CORE_ONTOLOGY.getTerm("symmetric");
            TRANSITIVE = CORE_ONTOLOGY.getTerm("transitive");
            PARTIAL_ORDER = CORE_ONTOLOGY.getTerm("partial-order");
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            throw new RuntimeException("Could not initialize OntoTools", e);
        }
    }
}

