/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics;

import org.paukov.combinatorics.IntegerGenerator;
import org.paukov.combinatorics.IntegerVector;
import org.paukov.combinatorics.composition.IntegerCompositionGenerator;
import org.paukov.combinatorics.subsets.IntegerSubSetGenerator;

public class IntegerFactory {
    public static IntegerVector createIntegerVector() {
        return new IntegerVector(0);
    }

    public static IntegerVector createIntegerVector(int n) {
        return new IntegerVector(n);
    }

    public static IntegerVector createIntegerVector(int[] nArray) {
        return new IntegerVector(nArray);
    }

    public static IntegerVector createIntegerVector(int[] nArray, int n) {
        return new IntegerVector(nArray, n);
    }

    public static IntegerGenerator createIntegerSubSetGenerator(IntegerVector integerVector) {
        return new IntegerSubSetGenerator(integerVector);
    }

    public static IntegerGenerator createIntegerSubSetGenerator(IntegerVector integerVector, boolean bl) {
        return new IntegerSubSetGenerator(integerVector, bl);
    }

    public static IntegerGenerator createIntegerCompositionGenerator(Integer n) {
        return new IntegerCompositionGenerator(n);
    }

    public static IntegerVector range(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Range value must be more or equal to 0");
        }
        if (n == 0) {
            return new IntegerVector();
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i + 1;
        }
        return new IntegerVector(nArray);
    }

    public static IntegerVector range(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("From parameter must be less then To parameter");
        }
        int[] nArray = new int[n2 - n + 1];
        for (int i = 0; i < n2 - n + 1; ++i) {
            nArray[i] = new Integer(i + n);
        }
        return new IntegerVector(nArray);
    }
}

