/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.combination.simple;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.combination.simple.SimpleCombinationGenerator;

public class SimpleCombinationIterator<T>
implements Iterator<ICombinatoricsVector<T>> {
    protected final SimpleCombinationGenerator<T> _generator;
    protected ICombinatoricsVector<T> _currentSimpleCombination = null;
    protected long _currentIndex = 0L;
    protected final int _lengthN;
    protected final int _lengthK;
    private int[] _bitVector = null;
    private int _endIndex = 0;

    public SimpleCombinationIterator(SimpleCombinationGenerator<T> simpleCombinationGenerator) {
        this._generator = simpleCombinationGenerator;
        this._lengthN = simpleCombinationGenerator.getOriginalVector().getSize();
        this._lengthK = simpleCombinationGenerator.getCombinationLength();
        this._currentSimpleCombination = Factory.createVector();
        this._bitVector = new int[this._lengthK + 1];
        this.init();
    }

    private void init() {
        for (int i = 0; i <= this._lengthK; ++i) {
            this._bitVector[i] = i;
        }
        if (this._lengthN > 0) {
            this._endIndex = 1;
        }
        this._currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return this._endIndex != 0 && this._lengthK <= this._lengthN;
    }

    @Override
    public ICombinatoricsVector<T> next() {
        int n;
        ++this._currentIndex;
        for (n = 1; n <= this._lengthK; ++n) {
            int n2 = this._bitVector[n] - 1;
            if (this._generator.getOriginalVector().getSize() <= 0) continue;
            this._currentSimpleCombination.setValue(n - 1, this._generator.getOriginalVector().getValue(n2));
        }
        this._endIndex = this._lengthK;
        while (this._bitVector[this._endIndex] == this._lengthN - this._lengthK + this._endIndex) {
            --this._endIndex;
            if (this._endIndex != 0) continue;
        }
        int n3 = this._endIndex;
        this._bitVector[n3] = this._bitVector[n3] + 1;
        for (n = this._endIndex + 1; n <= this._lengthK; ++n) {
            this._bitVector[n] = this._bitVector[n - 1] + 1;
        }
        return Factory.createVector(this._currentSimpleCombination);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimpleCombinationIterator=[#" + this._currentIndex + ", " + this._currentSimpleCombination + "]";
    }
}

