/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.composition;

import java.util.Iterator;
import org.paukov.combinatorics.IntegerFactory;
import org.paukov.combinatorics.IntegerGenerator;
import org.paukov.combinatorics.IntegerVector;
import org.paukov.combinatorics.composition.IntegerCompositionIterator;
import org.paukov.combinatorics.util.Util;

public class IntegerCompositionGenerator
extends IntegerGenerator {
    public static final int MAXN = 100;
    protected final Integer _initialValue;

    public IntegerCompositionGenerator(Integer n) {
        this._initialValue = n;
    }

    @Override
    public IntegerVector getOriginalVector() {
        return IntegerFactory.createIntegerVector(new int[]{this._initialValue});
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        return Util.pow2(this._initialValue - 1);
    }

    @Override
    public Iterator<IntegerVector> iterator() {
        return new IntegerCompositionIterator(this);
    }
}

