/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.permutations;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.permutations.DuplicatedPermutationIterator;
import org.paukov.combinatorics.permutations.PermutationIterator;
import org.paukov.combinatorics.util.Util;

public class PermutationGenerator<T>
extends Generator<T> {
    protected final boolean _hasDuplicates;
    protected final boolean _treatAsIdentical;
    protected final ICombinatoricsVector<T> _originalVector;

    public PermutationGenerator(ICombinatoricsVector<T> iCombinatoricsVector) {
        this._hasDuplicates = iCombinatoricsVector.hasDuplicates();
        this._treatAsIdentical = false;
        this._originalVector = Factory.createVector(iCombinatoricsVector);
    }

    public PermutationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, boolean bl) {
        this._hasDuplicates = iCombinatoricsVector.hasDuplicates();
        this._treatAsIdentical = bl;
        this._originalVector = Factory.createVector(iCombinatoricsVector);
    }

    @Override
    public ICombinatoricsVector<T> getOriginalVector() {
        return this._originalVector;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        if (this._originalVector.getSize() == 0) {
            return 0L;
        }
        if (this.isDuplicateIterator()) {
            throw new RuntimeException("The initial vector has duplicates: " + this._originalVector);
        }
        return Util.factorial(this._originalVector.getSize());
    }

    @Override
    public Iterator<ICombinatoricsVector<T>> iterator() {
        if (this.isDuplicateIterator()) {
            return new DuplicatedPermutationIterator(this);
        }
        return new PermutationIterator(this);
    }

    protected boolean isDuplicateIterator() {
        return !this._treatAsIdentical && this._hasDuplicates;
    }
}

