/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.subsets;

import java.util.Iterator;
import org.paukov.combinatorics.IntegerFactory;
import org.paukov.combinatorics.IntegerGenerator;
import org.paukov.combinatorics.IntegerVector;
import org.paukov.combinatorics.subsets.IntegerSubListIterator;
import org.paukov.combinatorics.subsets.IntegerSubSetIterator;
import org.paukov.combinatorics.util.Util;

public class IntegerSubSetGenerator
extends IntegerGenerator {
    protected final boolean _hasDuplicates;
    protected final boolean _treatAsIdentical;
    protected final IntegerVector _originalVector;

    public IntegerSubSetGenerator(IntegerVector integerVector) {
        this._hasDuplicates = integerVector.hasDuplicates();
        this._treatAsIdentical = true;
        this._originalVector = IntegerFactory.createIntegerVector(integerVector.getVector());
    }

    public IntegerSubSetGenerator(IntegerVector integerVector, boolean bl) {
        this._hasDuplicates = integerVector.hasDuplicates();
        this._treatAsIdentical = bl;
        this._originalVector = IntegerFactory.createIntegerVector(integerVector.getVector());
    }

    @Override
    public IntegerVector getOriginalVector() {
        return this._originalVector;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        if (this.isSubList()) {
            throw new RuntimeException("The initial vector has duplicates: " + this._originalVector);
        }
        return Util.pow2(this._originalVector.getSize());
    }

    @Override
    public Iterator<IntegerVector> iterator() {
        if (this.isSubList()) {
            return new IntegerSubListIterator(this);
        }
        return new IntegerSubSetIterator(this);
    }

    protected boolean isSubList() {
        return this._treatAsIdentical && this._hasDuplicates;
    }
}

