/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.subsets;

import java.util.Iterator;
import org.paukov.combinatorics.IntegerFactory;
import org.paukov.combinatorics.IntegerGenerator;
import org.paukov.combinatorics.IntegerVector;

public class IntegerSubSetIterator
implements Iterator<IntegerVector> {
    protected final IntegerGenerator _generator;
    protected IntegerVector _currentSubSet = null;
    protected long _currentIndex = 0L;
    protected final int _length;
    private int[] _bitVector = null;

    public IntegerSubSetIterator(IntegerGenerator integerGenerator) {
        this._generator = integerGenerator;
        this._length = ((IntegerVector)integerGenerator.getOriginalVector()).getSize();
        this._currentSubSet = IntegerFactory.createIntegerVector(0);
        this._bitVector = new int[this._length + 2];
        this.init();
    }

    private void init() {
        this._currentIndex = 0L;
        for (int i = 0; i <= this._length + 1; ++i) {
            this._bitVector[i] = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this._bitVector[this._length + 1] != 1;
    }

    @Override
    public IntegerVector next() {
        int n;
        ++this._currentIndex;
        int[] nArray = new int[this._length];
        int n2 = 0;
        for (n = 1; n <= this._length; ++n) {
            if (this._bitVector[n] != 1) continue;
            int n3 = ((IntegerVector)this._generator.getOriginalVector()).getValue(n - 1);
            nArray[n2++] = n3;
        }
        this._currentSubSet = IntegerFactory.createIntegerVector(nArray, n2);
        n = 1;
        while (this._bitVector[n] == 1) {
            this._bitVector[n++] = 0;
        }
        this._bitVector[n] = 1;
        return this._currentSubSet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "IntegerSubSetIterator=[#" + this._currentIndex + ", " + this._currentSubSet + "]";
    }
}

