/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.util;

import java.util.Iterator;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.util.ComplexCombinationIterator;

public class ComplexCombinationGenerator<T>
extends Generator<ICombinatoricsVector<T>> {
    protected final ICombinatoricsVector<T> _originalVector;
    protected final int _combinationLength;
    protected final boolean _isOrderImportant;
    protected final boolean _excludeEmptySet;

    public ComplexCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n) {
        this(iCombinatoricsVector, n, true, true);
    }

    public ComplexCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n, boolean bl) {
        this(iCombinatoricsVector, n, bl, false);
    }

    public ComplexCombinationGenerator(ICombinatoricsVector<T> iCombinatoricsVector, int n, boolean bl, boolean bl2) {
        if (n > iCombinatoricsVector.getSize()) {
            throw new RuntimeException("Unable to generate complex combinations, the requested combination length is more then the size of the original vector, length: " + n + ", originalVector: " + iCombinatoricsVector);
        }
        this._originalVector = Factory.createVector(iCombinatoricsVector);
        this._combinationLength = n;
        this._isOrderImportant = bl;
        this._excludeEmptySet = bl2;
    }

    @Override
    public ICombinatoricsVector<ICombinatoricsVector<T>> getOriginalVector() {
        ICombinatoricsVector<ICombinatoricsVector<ICombinatoricsVector<T>>> iCombinatoricsVector = Factory.createVector();
        iCombinatoricsVector.addValue(this._originalVector);
        return iCombinatoricsVector;
    }

    public int getCombinationLength() {
        return this._combinationLength;
    }

    @Override
    public long getNumberOfGeneratedObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ICombinatoricsVector<ICombinatoricsVector<T>>> iterator() {
        return new ComplexCombinationIterator(this);
    }

    public boolean isOrderImportant() {
        return this._isOrderImportant;
    }

    public boolean excludeEmptySet() {
        return this._excludeEmptySet;
    }

    public static <T> String convert2String(ICombinatoricsVector<ICombinatoricsVector<T>> iCombinatoricsVector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < iCombinatoricsVector.getSize(); ++i) {
            stringBuilder.append(iCombinatoricsVector.getValue(i).getVector().toString());
            if (i == iCombinatoricsVector.getSize() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static <T> String convertIndexes2String(T[] TArray, ICombinatoricsVector<ICombinatoricsVector<Integer>> iCombinatoricsVector) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < iCombinatoricsVector.getSize(); ++i) {
            stringBuilder.append("[");
            for (int j = 0; j < iCombinatoricsVector.getValue(i).getVector().size(); ++j) {
                stringBuilder.append(TArray[iCombinatoricsVector.getValue(i).getValue(j)]);
                if (j == iCombinatoricsVector.getValue(i).getVector().size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            if (i == iCombinatoricsVector.getSize() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

