/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import org.paukov.combinatorics.util.ComplexCombinationGenerator;

public class ComplexCombinationIterator<T>
implements Iterator<ICombinatoricsVector<ICombinatoricsVector<T>>> {
    protected final ComplexCombinationGenerator<T> _generator;
    protected ICombinatoricsVector<ICombinatoricsVector<T>> _currentComplexCombination = null;
    protected long _currentIndex = 0L;
    protected Set<ICombinatoricsVector<ICombinatoricsVector<T>>> _resultSet = new LinkedHashSet<ICombinatoricsVector<ICombinatoricsVector<T>>>();
    protected Iterator<ICombinatoricsVector<ICombinatoricsVector<T>>> _resultIterator = null;

    public ComplexCombinationIterator(ComplexCombinationGenerator<T> complexCombinationGenerator) {
        this._generator = complexCombinationGenerator;
        this.init();
    }

    private void init() {
        Iterable<ICombinatoricsVector<Object>> iterable;
        Generator generator = Factory.createPermutationGenerator((ICombinatoricsVector)this._generator.getOriginalVector().getValue(0));
        List list = generator.generateAllObjects();
        Generator generator2 = Factory.createSubSetGenerator((ICombinatoricsVector)this._generator.getOriginalVector().getValue(0));
        List list2 = generator2.generateAllObjects();
        if (this._generator.excludeEmptySet()) {
            list2.remove(Factory.createVector());
        }
        ICombinatoricsVector iCombinatoricsVector = Factory.createVector(list2);
        Generator generator3 = Factory.createMultiCombinationGenerator(iCombinatoricsVector, this._generator.getCombinationLength());
        Iterator iterator = generator3.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            ICombinatoricsVector iCombinatoricsVector2 = (ICombinatoricsVector)iterator.next();
            ArrayList iterable2 = new ArrayList();
            if (iCombinatoricsVector2.getSize() > 0) {
                iterable2.addAll(((ICombinatoricsVector)iCombinatoricsVector2.getValue(0)).getVector());
            }
            for (int i = 1; i < iCombinatoricsVector2.getSize(); ++i) {
                iterable2.addAll(((ICombinatoricsVector)iCombinatoricsVector2.getValue(i)).getVector());
            }
            iterable = Factory.createVector(iterable2);
            if (!list.contains(iterable) || arrayList.contains(iCombinatoricsVector2)) continue;
            arrayList.add(iCombinatoricsVector2);
        }
        if (!this._generator.isOrderImportant()) {
            this._resultSet.addAll(arrayList);
        } else {
            for (ICombinatoricsVector iCombinatoricsVector2 : arrayList) {
                iterable = Factory.createPermutationGenerator(Factory.createVector(iCombinatoricsVector2));
                List list3 = iterable.generateAllObjects();
                this._resultSet.addAll(list3);
            }
        }
        this._resultIterator = this._resultSet.iterator();
        this._currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return this._resultIterator.hasNext();
    }

    @Override
    public ICombinatoricsVector<ICombinatoricsVector<T>> next() {
        ++this._currentIndex;
        this._currentComplexCombination = this._resultIterator.next();
        return this._currentComplexCombination;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ComplexeCombinationIterator=[#" + this._currentIndex + ", " + this._currentComplexCombination + "]";
    }
}

