/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.tool;

import java.util.LinkedList;

public class IntExpressionParser {
    public static boolean isDelim(char c) {
        return c == ' ';
    }

    public static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '%';
    }

    public static int priority(char c) {
        switch (c) {
            case '+': 
            case '-': {
                return 1;
            }
            case '%': 
            case '*': 
            case '/': {
                return 2;
            }
        }
        return -1;
    }

    public static void processOperator(LinkedList<Integer> linkedList, char c) {
        int n = linkedList.removeLast();
        int n2 = linkedList.removeLast();
        switch (c) {
            case '+': {
                linkedList.add(n2 + n);
                break;
            }
            case '-': {
                linkedList.add(n2 - n);
                break;
            }
            case '*': {
                linkedList.add(n2 * n);
                break;
            }
            case '/': {
                linkedList.add(n2 / n);
                break;
            }
            case '%': {
                linkedList.add(n2 % n);
            }
        }
    }

    public static int eval(String string) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        LinkedList<Character> linkedList2 = new LinkedList<Character>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (IntExpressionParser.isDelim(c)) continue;
            if (c == '(') {
                linkedList2.add(Character.valueOf('('));
                continue;
            }
            if (c == ')') {
                while (((Character)linkedList2.getLast()).charValue() != '(') {
                    IntExpressionParser.processOperator(linkedList, ((Character)linkedList2.removeLast()).charValue());
                }
                linkedList2.removeLast();
                continue;
            }
            if (IntExpressionParser.isOperator(c)) {
                while (!linkedList2.isEmpty() && IntExpressionParser.priority(((Character)linkedList2.getLast()).charValue()) >= IntExpressionParser.priority(c)) {
                    IntExpressionParser.processOperator(linkedList, ((Character)linkedList2.removeLast()).charValue());
                }
                linkedList2.add(Character.valueOf(c));
                continue;
            }
            String string2 = "";
            while (i < string.length() && Character.isDigit(string.charAt(i))) {
                string2 = string2 + string.charAt(i++);
            }
            --i;
            linkedList.add(Integer.parseInt(string2));
        }
        while (!linkedList2.isEmpty()) {
            IntExpressionParser.processOperator(linkedList, ((Character)linkedList2.removeLast()).charValue());
        }
        return (Integer)linkedList.get(0);
    }
}

