/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.scancollection.impl.ScanCollectionDefault;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.LCMSDataSource;

public class LCMSData
implements Serializable {
    private static final long serialVersionUID = 7653994906958188619L;
    protected static final transient FinalizableReferenceQueue FRQ = new FinalizableReferenceQueue();
    private final transient Set<User> userPhantomRefs = Sets.newConcurrentHashSet();
    protected LCMSDataSource<?> source;
    protected IScanCollection scans;
    private final Object USER_DUMMY = new Object();
    private transient RemovalListener<Object, Set<LCMSDataSubset>> listener;
    private transient Cache<Object, Set<LCMSDataSubset>> cache;
    protected volatile boolean isReleasingMemory = false;

    public LCMSData(LCMSDataSource<?> source) {
        this(source, new ScanCollectionDefault(false));
    }

    public LCMSData(LCMSDataSource<?> source, IScanCollection scans) {
        if (source == null || scans == null) {
            throw new IllegalArgumentException("Both source and scans must be non-null");
        }
        this.source = source;
        this.scans = scans;
        this.scans.setDataSource(source);
        this.listener = this.buildRemovalListener();
        this.cache = CacheBuilder.newBuilder().weakKeys().concurrencyLevel(1).removalListener(this.listener).build();
    }

    public LCMSDataSource<?> getSource() {
        return this.source;
    }

    public IScanCollection getScans() {
        return this.scans;
    }

    private RemovalListener<Object, Set<LCMSDataSubset>> buildRemovalListener() {
        return new RemovalListener<Object, Set<LCMSDataSubset>>(){

            @Override
            public void onRemoval(RemovalNotification<Object, Set<LCMSDataSubset>> notification) {
                if (LCMSData.this.isReleasingMemory) {
                    return;
                }
                Set subsets = (Set)notification.getValue();
                for (LCMSDataSubset subset : subsets) {
                    LCMSData.this.unsafeUnload(subset);
                }
            }
        };
    }

    public synchronized boolean isLoaded(LCMSDataSubset subset) {
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            Object user = entry.getKey();
            if (user == null) continue;
            Set subsets = (Set)entry.getValue();
            for (LCMSDataSubset subsetInUse : subsets) {
                if (!subsetInUse.contains(subset)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void load(LCMSDataSubset subset) throws FileParsingException {
        this.load(subset, this.USER_DUMMY);
    }

    public synchronized void load(LCMSDataSubset subset, Object user) throws FileParsingException {
        Set<LCMSDataSubset> userSubsets;
        if (user == null) {
            throw new IllegalArgumentException("User can't be null");
        }
        if (!this.isLoaded(subset)) {
            this.scans.loadData(subset, null);
        }
        if ((userSubsets = this.cache.getIfPresent(user)) == null) {
            this.addNewUser(user);
            userSubsets = new HashSet<LCMSDataSubset>(2);
            userSubsets.add(subset);
            this.cache.put(user, userSubsets);
        } else {
            userSubsets.add(subset);
        }
    }

    public synchronized void unload(LCMSDataSubset subset) {
        this.unload(subset, this.USER_DUMMY, null);
    }

    public synchronized void unload(LCMSDataSubset subset, Object user, Set<LCMSDataSubset> exclude) {
        if (!this.isLoaded(subset)) {
            throw new IllegalStateException("LCMSData load/unload methods only work for subsets loaded/unloaded using LCMSData API. The subset you requested to unload wasn't loaded. If you've loaded data into ScanCollection manually, then use IScanCollection's API for unloading data manually as well.");
        }
        Set<LCMSDataSubset> userSubsets = this.cache.getIfPresent(user);
        if (userSubsets == null) {
            throw new IllegalStateException("The user was not present in cache, which means it either has never been there, or has already been reclaimed by GC.");
        }
        if (!userSubsets.contains(subset)) {
            throw new IllegalArgumentException("This user has not loaded the subset in the first place. The user must load the subset using LCMSData API first. Unloading a subset that a user has not loaded itself is illegal.");
        }
        userSubsets.remove(subset);
        ConcurrentMap<Object, Set<LCMSDataSubset>> otherUserMaps = this.cache.asMap();
        HashSet<LCMSDataSubset> otherUsersSubsetsCombined = new HashSet<LCMSDataSubset>();
        for (Map.Entry entry : otherUserMaps.entrySet()) {
            Object otherUser = entry.getKey();
            if (otherUser == user) continue;
            Set otherUserSubsets = (Set)entry.getValue();
            otherUsersSubsetsCombined.addAll(otherUserSubsets);
        }
        if (exclude != null) {
            otherUsersSubsetsCombined.addAll(exclude);
        }
        if (otherUsersSubsetsCombined.isEmpty()) {
            this.scans.unloadData(subset);
        } else {
            this.scans.unloadData(subset, otherUsersSubsetsCombined);
        }
    }

    private void unsafeUnload(LCMSDataSubset subset) {
        ConcurrentMap<Object, Set<LCMSDataSubset>> otherUserMaps = this.cache.asMap();
        HashSet<LCMSDataSubset> otherUsersSubsetsCombined = new HashSet<LCMSDataSubset>();
        for (Map.Entry entry : otherUserMaps.entrySet()) {
            Set otherUserSubsets = (Set)entry.getValue();
            otherUsersSubsetsCombined.addAll(otherUserSubsets);
        }
        if (otherUsersSubsetsCombined.isEmpty()) {
            this.scans.unloadData(subset);
        } else {
            this.scans.unloadData(subset, otherUsersSubsetsCombined);
        }
    }

    public synchronized void releaseMemory() {
        this.isReleasingMemory = true;
        this.userPhantomRefs.clear();
        this.cache.invalidateAll();
        this.scans.reset();
        this.source.releaseMemory();
        this.isReleasingMemory = false;
    }

    private User addNewUser(Object user) {
        User u = new User(user);
        this.userPhantomRefs.add(u);
        return u;
    }

    protected class User
    extends FinalizablePhantomReference<Object> {
        public User(Object referent) {
            super(referent, FRQ);
        }

        @Override
        public void finalizeReferent() {
            LCMSData.this.userPhantomRefs.remove(this);
            LCMSData.this.cache.cleanUp();
        }
    }
}

