/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scancollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.scancollection.ScanIndex;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.IntervalST;

public class ScanCollectionHelper {
    public static double MAX_PRECURSOR_GROUP_SIZE_DIFF = 0.1;

    private ScanCollectionHelper() {
        throw new AssertionError((Object)"This class should not be instantiated");
    }

    public static void finalizeScanCollection(IScanCollection scans) throws FileParsingException {
        if (scans.getMapMsLevel2index().size() < 2) {
            return;
        }
        int msLevelLo = scans.getMapMsLevel2index().firstKey();
        int msLevelHi = scans.getMapMsLevel2index().lastKey();
        int scanNumLo = scans.getMapNum2scan().firstKey();
        int scanNumHi = scans.getMapNum2scan().lastKey();
        Set<Map.Entry<Integer, ScanIndex>> entries = scans.getMapMsLevel2index().entrySet();
        Set<Integer> msLevels = scans.getMapMsLevel2index().keySet();
        Object[] msLevelsArr = msLevels.toArray(new Integer[msLevels.size()]);
        Arrays.sort(msLevelsArr);
        for (int i = 0; i < msLevelsArr.length - 1; ++i) {
            int msLevel = (Integer)msLevelsArr[i];
            int msLevelNext = (Integer)msLevelsArr[i + 1];
            TreeMap<Integer, IScan> num2scanMapAtCurMsLevel = scans.getMapMsLevel2index().get(msLevel).getNum2scan();
            for (Map.Entry<Integer, IScan> num2scan : num2scanMapAtCurMsLevel.entrySet()) {
                NavigableMap<Integer, IScan> childScansGuess;
                int curScanNum = num2scan.getKey();
                IScan curScan = num2scan.getValue();
                IScan nextScan = scans.getNextScanAtSameMsLevel(curScan);
                Integer nextScanNumGuess = null;
                if (nextScan != null) {
                    nextScanNumGuess = nextScan.getNum();
                } else {
                    int lastScanNumAtNextMsLevel = scans.getMapMsLevel2index().get(msLevelNext).getNum2scan().lastKey();
                    if (lastScanNumAtNextMsLevel > curScanNum) {
                        nextScanNumGuess = lastScanNumAtNextMsLevel;
                    }
                }
                if (nextScanNumGuess == null || (childScansGuess = scans.getScansByNumSpanAtMsLevel(curScanNum, nextScanNumGuess, msLevelNext)) == null) continue;
                curScan.setChildScans(new ArrayList<Integer>(childScansGuess.size()));
                for (Map.Entry childNum2scan : childScansGuess.entrySet()) {
                    int childNum = (Integer)childNum2scan.getKey();
                    IScan childScan = (IScan)childNum2scan.getValue();
                    curScan.getChildScans().add(childScan.getNum());
                    PrecursorInfo precursor = childScan.getPrecursor();
                    if (precursor != null) {
                        Integer thisMsLevel = curScan.getMsLevel();
                        Integer chldMsLevel = childScan.getMsLevel();
                        if (precursor.getParentScanNum() != null || thisMsLevel == null || chldMsLevel == null || thisMsLevel + 1 != chldMsLevel) continue;
                        Double pLo = precursor.getMzRangeStart();
                        Double pHi = precursor.getMzRangeEnd();
                        Double sLo = curScan.getScanMzWindowLower();
                        Double sHi = curScan.getScanMzWindowUpper();
                        if (pLo != null && pHi != null && sLo != null && sHi != null) {
                            if (!(pLo <= sHi) || !(sLo <= pHi)) continue;
                            if (pLo.equals(pHi)) {
                                precursor.setParentScanNum(curScanNum);
                                continue;
                            }
                            double minOverlap = 0.75;
                            double overlap = Math.min(pHi, sHi) - Math.max(pLo, sLo);
                            precursor.setParentScanNum(curScanNum);
                            continue;
                        }
                        precursor.setParentScanNum(curScanNum);
                        continue;
                    }
                    throw new FileParsingException(String.format("When trying to set parent for Scan #%d, the precursor (PrecursorInfo) field was null, which should not happen.\n", childNum));
                }
            }
        }
    }

    public static void finalizePrecursorWindows(IScanCollection scans) {
        TreeMap<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> mapMsLevel2rangeGroups = scans.getMapMsLevel2rangeGroups();
        ArrayList<Integer> msLevelsToRemove = new ArrayList<Integer>();
        block0: for (Map.Entry<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> entry : mapMsLevel2rangeGroups.entrySet()) {
            int msLevel = entry.getKey();
            IntervalST<Double, TreeMap<Integer, IScan>> rangeMapMS2 = entry.getValue();
            if (rangeMapMS2.size() == 1) {
                msLevelsToRemove.add(msLevel);
                continue;
            }
            for (IntervalST.Node<Double, TreeMap<Integer, IScan>> node : rangeMapMS2) {
                if (node.getValue().size() > 1) continue;
                msLevelsToRemove.add(msLevel);
                continue block0;
            }
            if (ScanCollectionHelper.isAllRangesHaveApproxSameScanCounts(rangeMapMS2)) continue;
            msLevelsToRemove.add(msLevel);
        }
        for (Integer msLevel : msLevelsToRemove) {
            mapMsLevel2rangeGroups.remove(msLevel);
        }
        boolean a = true;
    }

    private static boolean isAllRangesHaveApproxSameScanCounts(IntervalST<Double, TreeMap<Integer, IScan>> rangeMapMS2) {
        double ratio;
        boolean allRangesHaveApproxSameScanCounts = true;
        int maxScansInGroup = 0;
        int minScansInGroup = Integer.MAX_VALUE;
        for (IntervalST.Node<Double, TreeMap<Integer, IScan>> node : rangeMapMS2) {
            TreeMap<Integer, IScan> range = node.getValue();
            if (range.size() > maxScansInGroup) {
                maxScansInGroup = range.size();
            }
            if (range.size() >= minScansInGroup) continue;
            minScansInGroup = range.size();
        }
        if (minScansInGroup == 0 || maxScansInGroup == 0 || minScansInGroup == Integer.MAX_VALUE) {
            throw new IllegalStateException("Something went wrong when guessing precursor groupings for DIA experiment.");
        }
        if (rangeMapMS2.size() != 1 && (ratio = (double)Math.abs(maxScansInGroup - minScansInGroup) / (double)minScansInGroup) > MAX_PRECURSOR_GROUP_SIZE_DIFF) {
            allRangesHaveApproxSameScanCounts = false;
        }
        return allRangesHaveApproxSameScanCounts;
    }
}

