/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scancollection;

import java.io.Serializable;
import java.util.TreeMap;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scancollection.ScanIndex;

public class ScanIndexRoot
extends ScanIndex
implements Serializable {
    private static final long serialVersionUID = -1544137529430270821L;
    protected TreeMap<Integer, ScanIndex> msLvl2index;

    public ScanIndexRoot() {
        this.num2scan = new TreeMap();
        this.rt2scan = new TreeMap();
        this.msLvl2index = new TreeMap();
    }

    public TreeMap<Integer, ScanIndex> getMsLvl2index() {
        return this.msLvl2index;
    }

    @Override
    public IScan add(IScan scan) {
        IScan oldScan = super.add(scan);
        Integer msLevel = scan.getMsLevel();
        if (msLevel != null) {
            ScanIndex indexAtMsLvl = this.msLvl2index.get(msLevel);
            if (indexAtMsLvl == null) {
                indexAtMsLvl = new ScanIndex();
                this.msLvl2index.put(msLevel, indexAtMsLvl);
            }
            indexAtMsLvl.add(scan);
        }
        return oldScan;
    }
}

