/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scancollection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scan.impl.ScanDefault;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.scancollection.ScanCollectionHelper;
import umich.ms.datatypes.scancollection.ScanIndex;
import umich.ms.datatypes.scancollection.ScanIndexRoot;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.LCMSDataSource;
import umich.ms.util.Interval1D;
import umich.ms.util.IntervalST;

public class ScanCollectionDefault
implements IScanCollection {
    public volatile LCMSRunInfo runInfo;
    protected volatile ScanIndexRoot index;
    public TreeMap<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> msLevel2rangeGroups;
    protected StorageStrategy defaultStorageStrategy;
    protected boolean isAutoloadSpectra;
    protected LCMSDataSource<?> source;
    private volatile boolean isFinalized = false;

    public ScanCollectionDefault() {
        this.initFields();
        this.defaultStorageStrategy = IScanCollection.DEFAULT_STORAGE_STRATEGY;
        this.isAutoloadSpectra = false;
    }

    public ScanCollectionDefault(boolean isAutoloadSpectra) {
        this();
        this.isAutoloadSpectra = isAutoloadSpectra;
    }

    private void initFields() {
        this.runInfo = null;
        this.index = new ScanIndexRoot();
        this.msLevel2rangeGroups = new TreeMap();
    }

    @Override
    public boolean isEmpty() {
        return this.index.getNum2scan().isEmpty();
    }

    @Override
    public StorageStrategy getDefaultStorageStrategy() {
        return this.defaultStorageStrategy;
    }

    @Override
    public void setDefaultStorageStrategy(StorageStrategy storageStrategy) {
        this.defaultStorageStrategy = storageStrategy;
        this.setStorageStrategy(LCMSDataSubset.WHOLE_RUN, storageStrategy);
    }

    @Override
    public boolean isAutoloadSpectra() {
        return this.isAutoloadSpectra;
    }

    @Override
    public void isAutoloadSpectra(boolean newVal) {
        this.isAutoloadSpectra = newVal;
    }

    @Override
    public LCMSDataSource<?> getDataSource() {
        return this.source;
    }

    @Override
    public void setDataSource(LCMSDataSource<?> source) {
        this.source = source;
    }

    @Override
    public IScan addScan(IScan scan) {
        IScan oldScan = this.index.add(scan);
        Interval1D<Double> si = null;
        if (scan.getMsLevel() == 1) {
            if (scan.getScanMzWindowLower() != null && scan.getScanMzWindowUpper() != null) {
                si = new Interval1D<Double>(scan.getScanMzWindowLower(), scan.getScanMzWindowUpper());
            }
        } else if (scan.getPrecursor() != null && scan.getPrecursor().getMzRangeStart() != null && scan.getPrecursor().getMzRangeEnd() != null) {
            si = new Interval1D<Double>(scan.getPrecursor().getMzRangeStart(), scan.getPrecursor().getMzRangeEnd());
        }
        if (si != null) {
            IntervalST<Double, TreeMap<Integer, IScan>> rangeTreeAtMsLvl = this.msLevel2rangeGroups.get(scan.getMsLevel());
            if (rangeTreeAtMsLvl == null) {
                rangeTreeAtMsLvl = new IntervalST();
                this.msLevel2rangeGroups.put(scan.getMsLevel(), rangeTreeAtMsLvl);
            }
            List<IntervalST.Node<Double, TreeMap<Integer, IScan>>> nodes = rangeTreeAtMsLvl.searchAll(si);
            IntervalST.Node bestNode = null;
            double bestOverlapSum = 0.0;
            double siLen = (Double)si.hi - (Double)si.lo;
            for (IntervalST.Node node : nodes) {
                double overlapSum;
                Interval1D ci = node.getInterval();
                double ciLen = (Double)ci.hi - (Double)ci.lo;
                double diff1 = (Double)si.hi - (Double)ci.lo;
                double diff2 = (Double)ci.hi - (Double)si.lo;
                double overlap = Math.min(Math.min(Math.min(ciLen, siLen), diff1), diff2);
                if (ciLen == 0.0 && siLen == 0.0) {
                    bestNode = node;
                    break;
                }
                if (!(overlap > 0.0)) continue;
                double ciOverlap = overlap / ciLen;
                double siOverlap = overlap / siLen;
                if (!(ciOverlap >= 0.5) || !(siOverlap >= 0.5) || !((overlapSum = ciOverlap + siOverlap) > bestOverlapSum)) continue;
                bestNode = node;
                bestOverlapSum = overlapSum;
            }
            if (bestNode == null) {
                TreeMap<Integer, IScan> scanMap = new TreeMap<Integer, IScan>();
                scanMap.put(scan.getNum(), scan);
                rangeTreeAtMsLvl.put(si, scanMap);
            } else {
                Interval1D ci = bestNode.getInterval();
                int n = ((TreeMap)bestNode.getValue()).size();
                if (!((Double)si.lo).equals(ci.lo) || !((Double)si.hi).equals(ci.hi)) {
                    double newLo = (Double)ci.lo + ((Double)si.lo - (Double)ci.lo) / (double)(n + 1);
                    double newHi = (Double)ci.hi + ((Double)si.hi - (Double)ci.hi) / (double)(n + 1);
                    IntervalST.Node<Double, TreeMap<Integer, IScan>> removed = rangeTreeAtMsLvl.remove(ci);
                    removed.getValue().put(scan.getNum(), scan);
                    rangeTreeAtMsLvl.put(new Interval1D<Double>(newLo, newHi), removed.getValue());
                } else {
                    IntervalST.Node<Double, TreeMap<Integer, IScan>> node = rangeTreeAtMsLvl.get(si);
                    node.getValue().put(scan.getNum(), scan);
                }
            }
        }
        return oldScan;
    }

    @Override
    public TreeMap<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> getMapMsLevel2rangeGroups() {
        return this.msLevel2rangeGroups;
    }

    @Override
    public TreeMap<Integer, IScan> getMapNum2scan() {
        return this.index.getNum2scan();
    }

    @Override
    public TreeMap<Integer, ScanIndex> getMapMsLevel2index() {
        return this.index.getMsLvl2index();
    }

    @Override
    public TreeMap<Double, List<IScan>> getMapRt2scan() {
        return this.index.getRt2scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LCMSRunInfo getRunInfo() {
        LCMSRunInfo tmp = this.runInfo;
        if (tmp == null) {
            ScanCollectionDefault scanCollectionDefault = this;
            synchronized (scanCollectionDefault) {
                tmp = this.runInfo;
                if (tmp == null && this.source != null) {
                    try {
                        this.runInfo = tmp = this.source.fetchRunInfo();
                    }
                    catch (FileParsingException fileParsingException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.runInfo;
    }

    @Override
    public void setRunInfo(LCMSRunInfo runInfo) {
        this.runInfo = runInfo;
    }

    @Override
    public Double getRtMax() {
        return this.getMapRt2scan().lastKey();
    }

    @Override
    public Double getRtMin() {
        return this.getMapRt2scan().firstKey();
    }

    @Override
    public IScan getScanByNum(int scanNum) {
        IScan scan = this.getNum2scan().get(scanNum);
        if (scan != null) {
            return scan;
        }
        return null;
    }

    @Override
    public IScan getScanByNumLower(int scanNum) {
        IScan scan = this.getNum2scan().lowerEntry(scanNum).getValue();
        if (scan != null) {
            return scan;
        }
        return null;
    }

    @Override
    public IScan getScanByNumUpper(int scanNum) {
        IScan scan = this.getNum2scan().ceilingEntry(scanNum).getValue();
        if (scan != null) {
            return scan;
        }
        return null;
    }

    @Override
    public IScan getScanByNumClosest(int scanNum) {
        IScan result = null;
        Map.Entry<Integer, IScan> lower = this.getNum2scan().lowerEntry(scanNum);
        Map.Entry<Integer, IScan> upper = this.getNum2scan().ceilingEntry(scanNum);
        if (upper != null && lower != null) {
            result = Integer.compare(lower.getKey(), upper.getKey()) > 0 ? lower.getValue() : upper.getValue();
        } else if (upper != null) {
            result = upper.getValue();
        } else if (lower != null) {
            result = lower.getValue();
        }
        return result;
    }

    @Override
    public List<IScan> getScansByRt(double rt) {
        List<IScan> scans = this.getRt2scan().get(rt);
        if (scans != null) {
            return scans;
        }
        return null;
    }

    @Override
    public List<IScan> getScansByRtLower(double rt) {
        Map.Entry<Double, List<IScan>> lowerEntry = this.getRt2scan().lowerEntry(rt);
        if (lowerEntry == null) {
            return null;
        }
        List<IScan> scans = lowerEntry.getValue();
        if (scans != null) {
            return scans;
        }
        return null;
    }

    @Override
    public List<IScan> getScansByRtUpper(double rt) {
        Map.Entry<Double, List<IScan>> ceilingEntry = this.getMapRt2scan().ceilingEntry(rt);
        if (ceilingEntry == null) {
            return null;
        }
        List<IScan> scans = ceilingEntry.getValue();
        if (scans != null) {
            return scans;
        }
        return null;
    }

    @Override
    public List<IScan> getScansByRtClosest(double rt) {
        List<IScan> result = null;
        Map.Entry<Double, List<IScan>> lower = this.getMapRt2scan().lowerEntry(rt);
        Map.Entry<Double, List<IScan>> upper = this.getMapRt2scan().ceilingEntry(rt);
        if (upper != null && lower != null) {
            result = Math.abs(rt - lower.getKey()) <= Math.abs(rt - upper.getKey()) ? lower.getValue() : upper.getValue();
        } else if (upper != null) {
            result = upper.getValue();
        } else if (lower != null) {
            result = lower.getValue();
        }
        return result;
    }

    @Override
    public NavigableMap<Integer, IScan> getScansByNumSpanAtMsLevel(int numStart, int numEnd, int msLevel) {
        NavigableMap<Integer, IScan> subMap = null;
        TreeMap<Integer, IScan> msLevelMap = this.getMapMsLevel2index().get(msLevel).getNum2scan();
        if (msLevelMap != null) {
            subMap = msLevelMap.subMap(numStart, true, numEnd, true);
        }
        if (subMap != null && subMap.size() > 0) {
            return subMap;
        }
        return null;
    }

    @Override
    public TreeMap<Integer, NavigableMap<Integer, IScan>> getScansByNumSpan(int numStart, int numEnd) {
        TreeMap<Integer, NavigableMap<Integer, IScan>> viewMap = new TreeMap<Integer, NavigableMap<Integer, IScan>>();
        boolean hasNonZeroElements = false;
        for (Integer i : this.getMapMsLevel2index().keySet()) {
            NavigableMap<Integer, IScan> scansByNumSpanAtMsLevel = this.getScansByNumSpanAtMsLevel(numStart, numEnd, i);
            if (scansByNumSpanAtMsLevel == null) continue;
            hasNonZeroElements = true;
            viewMap.put(i, scansByNumSpanAtMsLevel);
        }
        if (hasNonZeroElements) {
            return viewMap;
        }
        return null;
    }

    @Override
    public NavigableMap<Integer, IScan> getScansByRtSpanAtMsLevel(double rtStart, double rtEnd, int msLevel) {
        int endScanNum;
        if (this.getNum2scan().size() == 0) {
            return null;
        }
        List<IScan> startScans = this.getScansByRtUpper(rtStart);
        int startScanNum = startScans == null ? this.getNum2scan().firstEntry().getValue().getNum() : startScans.get(0).getNum();
        List<IScan> endScans = this.getScansByRtLower(rtEnd);
        int n = endScanNum = endScans == null ? this.getNum2scan().lastEntry().getValue().getNum() : endScans.get(0).getNum();
        if (endScanNum < startScanNum) {
            return null;
        }
        NavigableMap<Integer, IScan> scansByNumSpanAtMsLevel = this.getScansByNumSpanAtMsLevel(startScanNum, endScanNum, msLevel);
        if (scansByNumSpanAtMsLevel != null && scansByNumSpanAtMsLevel.size() > 0) {
            return scansByNumSpanAtMsLevel;
        }
        return null;
    }

    @Override
    public TreeMap<Integer, NavigableMap<Integer, IScan>> getScansByRtSpan(double rtStart, double rtEnd) {
        TreeMap<Integer, NavigableMap<Integer, IScan>> viewMap = new TreeMap<Integer, NavigableMap<Integer, IScan>>();
        boolean hasNonZeroElements = false;
        for (Integer i : this.getMapMsLevel2index().keySet()) {
            NavigableMap<Integer, IScan> scansByRtSpanAtMsLevel = this.getScansByRtSpanAtMsLevel(rtStart, rtEnd, i);
            if (scansByRtSpanAtMsLevel == null) continue;
            hasNonZeroElements = true;
            viewMap.put(i, scansByRtSpanAtMsLevel);
        }
        if (hasNonZeroElements) {
            return viewMap;
        }
        return null;
    }

    @Override
    public int getScanCount() {
        return this.getNum2scan().size();
    }

    @Override
    public Integer getScanCountAtMsLevel(int msLevel) {
        TreeMap<Integer, IScan> msLevelScanMap = this.getMapMsLevel2index().get(msLevel).getNum2scan();
        if (msLevelScanMap != null) {
            return msLevelScanMap.size();
        }
        return null;
    }

    @Override
    public IScan getNextScan(int scanNum) {
        Map.Entry<Integer, IScan> higherEntry = this.getMapNum2scan().higherEntry(scanNum);
        return higherEntry == null ? null : higherEntry.getValue();
    }

    @Override
    public IScan getNextScanAtMsLevel(int scanNum, int msLevel) {
        TreeMap<Integer, IScan> msLevelMap = this.getMapMsLevel2index().get(msLevel).getNum2scan();
        if (msLevelMap == null) {
            return null;
        }
        Map.Entry<Integer, IScan> entry = msLevelMap.ceilingEntry(scanNum + 1);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public IScan getNextScanAtSameMsLevel(IScan scan) {
        return this.getNextScanAtMsLevel(scan.getNum(), scan.getMsLevel());
    }

    @Override
    public IScan getPrevScan(int scanNum) {
        Map.Entry<Integer, IScan> lowerEntry = this.getMapNum2scan().lowerEntry(scanNum);
        return lowerEntry == null ? null : lowerEntry.getValue();
    }

    @Override
    public IScan getPrevScanAtMsLevel(int scanNum, int msLevel) {
        TreeMap<Integer, IScan> msLevelMap = this.getMapMsLevel2index().get(msLevel).getNum2scan();
        if (msLevelMap == null) {
            return null;
        }
        Map.Entry<Integer, IScan> entry = msLevelMap.floorEntry(scanNum - 1);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public IScan getPrevScanAtSameMsLevel(IScan scan) {
        return this.getPrevScanAtMsLevel(scan.getNum(), scan.getMsLevel());
    }

    @Override
    public void setStorageStrategy(LCMSDataSubset subset, StorageStrategy storageStrategy) {
        NavigableMap<Integer, IScan> scansInSubsetByNumber = this.getScansInSubsetByNumber(this.getMapNum2scan(), subset);
        for (IScan scan : scansInSubsetByNumber.values()) {
            if (!subset.isInSubset(scan)) continue;
            scan.setStorageStrategy(storageStrategy);
        }
    }

    @Override
    public void setStorageStrategy(LCMSDataSubset subset, StorageStrategy strategyInSet, StorageStrategy strategyNotInSet) {
        if (strategyInSet == null && strategyNotInSet == null) {
            return;
        }
        if (strategyInSet != null && strategyNotInSet == null) {
            NavigableMap<Integer, IScan> subMap = this.getScansInSubsetByNumber(this.getMapNum2scan(), subset);
            this.setStorageStrategyForMap(subset, subMap, strategyInSet, strategyNotInSet);
        } else if (strategyInSet == null && strategyNotInSet != null) {
            List<NavigableMap<Integer, IScan>> subMaps = this.getScansNotInSubsetByNumber(subset);
            for (NavigableMap<Integer, IScan> subMap : subMaps) {
                this.setStorageStrategyForMap(subset, subMap, strategyInSet, strategyNotInSet);
            }
            for (IScan scan : this.getMapNum2scan().values()) {
                if (subset.isInSubset(scan)) {
                    scan.setStorageStrategy(strategyInSet);
                    continue;
                }
                scan.setStorageStrategy(strategyNotInSet);
            }
        } else {
            this.setStorageStrategyForMap(subset, this.getMapNum2scan(), strategyInSet, strategyNotInSet);
        }
    }

    private void setStorageStrategyForMap(LCMSDataSubset subset, NavigableMap<Integer, IScan> map, StorageStrategy strategyInSet, StorageStrategy strategyNotInSet) {
        for (IScan scan : map.values()) {
            if (subset.isInSubset(scan)) {
                scan.setStorageStrategy(strategyInSet);
                continue;
            }
            scan.setStorageStrategy(strategyNotInSet);
        }
    }

    private NavigableMap<Integer, IScan> getScansInSubsetByNumber(NavigableMap<Integer, IScan> scanMap, LCMSDataSubset subset) {
        NavigableMap<Integer, IScan> scansInSubsetByNumber = scanMap;
        if (subset.getScanNumLo() != null) {
            scansInSubsetByNumber.subMap(subset.getScanNumLo(), true, (Integer)scansInSubsetByNumber.lastKey(), true);
        }
        if (subset.getScanNumHi() != null) {
            scansInSubsetByNumber.subMap((Integer)scansInSubsetByNumber.firstKey(), true, subset.getScanNumHi(), true);
        }
        return scansInSubsetByNumber;
    }

    private List<NavigableMap<Integer, IScan>> getScansNotInSubsetByNumber(LCMSDataSubset subset) {
        NavigableMap<Integer, IScan> map;
        ArrayList<NavigableMap<Integer, IScan>> maps = new ArrayList<NavigableMap<Integer, IScan>>(2);
        if (subset.getScanNumLo() != null && this.getMapNum2scan().lowerKey(subset.getScanNumLo()) != null && (map = this.getMapNum2scan().subMap(this.getMapNum2scan().firstKey(), true, this.getMapNum2scan().lowerKey(subset.getScanNumLo()), true)).size() > 0) {
            maps.add(map);
        }
        if (subset.getScanNumHi() != null && this.getMapNum2scan().higherKey(subset.getScanNumHi()) != null && (map = this.getMapNum2scan().subMap(this.getMapNum2scan().higherKey(subset.getScanNumHi()), true, this.getMapNum2scan().lastKey(), true)).size() > 0) {
            maps.add(map);
        }
        return maps;
    }

    @Override
    public synchronized void loadData(LCMSDataSubset subset) throws FileParsingException {
        this.loadData(subset, this.getDefaultStorageStrategy());
    }

    @Override
    public synchronized void loadData(LCMSDataSubset subset, StorageStrategy storageStrategy) throws FileParsingException {
        if (this.source == null) {
            throw new IllegalStateException("LCMSDataSource must be set before loading any data");
        }
        if (subset == null) {
            throw new IllegalArgumentException("Data subset can't be null, if you want to parse everything use LCMSDataSubset.WHOLE_RUN");
        }
        if (storageStrategy == null) {
            storageStrategy = this.defaultStorageStrategy;
        }
        List<IScan> parsedScans = this.source.parse(subset);
        TreeMap<Integer, IScan> idx = this.index.getNum2scan();
        for (IScan parsedScan : parsedScans) {
            IScan existingScan = idx.get(parsedScan.getNum());
            if (existingScan != null) {
                if (existingScan.getSpectrum() != null || !subset.isInSubset(parsedScan)) continue;
                existingScan.setStorageStrategy(storageStrategy);
                ISpectrum spectrum = parsedScan.getSpectrum();
                if (spectrum != null) {
                    existingScan.setSpectrum(spectrum, true);
                    continue;
                }
                StringBuilder msg = new StringBuilder();
                boolean inSubset = subset.isInSubset(parsedScan);
                msg.append(String.format("Parsed scan was considered to be in subset, but spectrum was null. Scan MS%d #%d @ %.3f", parsedScan.getMsLevel(), parsedScan.getNum(), parsedScan.getRt()));
                PrecursorInfo precursor = parsedScan.getPrecursor();
                if (precursor != null) {
                    msg.append(String.format(", Precursor: %.4f-%.4f", precursor.getMzRangeStart(), precursor.getMzRangeEnd()));
                }
                msg.append(". Subset: ");
                msg.append(subset.toString());
                System.err.println(msg.toString());
                continue;
            }
            parsedScan.setStorageStrategy(storageStrategy);
            parsedScan.setScanCollection(this);
            this.addScan(parsedScan);
        }
        if (!this.isFinalized && subset.getScanNumLo() == null && subset.getScanNumHi() == null) {
            ScanCollectionHelper.finalizeScanCollection(this);
            ScanCollectionHelper.finalizePrecursorWindows(this);
        }
    }

    @Override
    public synchronized void unloadData(LCMSDataSubset subset) {
        if (subset.getMsLvls() != null) {
            for (Integer msLvl : subset.getMsLvls()) {
                ScanIndex mapAtMsLvl = this.getMapMsLevel2index().get(msLvl);
                if (mapAtMsLvl == null) continue;
                NavigableMap<Integer, IScan> scansInSubsetByNumber = this.getScansInSubsetByNumber(mapAtMsLvl.getNum2scan(), subset);
                for (IScan scan : scansInSubsetByNumber.values()) {
                    if (!subset.isInSubset(scan)) continue;
                    scan.setSpectrum(null, false);
                }
            }
        } else {
            NavigableMap<Integer, IScan> scansInSubsetByNumber = this.getScansInSubsetByNumber(this.getMapNum2scan(), subset);
            for (IScan scan : scansInSubsetByNumber.values()) {
                if (!subset.isInSubset(scan)) continue;
                scan.setSpectrum(null, false);
            }
        }
    }

    @Override
    public void unloadData(LCMSDataSubset subset, Set<LCMSDataSubset> exlude) {
        boolean isOkToUnload = false;
        if (subset.getMsLvls() != null) {
            for (Integer msLvl : subset.getMsLvls()) {
                ScanIndex mapAtMsLvl = this.getMapMsLevel2index().get(msLvl);
                if (mapAtMsLvl == null) continue;
                NavigableMap<Integer, IScan> scansInSubsetByNumber = this.getScansInSubsetByNumber(mapAtMsLvl.getNum2scan(), subset);
                this.unloadSpectraConditionally(scansInSubsetByNumber, subset, exlude);
            }
        } else {
            NavigableMap<Integer, IScan> scansInSubsetByNumber = this.getScansInSubsetByNumber(this.getMapNum2scan(), subset);
            this.unloadSpectraConditionally(scansInSubsetByNumber, subset, exlude);
        }
    }

    private void unloadSpectraConditionally(NavigableMap<Integer, IScan> scansInSubsetByNumber, LCMSDataSubset subset, Set<LCMSDataSubset> exlude) {
        for (IScan scan : scansInSubsetByNumber.values()) {
            if (!subset.isInSubset(scan)) continue;
            boolean isOkToUnload = true;
            for (LCMSDataSubset exludedSubset : exlude) {
                if (!exludedSubset.isInSubset(scan)) continue;
                isOkToUnload = false;
                break;
            }
            if (!isOkToUnload) continue;
            scan.setSpectrum(null, false);
        }
    }

    @Override
    public IScan createScanStub(int num) {
        ScanDefault scan = new ScanDefault(this, num);
        scan.setStorageStrategy(this.getDefaultStorageStrategy());
        return scan;
    }

    @Deprecated
    public TreeMap<Integer, IScan> getNum2scan() {
        return this.index.getNum2scan();
    }

    @Deprecated
    public TreeMap<Double, List<IScan>> getRt2scan() {
        return this.index.getRt2scan();
    }

    @Override
    public void reset() {
        this.initFields();
    }
}

