/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.spectrum;

import java.io.Serializable;
import java.util.Arrays;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.util.SpectrumUtils;

public abstract class AbstractSpectrum
implements ISpectrum,
Serializable {
    private static final long serialVersionUID = 4857567189693575413L;
    protected double minMZ;
    protected double maxMZ;
    protected double minInt;
    protected double minIntNonZero;
    protected double maxInt;
    protected double maxIntMz;
    protected double sumInt;

    @Override
    public double getMinMZ() {
        return this.minMZ;
    }

    @Override
    public double getMaxMZ() {
        return this.maxMZ;
    }

    @Override
    public double getMinInt() {
        return this.minInt;
    }

    @Override
    public double getMinIntNonZero() {
        return this.minIntNonZero;
    }

    @Override
    public double getMaxInt() {
        return this.maxInt;
    }

    @Override
    public double getMaxIntMz() {
        return this.maxIntMz;
    }

    @Override
    public double getSumInt() {
        return this.sumInt;
    }

    protected void setMinMZ(double minMZ) {
        this.minMZ = minMZ;
    }

    protected void setMaxMZ(double maxMZ) {
        this.maxMZ = maxMZ;
    }

    protected void setMinInt(double minInt) {
        this.minInt = minInt;
    }

    public void setMinIntNonZero(double minIntNonZero) {
        this.minIntNonZero = minIntNonZero;
    }

    protected void setMaxInt(double maxInt) {
        this.maxInt = maxInt;
    }

    public void setMaxIntMz(double maxIntMz) {
        this.maxIntMz = maxIntMz;
    }

    protected void setSumInt(double sumInt) {
        this.sumInt = sumInt;
    }

    @Override
    public Integer findMzIdxCeiling(double mz) {
        double[] mzs = this.getMZs();
        int pos = Arrays.binarySearch(mzs, mz);
        if (pos >= 0) {
            return pos;
        }
        if ((pos ^= 0xFFFFFFFF) == mzs.length) {
            return null;
        }
        return pos;
    }

    @Override
    public Integer findMzIdxFloor(double mz) {
        double[] mzs = this.getMZs();
        int pos = Arrays.binarySearch(mzs, mz);
        if (pos >= 0) {
            return pos;
        }
        if ((pos ^= 0xFFFFFFFF) == 0) {
            return null;
        }
        return pos - 1;
    }

    @Override
    public Integer findClosestMzIdx(double mz) {
        double[] mzs = this.getMZs();
        int pos = Arrays.binarySearch(mzs, mz);
        if (pos >= 0) {
            return pos;
        }
        if ((pos ^= 0xFFFFFFFF) == 0) {
            return pos;
        }
        if (pos == mzs.length) {
            return pos - 1;
        }
        return mz - mzs[pos - 1] <= mzs[pos] - mz ? pos - 1 : pos;
    }

    @Override
    public int[] findMzIdxsWithinPpm(double mz, double ppm) {
        double mzTolerance = SpectrumUtils.ppm2amu(mz, ppm);
        return this.findMzIdxs(mz - mzTolerance, mz + mzTolerance);
    }
}

