/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.chunk;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.fileio.chunk.FileChunk;
import umich.ms.fileio.chunk.FileChunkSource;
import umich.ms.logging.LogHelper;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.ByteArrayHolderFactory;

public class ChunkedFile
implements FileChunkSource {
    private Path path;
    private int chunkSize;
    private static final int CHUNK_SIZE_DEFAULT = 0x800000;
    private int chunkOverlap;
    private static final int CHUNK_OVERLAP_DEFAULT = 512;
    private FileChunk[] chunks;
    private SoftReferenceObjectPool<ByteArrayHolder> pool;
    private ByteArrayHolderFactory factory;
    private int chunkBufferSize = 1;
    private double chunkBufferLoadFactor = 0.5;
    private ConcurrentSkipListMap<Integer, FileChunk> chunksInUse = null;
    private ConcurrentSkipListMap<Integer, FileChunk> chunksPreRead = null;
    private ConcurrentSkipListMap<Integer, FileChunk> chunksScheduled = null;
    private AtomicInteger nextChunkNum = new AtomicInteger(-1);
    ListeningExecutorService execIo = null;
    ExecutorService execFinalize = null;
    private volatile RandomAccessFile raf = null;
    private static final Logger log = LoggerFactory.getLogger(ChunkedFile.class);

    public ChunkedFile(Path path) {
        this(path, 0x800000, 512);
    }

    public ChunkedFile(Path path, int chunkSize, int chunkOverlap) {
        if ((double)chunkOverlap > 0.5 * (double)chunkSize) {
            throw new IllegalArgumentException(String.format("Chunk overlap is not allowed to be more than 0.5 of chunk size. You tried to set overlap %d when chunk size was %d", chunkOverlap, chunkSize));
        }
        this.path = path;
        this.chunkSize = chunkSize;
        this.chunkOverlap = chunkOverlap;
        this.factory = new ByteArrayHolderFactory();
        this.factory.setDefaultSize(chunkSize);
        this.pool = new SoftReferenceObjectPool<ByteArrayHolder>(this.factory);
    }

    public void init() throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find a file under path: " + this.path.toAbsolutePath().toString());
        }
        if (Files.size(this.path) == 0L) {
            throw new IllegalStateException("File size can't be zero for chunked files");
        }
        this.chunks = this.chunkFile();
        this.chunksInUse = new ConcurrentSkipListMap();
        this.chunksPreRead = new ConcurrentSkipListMap();
        this.chunksScheduled = new ConcurrentSkipListMap();
        this.nextChunkNum = new AtomicInteger(-1);
        if (this.raf != null) {
            this.raf.close();
        }
        this.execIo = MoreExecutors.listeningDecorator(Executors.newSingleThreadExecutor());
        this.execFinalize = Executors.newSingleThreadExecutor();
    }

    public int getChunkBufferSize() {
        return this.chunkBufferSize;
    }

    public void setChunkBufferSize(int chunkBufferSize) {
        this.chunkBufferSize = chunkBufferSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    private void setChunkSize(int chunkSize, boolean resetFactorySettings) {
        this.chunkSize = chunkSize;
        if (resetFactorySettings) {
            this.factory.setDefaultSize(chunkSize);
        }
    }

    public int getChunkOverlap() {
        return this.chunkOverlap;
    }

    public ByteArrayHolderFactory getFactory() {
        return this.factory;
    }

    public FileChunk[] getChunks() {
        return this.chunks;
    }

    public SoftReferenceObjectPool<ByteArrayHolder> getPool() {
        return this.pool;
    }

    private FileChunk[] chunkFile() {
        int curLen;
        int readLen = this.chunkSize;
        long fileLen = this.path.toFile().length();
        if (fileLen <= (long)readLen) {
            return new FileChunk[]{new FileChunk(0, 0L, (int)fileLen)};
        }
        long numChunksL = (long)Math.ceil((double)(fileLen - (long)this.chunkOverlap) / (double)this.chunkSize);
        if (numChunksL > Integer.MAX_VALUE) {
            throw new IllegalStateException("Num chunks can't be more than Integer.MAX_VALUE, file too large or chunk size too small");
        }
        int numChunks = (int)numChunksL;
        FileChunk[] fileChunks = new FileChunk[numChunks];
        ArrayList<FileChunk> fileChunksList = new ArrayList<FileChunk>(numChunks);
        long curOffset = 0L;
        boolean countChunks = false;
        int curChunkNum = 0;
        do {
            long lenToEOF;
            int n = curLen = (lenToEOF = fileLen - curOffset) < (long)this.chunkSize ? (int)lenToEOF : this.chunkSize;
            if (curLen <= this.chunkOverlap) break;
            FileChunk fileChunk = new FileChunk(curChunkNum, curOffset, curLen);
            fileChunksList.add(fileChunk);
            curOffset = curOffset + (long)curLen - (long)this.chunkOverlap;
            log.trace("Adding chunk #{}: offset {}, len {}, offset+len {}, next offset {}", fileChunk.getChunkNum(), fileChunk.getOffset(), fileChunk.getLength(), fileChunk.getOffset() + (long)fileChunk.getLength(), curOffset);
            ++curChunkNum;
        } while (curOffset < fileLen && curLen > this.chunkOverlap);
        if (curChunkNum != fileChunks.length) {
            log.error("Something wronf with file chunks calculation, expected number of chunks {}, real number {}, file length {}, chunk size {}, overlap {}", numChunks, curChunkNum, fileLen, this.chunkSize, this.chunkOverlap);
        }
        return curChunkNum == numChunks ? fileChunksList.toArray(fileChunks) : fileChunksList.toArray(new FileChunk[fileChunksList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChunk next() {
        int nextNum = this.nextChunkNum.incrementAndGet();
        log.debug("Got next() request, next num '{}', running on thread {}", (Object)nextNum, (Object)Thread.currentThread().getName());
        if (nextNum > this.chunks.length - 1) {
            ChunkedFile chunkedFile = this;
            synchronized (chunkedFile) {
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (IOException e) {
                        log.error("Something awful, could not close RandomAccessFile", e);
                    }
                }
                this.execIo.shutdown();
                this.execFinalize.shutdown();
                int timeout = 5;
                TimeUnit timeUnit = TimeUnit.SECONDS;
                try {
                    this.execIo.awaitTermination(timeout, timeUnit);
                    this.execFinalize.awaitTermination(timeout, timeUnit);
                }
                catch (InterruptedException e) {
                    log.error("Could not stop executors withing {} {}", (Object)timeout, (Object)timeUnit.toString());
                }
                return null;
            }
        }
        FileChunk fileChunk = this.chunksPreRead.get(nextNum);
        if (fileChunk == null && (fileChunk = this.chunksScheduled.get(nextNum)) == null) {
            ChunkedFile chunkedFile = this;
            synchronized (chunkedFile) {
                fileChunk = this.chunksPreRead.get(nextNum);
                if (fileChunk == null && (fileChunk = this.chunksScheduled.get(nextNum)) == null) {
                    this.schedule(nextNum);
                }
                try {
                    while ((fileChunk = this.chunksPreRead.get(nextNum)) == null) {
                        log.debug("Thread '{}' is waiting to be woken up to try and get its target chunk #{}", (Object)Thread.currentThread().getName(), (Object)nextNum);
                        this.wait();
                        log.debug("Thread '{}' is woke up, trying to get its target chunk #{}", (Object)Thread.currentThread().getName(), (Object)nextNum);
                    }
                }
                catch (InterruptedException e) {
                    log.warn("A thread scheduled a chunk of file to be read, but was interrupted while waiting on the monitor", e);
                    e.printStackTrace();
                }
            }
        }
        if (fileChunk == null) {
            log.error("FileChunk was null while chunk number less than total number of chunks, should not happen");
        }
        return fileChunk;
    }

    protected synchronized void schedule(int chunkNum) {
        this.chunksScheduled.putIfAbsent(chunkNum, this.chunks[chunkNum]);
        int chunksAvailable = this.chunksScheduled.size() + this.chunksPreRead.size();
        int bufferLoLimit = (int)Math.ceil((double)this.chunkBufferSize * this.chunkBufferLoadFactor);
        if (chunksAvailable < bufferLoLimit) {
            int scheduledChunkNum = chunkNum;
            for (int i = 0; i < this.chunkBufferSize - chunksAvailable && ++scheduledChunkNum < this.chunks.length; ++i) {
                this.chunksScheduled.putIfAbsent(scheduledChunkNum, this.chunks[scheduledChunkNum]);
            }
        }
        Future future = this.execIo.submit(new Runnable(){

            @Override
            public void run() {
                Map.Entry entry;
                while ((entry = ChunkedFile.this.chunksScheduled.pollFirstEntry()) != null) {
                    Integer num = (Integer)entry.getKey();
                    FileChunk chunk = (FileChunk)entry.getValue();
                    ByteArrayHolder bah = null;
                    try {
                        bah = (ByteArrayHolder)ChunkedFile.this.pool.borrowObject();
                    }
                    catch (Exception e) {
                        log.error("Something awful happened when borrowing ByteArrayHolder from pool", e);
                        throw new IllegalStateException(e);
                    }
                    try {
                        if (ChunkedFile.this.raf == null) {
                            ChunkedFile.this.raf = new RandomAccessFile(ChunkedFile.this.path.toFile(), "r");
                        }
                        bah.ensureCapacity(chunk.getLength());
                        log.debug("Seeking to position in file for read @{} : {}", (Object)chunk.getOffset(), (Object)chunk.getLength());
                        ChunkedFile.this.raf.seek(chunk.getOffset());
                        ChunkedFile.this.raf.readFully(bah.getUnderlyingBytes(), 0, chunk.getLength());
                        bah.setPosition(chunk.getLength());
                        chunk.setBah(bah, ChunkedFile.this.pool);
                        ChunkedFile.this.chunksPreRead.put(num, chunk);
                    }
                    catch (IOException e) {
                        log.error("Something awful happened when reading file", e);
                        throw new IllegalStateException(e);
                    }
                }
            }
        });
        Futures.addCallback(future, new FutureCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(Object result) {
                ChunkedFile chunkedFile = ChunkedFile.this;
                synchronized (chunkedFile) {
                    ChunkedFile.this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable t) {
                ChunkedFile chunkedFile = ChunkedFile.this;
                synchronized (chunkedFile) {
                    log.error("Everything has blown up!", t);
                    ChunkedFile.this.execFinalize.shutdown();
                    ChunkedFile.this.execIo.shutdown();
                    int timeout = 1;
                    TimeUnit timeUnit = TimeUnit.SECONDS;
                    try {
                        ChunkedFile.this.execIo.awaitTermination(timeout, timeUnit);
                        ChunkedFile.this.execFinalize.awaitTermination(timeout, timeUnit);
                    }
                    catch (InterruptedException e) {
                        log.error("Could not stop executors withing {} {}", (Object)timeout, (Object)timeUnit.toString());
                    }
                }
            }
        }, this.execFinalize);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        LogHelper.configureJavaUtilLogging();
        String path = "E:\\andy\\q01507.mzML_h";
        Path p = Paths.get(path, new String[0]);
        final ChunkedFile chunkedFile = new ChunkedFile(p, 16384, 128);
        chunkedFile.init();
        chunkedFile.setChunkBufferSize(3);
        int numThreads = 3;
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        final ConcurrentLinkedQueue chunkFifo = new ConcurrentLinkedQueue();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileChunk nextChunk;
                while ((nextChunk = chunkedFile.next()) != null) {
                    int receivedChunkNum = nextChunk.getChunkNum();
                    log.debug("Thread '{}' received chunk #{}", (Object)Thread.currentThread().getName(), (Object)receivedChunkNum);
                    String s = new String(nextChunk.getBah().getUnderlyingBytes());
                    ChunkedFile chunkedFile2 = chunkedFile;
                    synchronized (chunkedFile2) {
                        if (receivedChunkNum == 1 || receivedChunkNum == 2) {
                            System.out.printf("ADDING chunk #%d ================================================\n", receivedChunkNum);
                            System.out.flush();
                        }
                        chunkFifo.add(nextChunk);
                    }
                    boolean a = true;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                log.debug("Thread '{}' received null for next chunk, terminating", (Object)Thread.currentThread().getName());
            }
        };
        for (int i = 0; i < numThreads; ++i) {
            exec.submit(runnable);
        }
        exec.shutdown();
        exec.awaitTermination(50L, TimeUnit.SECONDS);
        log.debug("Main thread finished");
    }
}

