/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes;

import java.io.Serializable;
import umich.ms.datatypes.index.Index;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.LCMSDataSource;
import umich.ms.fileio.filetypes.util.AbstractFile;

public abstract class AbstractLCMSDataSource<T extends Index<?>>
extends AbstractFile
implements LCMSDataSource<T>,
Serializable {
    private static final long serialVersionUID = 474635825669722535L;
    protected volatile int tasksPerCpuPerBatch = 10;
    protected volatile long parsingTimeout = 30L;
    protected volatile boolean excludeEmptyScans = false;
    protected volatile LCMSRunInfo runInfo = null;
    private volatile Integer numThreadsForParsing = null;

    public AbstractLCMSDataSource(String path) {
        super(path);
    }

    @Override
    public LCMSRunInfo getRunInfo() {
        return this.runInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LCMSRunInfo fetchRunInfo() throws FileParsingException {
        LCMSRunInfo info = this.runInfo;
        if (this.runInfo == null) {
            AbstractLCMSDataSource abstractLCMSDataSource = this;
            synchronized (abstractLCMSDataSource) {
                info = this.runInfo;
                if (info == null) {
                    this.runInfo = info = this.parseRunInfo();
                }
            }
        }
        return info;
    }

    @Override
    public boolean isExcludeEmptyScans() {
        return this.excludeEmptyScans;
    }

    @Override
    public void setExcludeEmptyScans(boolean excludeEmptyScans) {
        this.excludeEmptyScans = excludeEmptyScans;
    }

    @Override
    public Integer getNumThreadsForParsing() {
        return this.numThreadsForParsing == null ? Runtime.getRuntime().availableProcessors() : this.numThreadsForParsing.intValue();
    }

    @Override
    public void setNumThreadsForParsing(Integer numThreadsForParsing) {
        if (numThreadsForParsing == null) {
            this.numThreadsForParsing = Runtime.getRuntime().availableProcessors();
            return;
        }
        if (numThreadsForParsing < 1) {
            throw new IllegalArgumentException("The number of threads can not be less than 1.");
        }
        this.numThreadsForParsing = numThreadsForParsing;
    }

    @Override
    public int getTasksPerCpuPerBatch() {
        return this.tasksPerCpuPerBatch;
    }

    @Override
    public void setTasksPerCpuPerBatch(int tasksPerCpuPerBatch) {
        if (tasksPerCpuPerBatch < 1) {
            throw new IllegalArgumentException("The number of tasks per cpu can not be less than 1.");
        }
        this.tasksPerCpuPerBatch = tasksPerCpuPerBatch;
    }

    @Override
    public long getParsingTimeout() {
        return this.parsingTimeout;
    }

    @Override
    public void setParsingTimeout(long parsingTimeout) {
        if (parsingTimeout < 1L) {
            throw new IllegalArgumentException("Timeout of less than one second is not allowed.");
        }
        if (parsingTimeout < 0L) {
            throw new IllegalArgumentException("Timeout can't be negative.");
        }
        this.parsingTimeout = parsingTimeout;
    }
}

