/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.agilent.cef.example;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import umich.ms.fileio.filetypes.agilent.cef.example.AgilentCompound;
import umich.ms.fileio.filetypes.agilent.cef.example.AgilentCompounds;
import umich.ms.fileio.filetypes.agilent.cef.example.AgilentMSPeak;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.CEF;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.Compound;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.Location;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.P;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.RTRange;
import umich.ms.fileio.filetypes.agilent.cef.jaxb.Spectrum;

public class AgilentCefFile {
    public static String GRP_MOL_IDENTITY = "grp_id";
    public static String GRP_M_COUNT = "grp_m_cnt";
    public static String GRP_Z_COUNT = "grp_z_cnt";
    public static String GRP_Z_CARRIER = "grp_z_crr";
    public static String GRP_ADDUCT = "grp_add";
    public static String GRP_ISOTOPE_NUM = "grp_iso_n";
    Path path;

    public AgilentCefFile(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public AgilentCompounds create() throws IOException {
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalStateException("File path for Agilent .cef does not exist.");
            }
            AgilentCompounds comps = new AgilentCompounds();
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CEF.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            Object unmarshalled = unmarshaller.unmarshal(this.path.toFile());
            CEF cef = (CEF)unmarshalled;
            List<Compound> compList = cef.getCompoundList().getCompound();
            for (Compound c : compList) {
                AgilentCompound ac = new AgilentCompound();
                Location l = c.getLocation();
                ac.setMass(l.getM());
                ac.setRt(l.getRt());
                ac.setAbMax(l.getY());
                ac.setAbTot(l.getV());
                Spectrum s = c.getSpectrum();
                RTRange r = s.getRTRanges().getRTRange();
                ac.setRtLo(r.getMin());
                ac.setRtHi(r.getMax());
                List<P> ps = c.getSpectrum().getMSPeaks().getP();
                for (P p : ps) {
                    AgilentMSPeak peak = new AgilentMSPeak();
                    peak.setMz(p.getX());
                    peak.setRt(p.getRt());
                    peak.setAbMax(p.getY());
                    peak.setAbTot(p.getV().intValue());
                    peak.setZ(p.getZ());
                    peak.setIonDescription(p.getS());
                    ac.add(peak);
                }
                comps.add(ac);
            }
            return comps;
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }
}

