/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.agilent.cef.example;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import umich.ms.fileio.filetypes.agilent.cef.example.AgilentCompound;
import umich.ms.fileio.filetypes.agilent.cef.example.AgilentMSPeak;
import umich.ms.fileio.filetypes.agilent.cef.example.IonId;

public class AgilentCompounds {
    List<AgilentCompound> compounds;

    public AgilentCompounds() {
        this.compounds = new ArrayList<AgilentCompound>();
    }

    public AgilentCompounds(int startSize) {
        this.compounds = new ArrayList<AgilentCompound>(startSize);
    }

    public List<AgilentCompound> getCompounds() {
        return this.compounds;
    }

    public int size() {
        return this.compounds.size();
    }

    public boolean isEmpty() {
        return this.compounds.isEmpty();
    }

    public boolean add(AgilentCompound e) {
        return this.compounds.add(e);
    }

    public void splitCompoundsByAdduct() {
        if (this.compounds.isEmpty()) {
            return;
        }
        ArrayList<AgilentCompound> tmp = new ArrayList<AgilentCompound>(this.compounds.size());
        for (AgilentCompound c : this.compounds) {
            HashMap<String, ArrayList<AgilentMSPeak>> map = new HashMap<String, ArrayList<AgilentMSPeak>>();
            for (AgilentMSPeak p : c.getPeaks()) {
                IonId ionId = p.parseIonSignature();
                if (ionId == null) {
                    throw new IllegalStateException("Ion signature did not match the regexp in AgilentMSPeak");
                }
                p.setIonId(ionId);
                String id = ionId.getMolId();
                ArrayList<AgilentMSPeak> msPeaks = (ArrayList<AgilentMSPeak>)map.get(id);
                if (msPeaks == null) {
                    msPeaks = new ArrayList<AgilentMSPeak>();
                    map.put(id, msPeaks);
                } else {
                    boolean bl = true;
                }
                msPeaks.add(p);
            }
            Set entries = map.entrySet();
            for (Map.Entry id2peaks : entries) {
                AgilentCompound cc = c.cloneWithoutPeaks();
                List peakList = (List)id2peaks.getValue();
                Collections.sort(peakList);
                cc.addAll(peakList);
                tmp.add(cc);
            }
        }
        this.compounds = tmp;
    }
}

