/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.gpmdb;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.gpmdb.jaxb.Bioml;
import umich.ms.fileio.filetypes.util.AbstractFile;

public class GPMDBFile
extends AbstractFile {
    public GPMDBFile(String path) {
        super(path);
    }

    public Bioml parse() throws FileParsingException {
        try {
            Bioml bioml;
            Path filePath = Paths.get(this.getPath(), new String[0]);
            FileInputStream fis = new FileInputStream(filePath.toFile());
            BufferedInputStream bis = new BufferedInputStream(fis, 0x2000000);
            Class<Bioml> clazz = Bioml.class;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object unmarshalled = unmarshaller.unmarshal((InputStream)bis);
            Bioml bioml2 = bioml = this.convertJAXBObjectToDomain(clazz, unmarshalled);
            return bioml2;
        }
        catch (FileNotFoundException | JAXBException e) {
            throw new FileParsingException(e);
        }
    }

    protected <T> T convertJAXBObjectToDomain(Class<T> clazz, Object unmarshalled) {
        if (unmarshalled == null) {
            throw new RuntimeException("Unmarshalled run header object was null");
        }
        if (!clazz.isAssignableFrom(unmarshalled.getClass())) {
            throw new RuntimeException(String.format("When parsing XML, JAXB object's declared type was wrong. Expected: %s; Found: %s", clazz.getSimpleName(), unmarshalled.getClass().getSimpleName()));
        }
        return (T)unmarshalled;
    }
}

