/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzidentml.example;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzidentml.MzIdentMLParser;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.MzIdentMLType;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.SpectrumIdentificationItemType;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.SpectrumIdentificationListType;
import umich.ms.fileio.filetypes.mzidentml.jaxb.standard.SpectrumIdentificationResultType;

public class MzIdentMlExample {
    public static void main(String[] args) throws FileParsingException, XMLStreamException, JAXBException {
        if (args.length < 1) {
            throw new IllegalArgumentException("You must specify the filepath using command line arguments");
        }
        Path path = Paths.get(args[0], new String[0]);
        MzIdentMLType mzid = MzIdentMLParser.parse(path);
        List<SpectrumIdentificationListType> spectrumIdentificationLists = mzid.getDataCollection().getAnalysisData().getSpectrumIdentificationList();
        for (SpectrumIdentificationListType sil : spectrumIdentificationLists) {
            System.out.printf("Processing spec id list: %s, number of sequences searched: %s\n", sil.getName(), sil.getNumSequencesSearched());
            List<SpectrumIdentificationResultType> spectrumIdentificationResults = sil.getSpectrumIdentificationResult();
            for (SpectrumIdentificationResultType sir : spectrumIdentificationResults) {
                List<SpectrumIdentificationItemType> spectrumIdentificationItems = sir.getSpectrumIdentificationItem();
                for (SpectrumIdentificationItemType si : spectrumIdentificationItems) {
                    System.out.printf("Spectrum ID: %s, calc m/z: %.3f, exp m/z: %.3f\n", si.getId(), si.getCalculatedMassToCharge(), si.getExperimentalMassToCharge());
                }
            }
            System.out.printf("Done processing spec id list: %s\n", sil.getName());
        }
        System.out.println();
    }
}

