/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scancollection.impl.ScanCollectionDefault;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLIndex;
import umich.ms.fileio.filetypes.mzml.MZMLIndexElement;
import umich.ms.fileio.filetypes.mzml.MZMLIndexParser;
import umich.ms.fileio.filetypes.mzml.MZMLMultiSpectraParser;
import umich.ms.fileio.filetypes.mzml.MZMLRunHeaderParser;
import umich.ms.fileio.filetypes.util.MultiSpectraParser;
import umich.ms.fileio.filetypes.xmlbased.AbstractXMLBasedDataSource;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;
import umich.ms.fileio.util.FileListing;
import umich.ms.logging.LogHelper;
import umich.ms.util.IntervalST;

public class MZMLFile
extends AbstractXMLBasedDataSource<MZMLIndexElement, MZMLIndex> {
    private MZMLIndex index;

    public MZMLFile(String path) {
        super(path);
    }

    public ObjectPool<XMLStreamReaderImpl> getReaderPool() {
        return this.readerPool;
    }

    @Override
    public MZMLIndex getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MZMLIndex fetchIndex() throws FileParsingException {
        MZMLIndex tmp = this.index;
        if (tmp == null) {
            MZMLFile mZMLFile = this;
            synchronized (mZMLFile) {
                tmp = this.getIndex();
                if (tmp == null) {
                    this.index = tmp = this.parseIndex();
                }
            }
        }
        return tmp;
    }

    @Override
    public MZMLIndex parseIndex() throws FileParsingException {
        MZMLIndexParser parser = new MZMLIndexParser(this);
        return parser.parse();
    }

    @Override
    public LCMSRunInfo parseRunInfo() throws FileParsingException {
        MZMLRunHeaderParser parser = new MZMLRunHeaderParser(this);
        return parser.parse();
    }

    @Override
    protected void releaseResources() {
        this.index = null;
    }

    @Override
    public MZMLMultiSpectraParser getSpectraParser(InputStream inputStream, LCMSDataSubset subset, ObjectPool<XMLStreamReaderImpl> readerPool, Integer numSpectra) {
        MZMLMultiSpectraParser parser;
        try {
            parser = new MZMLMultiSpectraParser(inputStream, subset, this);
        }
        catch (FileParsingException ex) {
            throw new IllegalStateException(ex);
        }
        parser.setNumScansToProcess(numSpectra);
        parser.setReaderPool(readerPool);
        return parser;
    }

    @Override
    public IndexBuilder<MZMLIndexElement> getIndexBuilder(IndexBuilder.Info info) {
        MultiSpectraParser parser = this.getSpectraParser(info.is, LCMSDataSubset.STRUCTURE_ONLY, (ObjectPool)this.getReaderPool(), (Integer)null);
        MZMLMultiSpectraParser.MZMLIndexBuilder builder = ((MZMLMultiSpectraParser)parser).getIndexBuilder(info);
        return builder;
    }

    public static void main(String[] args) throws FileParsingException {
        LogHelper.configureJavaUtilLogging();
        if (args.length == 0) {
            System.out.println("Give me a dollar. And a list of mzML files. E.g.: \n\tjava -jar MSDataStructures.jar ./*.mzML");
            System.exit(0);
        }
        String[] filenames = args;
        Integer numThreads = null;
        Integer numSpectraPerThread = 50;
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 0; i < filenames.length; ++i) {
            Path path;
            String filename = filenames[i];
            if (i == 0) {
                try {
                    int numThreadsParsed = Integer.parseInt(filename);
                    numThreads = numThreadsParsed;
                    System.out.printf("Setting number of threads to: %d\n", numThreadsParsed);
                    continue;
                }
                catch (NumberFormatException numThreadsParsed) {
                    // empty catch block
                }
            }
            if (i == 1) {
                try {
                    int numSpectraPerThreadParsed = Integer.parseInt(filename);
                    numSpectraPerThread = numSpectraPerThreadParsed;
                    System.out.printf("Setting number of spectra per thread to: %d\n", numSpectraPerThreadParsed);
                    continue;
                }
                catch (NumberFormatException numSpectraPerThreadParsed) {
                    // empty catch block
                }
            }
            if (!Files.exists(path = Paths.get(filename, new String[0]).toAbsolutePath(), new LinkOption[0])) {
                System.err.println("File does not exist: " + path.toString());
                System.exit(1);
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                paths.add(path);
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            FileListing fileListing = new FileListing(path, ".*\\.mzML");
            fileListing.setFollowLinks(false);
            fileListing.setRecursive(false);
            paths.addAll(fileListing.findFiles());
        }
        for (Path path : paths) {
            double fileSize = path.toFile().length() / 0x100000L;
            System.out.printf("File: %s (%.2fMb)\n", path.toString(), fileSize);
            MZMLFile mzml = new MZMLFile(path.toString());
            LCMSRunInfo lcmsRunInfo = mzml.fetchRunInfo();
            System.out.println(lcmsRunInfo.toString());
            mzml.setNumThreadsForParsing(numThreads);
            mzml.setTasksPerCpuPerBatch(numSpectraPerThread);
            mzml.setParsingTimeout(30000L);
            long startTime = System.nanoTime();
            MZMLIndex index = mzml.fetchIndex();
            if (index.size() > 0) {
                MZMLIndexElement byNum = (MZMLIndexElement)index.getByNum(1);
                MZMLIndexElement byRawNum = (MZMLIndexElement)index.getByRawNum(byNum.getRawNumber());
                MZMLIndexElement byId = (MZMLIndexElement)index.getById(byNum.getId());
                boolean bl = true;
            } else {
                System.err.println("Parsed index was empty!");
            }
            System.out.println("It took: " + (double)(System.nanoTime() - startTime) / 1.0E9 + " seconds to parse index (" + index.size() + " spectra)");
            startTime = System.nanoTime();
            ScanCollectionDefault scans = new ScanCollectionDefault(true);
            scans.setDataSource(mzml);
            scans.loadData(LCMSDataSubset.WHOLE_RUN, StorageStrategy.STRONG);
            System.out.println("It took: " + (double)(System.nanoTime() - startTime) / 1.0E9 + " seconds to parse all scans (" + scans.getScanCount() + " spectra)");
            TreeMap<Integer, IScan> num2scanMap = scans.getMapNum2scan();
            Set<Map.Entry<Integer, IScan>> num2scanEntries = num2scanMap.entrySet();
            int counterMzIntPairs = 0;
            for (Map.Entry<Integer, IScan> next : num2scanEntries) {
                IScan scan = next.getValue();
                if (scan.getSpectrum() == null) continue;
                counterMzIntPairs += scan.getSpectrum().getMZs().length;
            }
            IScan scan = scans.getMapNum2scan().firstEntry().getValue();
            ISpectrum spectrum = scan.fetchSpectrum();
            double[] mzs = spectrum.getMZs();
            double[] intensities = spectrum.getIntensities();
            System.out.print("First ten valus of m/z and intensity arrays of the 1st scan:\n\t");
            for (int i = 0; i < mzs.length && i < 10; ++i) {
                System.out.printf("%.3f=%.1f; ", mzs[i], intensities[i]);
            }
            System.out.println();
            System.out.printf("Total number of mz-intensity pairs: %d\n", counterMzIntPairs);
            DecimalFormat formatter = new DecimalFormat("0.##E0");
            double doubleArraysSizeMb = (double)counterMzIntPairs * 2.0 * 8.0 / 1048576.0;
            System.out.printf("Thas is: %s (%.2fMB)\n", formatter.format(counterMzIntPairs), doubleArraysSizeMb);
            TreeMap<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> mapMsLevel2rangeGroups = scans.getMapMsLevel2rangeGroups();
            Set<Map.Entry<Integer, IntervalST<Double, TreeMap<Integer, IScan>>>> entries = mapMsLevel2rangeGroups.entrySet();
            for (Map.Entry<Integer, IntervalST<Double, TreeMap<Integer, IScan>>> next : entries) {
                Integer msLevel = next.getKey();
                IntervalST<Double, TreeMap<Integer, IScan>> mzRangesAtMsLevel = next.getValue();
                System.out.printf("Tree at MS level: %d\n", msLevel);
                for (IntervalST.Node<Double, TreeMap<Integer, IScan>> node : mzRangesAtMsLevel) {
                    System.out.printf("Interval: %s contains %d scans\n", node.getInterval().toString(), node.getValue().size());
                }
                System.out.println("=================");
                System.out.println();
            }
            TreeMap<Integer, IScan> mapNum2scan = scans.getMapNum2scan();
            boolean bl = false;
        }
    }
}

