/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLInputFactoryImpl;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLUnexpectedEndTagException;
import org.apache.commons.pool2.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.exceptions.IndexBrokenException;
import umich.ms.fileio.exceptions.IndexNotFoundException;
import umich.ms.fileio.filetypes.mzml.MZMLFile;
import umich.ms.fileio.filetypes.mzml.MZMLIndex;
import umich.ms.fileio.filetypes.mzml.MZMLIndexElement;
import umich.ms.fileio.filetypes.mzml.MZMLMultiSpectraParser;
import umich.ms.fileio.filetypes.util.MultiSpectraParser;
import umich.ms.fileio.filetypes.xmlbased.OffsetLength;
import umich.ms.logging.LogHelper;

public class MZMLIndexParser {
    private static final Logger log = LoggerFactory.getLogger(MZMLIndexParser.class);
    protected MZMLFile source;
    protected String FILE_TYPE_NAME = "mzML";
    protected String TAG_INDEXOFFSET = "indexListOffset";
    protected String TAG_INDEX = "index";
    protected String INDEX_NAME = "spectrum";
    protected String TAG_OFFSET = "offset";
    protected String ATTR_OFFSET_ID = "idRef";
    protected String TAG_END_OF_RUN = "spectrumList";
    protected Pattern RE_INDEX_OFFSET = Pattern.compile("<" + this.TAG_INDEXOFFSET + ">(\\d+)<");
    protected int MAX_BYTES_FROM_END_TO_SEARCH_FOR_INDEX = 1024;
    protected int NUM_BYTES_TO_CHECK_INDEX = 1024;
    protected static int INDEX_OFFSET_MIN_VALUE = 128;
    protected Pattern RE_INDEX_ENTRY_SIMPLE = Pattern.compile(String.format("<%s[^>]*?>\\s*(\\d+?)\\s*</%s>", this.TAG_OFFSET, this.TAG_OFFSET));
    protected Pattern RE_END_OF_RUN = Pattern.compile("</" + this.TAG_END_OF_RUN + ">");

    public MZMLIndexParser(MZMLFile source) {
        this.source = source;
        LogHelper.setJavolutionLogLevelFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MZMLIndex parse() throws FileParsingException {
        TreeMap<Integer, OffsetId> scanIndex = new TreeMap<Integer, OffsetId>();
        try {
            RandomAccessFile fileHandle = this.source.getRandomAccessFile();
            long offset = this.findIndexOffset(fileHandle);
            if (offset < (long)INDEX_OFFSET_MIN_VALUE) {
                throw new FileParsingException(String.format("When parsing index, the offset of the beginning of the index was small (less than %d bytes). Likely a broken file, this happens with larger files converted with some versions of ProteoWizard.", INDEX_OFFSET_MIN_VALUE));
            }
            scanIndex.put(Integer.MAX_VALUE, new OffsetId(Long.MAX_VALUE, "END_OF_SCANS"));
            fileHandle.seek(offset);
            int lenToEnd = (int)(fileHandle.length() - offset);
            byte[] bytes = new byte[lenToEnd];
            int readResult = fileHandle.read(bytes);
            this.parseIndexEntries(bytes, scanIndex);
            this.source.close();
        }
        catch (IOException e) {
            throw new FileParsingException(e);
        }
        catch (IndexBrokenException | IndexNotFoundException ex) {
            this.source.close();
            MZMLIndex index = new MZMLIndex();
            MZMLIndex mZMLIndex = index = this.source.buildIndex(index);
            return mZMLIndex;
        }
        finally {
            this.source.close();
        }
        MZMLIndex index = new MZMLIndex();
        int curScanNumRaw = scanIndex.firstEntry().getKey();
        long curScanOffset = scanIndex.firstEntry().getValue().offset;
        int scanNumInternal = 1;
        String curScanId = scanIndex.firstEntry().getValue().id;
        if (curScanNumRaw == Integer.MAX_VALUE) {
            int length = this.findScanLength(curScanOffset);
            OffsetLength offlen = new OffsetLength(curScanOffset, length);
            MZMLIndexElement indexElem = new MZMLIndexElement(scanNumInternal++, curScanNumRaw, curScanId, offlen);
            index.add(indexElem);
        } else {
            Set<Map.Entry<Integer, OffsetId>> entries = scanIndex.entrySet();
            Iterator<Map.Entry<Integer, OffsetId>> iterator = entries.iterator();
            Map.Entry<Integer, OffsetId> firstEntry = iterator.next();
            curScanId = firstEntry.getValue().id;
            curScanNumRaw = firstEntry.getKey();
            curScanOffset = firstEntry.getValue().offset;
            while (iterator.hasNext()) {
                Map.Entry<Integer, OffsetId> nextScanEntry = iterator.next();
                int nextScanNumRaw = nextScanEntry.getKey();
                long nextScanOffset = nextScanEntry.getValue().offset;
                String nextScanId = nextScanEntry.getValue().id;
                if (nextScanOffset < curScanOffset) {
                    log.warn("Found mzML index entry with offset smaller than the previous entry in the same index. Entry #{}, found offset: {}, previous entry #{}, previous offset: {}", nextScanNumRaw, nextScanOffset, curScanNumRaw, curScanOffset);
                    continue;
                }
                int length = nextScanNumRaw == Integer.MAX_VALUE ? this.findScanLength(curScanOffset) : (int)(nextScanOffset - curScanOffset);
                OffsetLength offlen = new OffsetLength(curScanOffset, length);
                MZMLIndexElement indexElem = new MZMLIndexElement(scanNumInternal++, curScanNumRaw, curScanId, offlen);
                index.add(indexElem);
                curScanNumRaw = nextScanNumRaw;
                curScanOffset = nextScanOffset;
                curScanId = nextScanId;
            }
        }
        return index;
    }

    protected int findScanLength(long offset) throws FileParsingException {
        int length = -1;
        try {
            RandomAccessFile raf = this.source.getRandomAccessFile();
            raf.seek(offset);
            InputStream is = Channels.newInputStream(raf.getChannel());
            BufferedInputStream bis = new BufferedInputStream(is);
            MultiSpectraParser parser = this.source.getSpectraParser((InputStream)bis, LCMSDataSubset.STRUCTURE_ONLY, (ObjectPool)this.source.getReaderPool(), (Integer)1);
            length = ((MZMLMultiSpectraParser)parser).findThisStreamFirstScanLen();
            is.close();
        }
        catch (IOException e) {
            throw new FileParsingException(e);
        }
        finally {
            this.source.close();
        }
        return length;
    }

    protected long findIndexOffset(RandomAccessFile raf) throws IOException, IndexNotFoundException, IndexBrokenException {
        long fileLen = raf.length();
        int bytesToRead = fileLen > (long)this.MAX_BYTES_FROM_END_TO_SEARCH_FOR_INDEX ? this.MAX_BYTES_FROM_END_TO_SEARCH_FOR_INDEX : (int)fileLen;
        long offsetFromEOF = fileLen - (long)bytesToRead;
        raf.seek(offsetFromEOF);
        byte[] bytes = new byte[bytesToRead];
        raf.readFully(bytes, 0, bytes.length);
        String fileEndingStr = new String(bytes);
        Matcher matcher = this.RE_INDEX_OFFSET.matcher(fileEndingStr);
        long indexOffset = -1L;
        if (matcher.find()) {
            indexOffset = Long.parseLong(matcher.group(1));
        }
        if (indexOffset == -1L) {
            throw new IndexNotFoundException(String.format("%s <%s> section was not found within the last %d bytes in the file! (%s)", this.FILE_TYPE_NAME, this.TAG_INDEXOFFSET, this.MAX_BYTES_FROM_END_TO_SEARCH_FOR_INDEX, this.source.getPath()));
        }
        if (indexOffset < (long)INDEX_OFFSET_MIN_VALUE) {
            throw new IndexBrokenException(String.format("Index offset was less than %d, actual value: [%d] - not allowed", INDEX_OFFSET_MIN_VALUE, indexOffset));
        }
        if (indexOffset > fileLen) {
            throw new IndexBrokenException(String.format("Index offset was larger than the length of the file, actual value: [%d]", indexOffset));
        }
        long lenFromIndexStartToEOF = fileLen - indexOffset;
        int indexBeginLength = lenFromIndexStartToEOF >= (long)this.NUM_BYTES_TO_CHECK_INDEX ? this.NUM_BYTES_TO_CHECK_INDEX : (int)lenFromIndexStartToEOF;
        byte[] indexBeginBytes = new byte[indexBeginLength];
        raf.seek(indexOffset);
        raf.readFully(indexBeginBytes, 0, indexBeginBytes.length);
        String indexBeginStr = new String(indexBeginBytes);
        Matcher matcherIdxEntry = this.RE_INDEX_ENTRY_SIMPLE.matcher(indexBeginStr);
        long offsetPrev = -2L;
        while (matcherIdxEntry.find()) {
            long offsetCur = Long.parseLong(matcherIdxEntry.group(1));
            if (offsetCur < 0L) {
                throw new IndexBrokenException(String.format("The index contained an element less than zero: '%s'", matcherIdxEntry.group(0)));
            }
            if (offsetCur <= offsetPrev) {
                throw new IndexBrokenException(String.format("The index contained an element less or equal to a previous one. The match was: '%s'", matcherIdxEntry.group(0)));
            }
            if (offsetCur >= indexOffset) {
                throw new IndexBrokenException(String.format("The index contained an element that was further in the file than the '%s'.", this.TAG_INDEXOFFSET));
            }
            offsetPrev = offsetCur;
        }
        return indexOffset;
    }

    protected void parseIndexEntries(byte[] bytes, TreeMap<Integer, OffsetId> map) throws FileParsingException {
        block11: {
            XMLInputFactoryImpl factory = new XMLInputFactoryImpl();
            try {
                int eventType;
                XMLStreamReader reader = factory.createXMLStreamReader(new ByteArrayInputStream(bytes));
                boolean isInsideSpectrumIndex = false;
                boolean stopReading = false;
                int scanNumOrdinal = 0;
                long offsetPrev = -1L;
                block6: do {
                    eventType = reader.next();
                    switch (eventType) {
                        case 1: {
                            if (isInsideSpectrumIndex && reader.getLocalName().equals(this.TAG_OFFSET)) {
                                CharArray offsetId = reader.getAttributeValue(null, this.ATTR_OFFSET_ID);
                                int scanNum = scanNumOrdinal++;
                                eventType = reader.next();
                                if (eventType != 4) {
                                    throw new FileParsingException(String.format("Could not find scan offset, specified as CHARACTERS after <%s> tag in %s file", this.TAG_OFFSET, this.FILE_TYPE_NAME));
                                }
                                long offset = reader.getText().toLong();
                                if (offset == offsetPrev) {
                                    throw new FileParsingException("When parsing index, encountered same offsets for different spectra. Likely a broken file, this happens when converting large files with specific versions of ProteoWizard.");
                                }
                                map.put(scanNum, new OffsetId(offset, offsetId.toString()));
                                offsetPrev = offset;
                                break;
                            }
                            if (!reader.getLocalName().equals(this.TAG_INDEX)) break;
                            CharArray name = reader.getAttributeValue(null, "name");
                            if (name == null) {
                                throw new FileParsingException("mzML file index list did not contain a 'name' attribute for one of its indexes");
                            }
                            if (!name.equals(this.INDEX_NAME)) continue block6;
                            isInsideSpectrumIndex = true;
                            break;
                        }
                        case 2: {
                            if (!isInsideSpectrumIndex || !reader.getLocalName().equals(this.TAG_INDEX)) continue block6;
                            stopReading = true;
                        }
                    }
                } while (!stopReading && eventType != 8);
            }
            catch (XMLStreamException e) {
                if (!(e instanceof XMLUnexpectedEndTagException)) break block11;
                throw new FileParsingException("Error when parsing index entries", e);
            }
        }
    }

    protected class OffsetId {
        public final long offset;
        public final String id;

        public OffsetId(long offset, String id) {
            this.offset = offset;
            this.id = id;
        }
    }
}

