/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.zip.DataFormatException;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLUnexpectedEndOfDocumentException;
import javolution.xml.stream.XMLUnexpectedEndTagException;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.PeaksCompression;
import umich.ms.datatypes.scan.impl.ScanDefault;
import umich.ms.datatypes.scan.props.ActivationInfo;
import umich.ms.datatypes.scan.props.InjectionInfo;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.datatypes.scan.props.Polarity;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.scan.props.ScanType;
import umich.ms.datatypes.spectrum.impl.SpectrumDefault;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLFile;
import umich.ms.fileio.filetypes.mzml.MZMLIndex;
import umich.ms.fileio.filetypes.mzml.MZMLIndexElement;
import umich.ms.fileio.filetypes.mzml.MZMLPeaksDecoder;
import umich.ms.fileio.filetypes.mzml.util.PSIMSCV;
import umich.ms.fileio.filetypes.util.MultiSpectraParser;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;
import umich.ms.fileio.filetypes.xmlbased.OffsetLength;
import umich.ms.logging.LogHelper;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.base64.Base64;
import umich.ms.util.base64.Base64Context;
import umich.ms.util.base64.Base64ContextPooled;

public class MZMLMultiSpectraParser
extends MultiSpectraParser {
    protected final MZMLFile source;
    protected LCMSRunInfo runInfo;
    protected MZMLIndex index;
    protected ArrayList<IScan> parsedScans;
    protected VarsHolder vars;
    protected ObjectPool<XMLStreamReaderImpl> readerPool = null;
    private int numOpeningScanTagsFound;

    public MZMLMultiSpectraParser(InputStream is, LCMSDataSubset subset, MZMLFile source) throws FileParsingException {
        super(is, subset);
        this.source = source;
    }

    public MZMLFile getSource() {
        return this.source;
    }

    public ObjectPool<XMLStreamReaderImpl> getReaderPool() {
        return this.readerPool;
    }

    public void setReaderPool(ObjectPool<XMLStreamReaderImpl> readerPool) {
        this.readerPool = readerPool;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IScan> call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void tagPrecursorStart(XMLStreamReaderImpl reader) throws FileParsingException {
        if (this.flushVarsIfNoCurScan()) {
            return;
        }
        PrecursorInfo precursorInfo = new PrecursorInfo();
        ActivationInfo activationInfo = precursorInfo.getActivationInfo();
        Attributes attrs = reader.getAttributes();
        CharArray attr = attrs.getValue(ATTR.PRECURSOR_SPEC_REF.name);
        if (attr != null) {
            precursorInfo.setParentScanRefRaw(attr.toString());
            try {
                int scanNumInternal = this.mapIdRefToInternalScanNum(attr);
                precursorInfo.setParentScanNum(scanNumInternal);
            }
            catch (FileParsingException scanNumInternal) {
                // empty catch block
            }
        }
        int eventType = 8;
        CharArray localName = TAG.PRECURSOR.charArray;
        block16: do {
            try {
                eventType = reader.next();
                if (eventType != 1 && eventType != 2) {
                    continue;
                }
            }
            catch (XMLStreamException e) {
                if (e instanceof XMLUnexpectedEndTagException) continue;
                throw new FileParsingException(e);
            }
            localName = reader.getLocalName();
            if (eventType != 1) continue;
            attrs = reader.getAttributes();
            if (!localName.equals(TAG.CV_PARAM.name)) continue;
            attr = attrs.getValue(ATTR.CV_PARAM_ACCESSION.name);
            CharArray val = attrs.getValue(ATTR.CV_PARAM_VALUE.name);
            if (attr == null) {
                throw new FileParsingException("cvParam did not have an 'accession' or 'value' attribute, which are required");
            }
            PSIMSCV cvEntry = PSIMSCV.fromAccession(attr);
            if (cvEntry == null) {
                String activationMethod = PSIMSCV.activationMethodFromAccession(attr);
                if (activationMethod == null) continue;
                activationInfo.setActivationMethod(activationMethod);
                continue;
            }
            switch (cvEntry) {
                case MS_PRECURSOR_ISO_WND_TARGET: {
                    this.vars.precursorIsoWndTarget = val.toDouble();
                    break;
                }
                case MS_PRECURSOR_INTENSITY: {
                    this.vars.precursorIntensity = val.toDouble();
                    precursorInfo.setIntensity(this.vars.precursorIntensity);
                    break;
                }
                case MS_PRECURSOR_ISO_WND_LO_OFFSET: {
                    this.vars.precursorIsoWndLoOffset = val.toDouble();
                    break;
                }
                case MS_PRECURSOR_ISO_WND_HI_OFFSET: {
                    this.vars.precursorIsoWndHiOffset = val.toDouble();
                    break;
                }
                case MS_PRECURSOR_ISO_WND_LO_OBSOLETE: {
                    precursorInfo.setMzRangeStart(val.toDouble());
                    break;
                }
                case MS_PRECURSOR_ISO_WND_HI_OBSOLETE: {
                    precursorInfo.setMzRangeEnd(val.toDouble());
                    break;
                }
                case MS_PRECURSOR_MZ: {
                    precursorInfo.setMzTarget(val.toDouble());
                    break;
                }
                case MS_PRECURSOR_CHARGE: {
                    precursorInfo.setCharge(val.toInt());
                    break;
                }
                case MS_ACTIVATION_ENERGY_1: 
                case MS_ACTIVATION_ENERGY_2: 
                case MS_ACTIVATION_ENERGY_LO: 
                case MS_ACTIVATION_ENERGY_SUP: {
                    activationInfo.setActivationEnergyLo(val.toDouble());
                    Double eHi = activationInfo.getActivationEnergyHi();
                    if (eHi != null && !Double.isNaN(eHi)) continue block16;
                    activationInfo.setActivationEnergyHi(val.toDouble());
                    break;
                }
                case MS_ACTIVATION_ENERGY_HI: {
                    activationInfo.setActivationEnergyHi(val.toDouble());
                }
            }
        } while (eventType != 2 || !localName.equals(TAG.PRECURSOR.name));
        if (precursorInfo.getMzRangeStart() == null) {
            if (this.vars.precursorIsoWndLoOffset != null) {
                if (this.vars.precursorIsoWndTarget != null) {
                    precursorInfo.setMzRangeStart(this.vars.precursorIsoWndTarget - this.vars.precursorIsoWndLoOffset);
                } else if (precursorInfo.getMzTarget() != null) {
                    precursorInfo.setMzRangeStart(precursorInfo.getMzTarget() - this.vars.precursorIsoWndLoOffset);
                }
            } else if (precursorInfo.getMzTarget() != null) {
                precursorInfo.setMzRangeStart(precursorInfo.getMzTarget());
            }
        }
        if (precursorInfo.getMzRangeEnd() == null) {
            if (this.vars.precursorIsoWndHiOffset != null) {
                if (this.vars.precursorIsoWndTarget != null) {
                    precursorInfo.setMzRangeEnd(this.vars.precursorIsoWndTarget + this.vars.precursorIsoWndHiOffset);
                } else if (precursorInfo.getMzTarget() != null) {
                    precursorInfo.setMzRangeEnd(precursorInfo.getMzTarget() + this.vars.precursorIsoWndHiOffset);
                }
            } else if (precursorInfo.getMzTarget() != null) {
                precursorInfo.setMzRangeEnd(precursorInfo.getMzTarget());
            }
        }
        this.vars.precursors.add(precursorInfo);
        this.vars.curScan.setPrecursor(precursorInfo);
    }

    private void tagBinaryDataListStart(XMLStreamReaderImpl reader, Attributes attrs) throws FileParsingException, DataFormatException, IllegalStateException, IOException {
        if (this.flushVarsIfNoCurScan() || !this.doesNeedSpectrumParsing(this.vars.curScan)) {
            return;
        }
        int eventType = 8;
        CharArray localName = TAG.BINARY_DATA_LIST.charArray;
        do {
            try {
                eventType = reader.next();
                if (eventType != 1 && eventType != 2) {
                    continue;
                }
            }
            catch (XMLStreamException e) {
                if (e instanceof XMLUnexpectedEndTagException) continue;
                throw new FileParsingException(e);
            }
            localName = reader.getLocalName();
            if (eventType != 1) continue;
            if (localName.equals(TAG.CV_PARAM.name)) {
                CharArray attr = attrs.getValue(ATTR.CV_PARAM_ACCESSION.name);
                if (attr == null) {
                    throw new FileParsingException("cvParam did not have an 'accession' or 'value' attribute, which are required");
                }
                PSIMSCV cvEntry = PSIMSCV.fromAccession(attr);
                if (cvEntry == null) break;
                switch (cvEntry) {
                    case MS_PRECISION_32: {
                        this.vars.precision = 32;
                        break;
                    }
                    case MS_PRECISION_64: {
                        this.vars.precision = 64;
                        break;
                    }
                    case MS_COMPRESSION_ZLIB: {
                        this.vars.getCompressions().add(PeaksCompression.ZLIB);
                        break;
                    }
                    case MS_COMPRESSION_NONE: {
                        this.vars.getCompressions().add(PeaksCompression.NONE);
                        break;
                    }
                    case MS_COMPRESSION_NUMPRESS_LIN_PRED: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_LINPRED);
                        break;
                    }
                    case MS_COMPRESSION_NUMPRESS_LOG_FLOAT: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_SHLOGF);
                        break;
                    }
                    case MS_COMPRESSION_NUMPRESS_POS_INT: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_POSINT);
                        break;
                    }
                    case MS_DATA_ARRAY_MZ: {
                        this.vars.binDataType = VarsHolder.BIN_DATA_TYPE.MZ;
                        break;
                    }
                    case MS_DATA_ARRAY_INTENSITY: {
                        this.vars.binDataType = VarsHolder.BIN_DATA_TYPE.INTENSITY;
                    }
                }
                continue;
            }
            if (!localName.equals(TAG.BINARY.name)) continue;
            try {
                block30: {
                    block28: {
                        block29: {
                            eventType = reader.next();
                            if (eventType == 4) break block28;
                            if (eventType != 2) break block29;
                            localName = reader.getLocalName();
                            if (!localName.equals(TAG.BINARY.name)) break block30;
                            switch (this.vars.binDataType) {
                                case MZ: {
                                    this.vars.mzData = MZMLPeaksDecoder.DecodedData.createEmpty();
                                    break block30;
                                }
                                case INTENSITY: {
                                    this.vars.intensityData = MZMLPeaksDecoder.DecodedData.createEmpty();
                                    break block30;
                                }
                                default: {
                                    throw new IllegalStateException("Binary data was decoded, but we did not finda specification if this was mz or intensity data.");
                                }
                            }
                        }
                        throw new FileParsingException("Binary data tag <binary> wasn't immediately followed by Base64 encoded string");
                    }
                    Base64 base64 = new Base64();
                    Base64ContextPooled ctx = new Base64ContextPooled();
                    CharArray chars = reader.getText();
                    Base64Context decodedB64 = base64.decode(chars.array(), chars.offset(), chars.length(), (Base64Context)ctx);
                    ByteArrayHolder bah = decodedB64.readResults();
                    MZMLPeaksDecoder.DecodedData decoded = MZMLPeaksDecoder.decode(bah.getUnderlyingBytes(), bah.getPosition(), this.vars.precision, this.vars.defaultArrayLength, this.vars.getCompressions());
                    ((Base64Context)ctx).close();
                    switch (this.vars.binDataType) {
                        case MZ: {
                            this.vars.mzData = decoded;
                            break;
                        }
                        case INTENSITY: {
                            this.vars.intensityData = decoded;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Binary data was decoded, but we did not finda specification if this was mz or intensity data.");
                        }
                    }
                }
                this.vars.flushBinDataDescription();
            }
            catch (XMLStreamException e) {
                throw new FileParsingException(e);
            }
        } while (eventType != 2 || !localName.equals(TAG.BINARY_DATA_LIST.name));
        double basePeakMz = this.vars.intensityData.valMaxPos < 0 ? 0.0 : this.vars.mzData.arr[this.vars.intensityData.valMaxPos];
        SpectrumDefault spectrum = new SpectrumDefault(this.vars.mzData.arr, this.vars.intensityData.arr, this.vars.intensityData.valMin, this.vars.intensityData.valMinNonZero, this.vars.intensityData.valMax, basePeakMz, this.vars.intensityData.sum);
        this.vars.curScan.setSpectrum(spectrum, false);
    }

    private void tagSpectrumInstarumentStart(Attributes attrs) throws FileParsingException {
        CharArray attr = attrs.getValue(ATTR.SPECTRUM_INSTRUMENT.name);
        Instrument instrument = this.runInfo.getDefaultInstrument();
        if (attr != null && (instrument = this.runInfo.getInstrument(attr.toString())) == null) {
            throw new FileParsingException(String.format("An instrument ref was not present for scan  index #%d, but run header did not contain that ref.", this.vars.spectrumIndex));
        }
        this.vars.curScan.setInstrument(instrument);
    }

    private void tagCvParamStart(Attributes attrs, XMLStreamReaderImpl reader) throws FileParsingException {
        if (this.flushVarsIfNoCurScan()) {
            return;
        }
        CharArray attr = attrs.getValue(ATTR.CV_PARAM_ACCESSION.name);
        CharArray val = attrs.getValue(ATTR.CV_PARAM_VALUE.name);
        if (attr == null) {
            throw new FileParsingException("cvParam did not have an 'accession' attribute, which is required");
        }
        PSIMSCV cvEntry = PSIMSCV.fromAccession(attr);
        if (cvEntry == null) {
            return;
        }
        block0 : switch (cvEntry) {
            case MS_LEVEL: {
                this.vars.curScan.setMsLevel(val.toInt());
                break;
            }
            case MS_POLARITY_POS_OBSOLETE: 
            case MS_POLARITY_POS: {
                this.vars.curScan.setPolarity(Polarity.POSITIVE);
                break;
            }
            case MS_POLARITY_NEG_OBSOLETE: 
            case MS_POLARITY_NEG: {
                this.vars.curScan.setPolarity(Polarity.NEGATIVE);
                break;
            }
            case MS_CENTROIDED: {
                this.vars.curScan.setCentroided(true);
                break;
            }
            case MS_PROFILE: {
                this.vars.curScan.setCentroided(false);
                break;
            }
            case MS_MZ_OBSERVED_LO: 
            case MS_MZ_OBSERVED_LO_INST_SETTING: {
                this.vars.curScan.setScanMzWindowLower(val.toDouble());
                break;
            }
            case MS_MZ_OBSERVED_HI: 
            case MS_MZ_OBSERVED_HI_INST_SETTING: {
                this.vars.curScan.setScanMzWindowUpper(val.toDouble());
                break;
            }
            case MS_BASEPEAK_MZ: {
                this.vars.curScan.setBasePeakMz(val.toDouble());
                break;
            }
            case MS_BASEPEAK_INTENSITY: {
                this.vars.curScan.setBasePeakIntensity(val.toDouble());
                break;
            }
            case MS_TIC: {
                this.vars.curScan.setTic(val.toDouble());
                break;
            }
            case MS_SCAN_TYPE_FULL: {
                this.vars.curScan.setScanType(ScanType.FULL);
                break;
            }
            case MS_SCAN_TYPE_CRM: {
                this.vars.curScan.setScanType(ScanType.CRM);
                break;
            }
            case MS_SCAN_TYPE_SRM: {
                this.vars.curScan.setScanType(ScanType.CRM);
                break;
            }
            case MS_SCAN_TYPE_SIM: {
                this.vars.curScan.setScanType(ScanType.SIM);
                break;
            }
            case MS_SCAN_TYPE_ZOOM: {
                this.vars.curScan.setScanType(ScanType.ZOOM);
                break;
            }
            case MS_ION_INJECTION_TIME: {
                cvEntry = PSIMSCV.UO_MILLISECONDS;
                attr = attrs.getValue(ATTR.CV_PARAM_UNIT_ACCESSION.name);
                if (attr != null) {
                    cvEntry = PSIMSCV.fromAccession(attr.toString());
                }
                if (cvEntry == null) {
                    throw new FileParsingException(String.format("Unknown ion injection time units accession encountered: '%s', claims to be: '%s'", attr.toString(), attrs.getValue(ATTR.CV_PARAM_UNIT_NAME.name).toString()));
                }
                InjectionInfo injectionInfo = this.vars.curScan.getInjectionInfo();
                if (injectionInfo == null) {
                    injectionInfo = new InjectionInfo();
                    this.vars.curScan.setInjectionInfo(injectionInfo);
                }
                switch (cvEntry) {
                    case UO_MILLISECONDS: {
                        injectionInfo.setDuration(val.toDouble());
                        break;
                    }
                    case UO_MICROSECONDS: {
                        injectionInfo.setDuration(val.toDouble() / 1000.0);
                        break;
                    }
                    case UO_NANOSECONDS: {
                        injectionInfo.setDuration(val.toDouble() / 1000000.0);
                        break;
                    }
                    case UO_SECONDS: {
                        injectionInfo.setDuration(val.toDouble() * 1000.0);
                        break;
                    }
                    case UO_MINUTES: {
                        injectionInfo.setDuration(val.toDouble() * 60.0 * 1000.0);
                        break;
                    }
                    case UO_HOURS: {
                        injectionInfo.setDuration(val.toDouble() * 60.0 * 1000000.0);
                    }
                }
                break;
            }
            case MS_RT_SCAN_START: 
            case MS_RT_RETENTION_TIME: 
            case MS_RT_RETENTION_TIME_LOCAL: 
            case MS_RT_RETENTION_TIME_NORMALIZED: {
                cvEntry = PSIMSCV.UO_SECONDS;
                attr = attrs.getValue(ATTR.CV_PARAM_UNIT_ACCESSION.name);
                if (attr != null) {
                    cvEntry = PSIMSCV.fromAccession(attr.toString());
                }
                if (cvEntry == null) {
                    throw new FileParsingException(String.format("Unknown RT time units accession encountered: '%s', claims to be: '%s'", attr.toString(), attrs.getValue(ATTR.CV_PARAM_UNIT_NAME.name).toString()));
                }
                switch (cvEntry) {
                    case UO_SECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 60.0);
                        break block0;
                    }
                    case UO_MINUTES: {
                        this.vars.curScan.setRt(val.toDouble());
                        break block0;
                    }
                    case UO_HOURS: {
                        this.vars.curScan.setRt(val.toDouble() * 60.0);
                        break block0;
                    }
                    case UO_MILLISECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 1000.0 * 60.0);
                        break block0;
                    }
                    case UO_MICROSECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 1000000.0 * 60.0);
                        break block0;
                    }
                    case UO_NANOSECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 1.0E9 * 60.0);
                    }
                }
            }
        }
    }

    private void tagSpectrumStart(Attributes attrs) throws FileParsingException {
        ++this.numOpeningScanTagsFound;
        if (this.vars.curScan != null) {
            this.addCurScanAndFlushVars();
        }
        try {
            this.vars.spectrumIndex = attrs.getValue(ATTR.SPECTRUM_INDEX.name).toInt();
            this.vars.defaultArrayLength = attrs.getValue(ATTR.SPECTRUM_DEFAULT_ARRAY_LENGTH.name).toInt();
        }
        catch (NumberFormatException e) {
            throw new FileParsingException("One of the required attributes for <scan> was missing", e);
        }
        int scanNumInternal = this.mapRawNumToInternalScanNum(this.vars.spectrumIndex);
        this.vars.curScan = new ScanDefault(scanNumInternal);
    }

    public int findThisStreamFirstScanLen() throws FileParsingException {
        int length = -1;
        this.numOpeningScanTagsFound = 0;
        this.vars = new VarsHolder();
        XMLStreamReaderImpl reader = null;
        try {
            reader = this.readerPool == null ? new XMLStreamReaderImpl() : this.readerPool.borrowObject();
            reader.setInput(this.is, StandardCharsets.UTF_8.name());
            LogHelper.setJavolutionLogLevelFatal();
            int eventType = 8;
            block22: do {
                try {
                    eventType = reader.next();
                }
                catch (XMLStreamException e) {
                    if (e instanceof XMLUnexpectedEndTagException) continue;
                    if (e instanceof XMLUnexpectedEndOfDocumentException) {
                        int n = length;
                        if (this.readerPool != null && reader != null) {
                            try {
                                this.readerPool.returnObject(reader);
                            }
                            catch (Exception e2) {
                                throw new FileParsingException(e2);
                            }
                        }
                        return n;
                    }
                    throw new FileParsingException(e);
                }
                switch (eventType) {
                    case 1: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.equals(TAG.SPECTRUM.name)) break;
                        ++this.numOpeningScanTagsFound;
                        break;
                    }
                    case 2: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.equals(TAG.SPECTRUM.name) || this.numOpeningScanTagsFound != 1) continue block22;
                        int n = length = reader.getLocation().getCharacterOffset();
                        return n;
                    }
                }
            } while (eventType != 8);
        }
        catch (IOException | DataFormatException | XMLStreamException e) {
            throw new FileParsingException(e);
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
        finally {
            if (this.readerPool != null && reader != null) {
                try {
                    this.readerPool.returnObject(reader);
                }
                catch (Exception e) {
                    throw new FileParsingException(e);
                }
            }
        }
        return length;
    }

    /*
     * Exception decompiling
     */
    public IndexBuilder.Result<MZMLIndexElement> buildIndex(IndexBuilder.Info info) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addCurIndexElementAndFlushVars(IndexBuilder.Result<MZMLIndexElement> result, long offsetInFile, long offsetInBuffer) {
        if (this.vars.spectrumIndex == null || this.vars.spectrumId == null || this.vars.offset == null) {
            throw new IllegalStateException("When building index some variables were not set");
        }
        int len = this.vars.length != null ? this.vars.length : -1;
        OffsetLength offsetLength = new OffsetLength(offsetInFile + offsetInBuffer + this.vars.offset, len);
        MZMLIndexElement idxElem = new MZMLIndexElement(this.vars.spectrumIndex + 1, this.vars.spectrumIndex, this.vars.spectrumId, offsetLength);
        if (len != -1) {
            result.addIndexElement(idxElem);
        } else {
            result.addUnfinishedIndexElement(idxElem);
        }
        this.vars.resetToDefaults();
    }

    protected void addCurScanAndFlushVars() {
        if (!(this.vars.curScan == null || this.source.isExcludeEmptyScans() && this.vars.curScan.getSpectrum() != null && this.vars.curScan.getSpectrum().getMZs().length == 0)) {
            if (this.vars.precursors.size() > 1) {
                System.err.printf("Found multiple precursors for scan #%d, this is not really supported", this.vars.curScan.getNum());
            }
            if (this.vars.curScan.getInstrument() == null) {
                this.vars.curScan.setInstrument(this.runInfo.getDefaultInstrument());
            }
            this.parsedScans.add(this.vars.curScan);
        }
        this.vars.resetToDefaults();
    }

    protected boolean flushVarsIfNoCurScan() {
        if (this.vars.curScan == null) {
            this.vars.resetToDefaults();
            return true;
        }
        return false;
    }

    protected int mapIdRefToInternalScanNum(CharArray id) throws FileParsingException {
        String idStr = id.toString();
        MZMLIndexElement byId = (MZMLIndexElement)this.index.getById(idStr);
        if (byId == null) {
            String msg = String.format("Could not find a mapping from spectrum id ref to an internal scan number for\n\t file: %s\n\t spectrum index of the spectrum in which the error occured: #%d\n\t idRef searched for: %s", this.source.getPath(), this.vars.spectrumIndex, idStr);
            throw new FileParsingException(msg);
        }
        return byId.getNumber();
    }

    protected int mapRawNumToInternalScanNum(int spectrumIndex) throws FileParsingException {
        MZMLIndexElement byRawNum = (MZMLIndexElement)this.index.getByRawNum(spectrumIndex);
        if (byRawNum == null) {
            String msg = String.format("Could not find a mapping from spectrum index ref to an internal scan number for\n\t file: %s\n\t spectrum index searched for: #%d\n\t spectrum index of the spectrum in which the error occured: #%d", this.source.getPath(), spectrumIndex, this.vars.spectrumIndex);
            throw new FileParsingException(msg);
        }
        return byRawNum.getNumber();
    }

    protected boolean doesNeedSpectrumParsing(IScan scan) {
        return this.subset.isInSubset(scan);
    }

    public MZMLIndexBuilder getIndexBuilder(IndexBuilder.Info info) {
        return new MZMLIndexBuilder(info);
    }

    public class MZMLIndexBuilder
    implements IndexBuilder<MZMLIndexElement> {
        IndexBuilder.Info info;

        public MZMLIndexBuilder(IndexBuilder.Info info) {
            this.info = info;
        }

        @Override
        public IndexBuilder.Result<MZMLIndexElement> buildIndex(IndexBuilder.Info info) throws Exception {
            return MZMLMultiSpectraParser.this.buildIndex(info);
        }

        @Override
        public IndexBuilder.Result<MZMLIndexElement> call() throws Exception {
            return this.buildIndex(this.info);
        }
    }

    private static class VarsHolder {
        ScanDefault curScan;
        Integer defaultArrayLength;
        Integer spectrumIndex;
        String spectrumId;
        Integer precursorSpectrumIndex;
        String activationMethodAbbreviation;
        List<PrecursorInfo> precursors;
        Double precursorIsoWndTarget;
        Double precursorIsoWndLoOffset;
        Double precursorIsoWndHiOffset;
        Double precursorIntensity;
        Long offset;
        Integer length;
        Integer precision;
        EnumSet<PeaksCompression> compressions;
        BIN_DATA_TYPE binDataType;
        MZMLPeaksDecoder.DecodedData mzData;
        MZMLPeaksDecoder.DecodedData intensityData;

        public VarsHolder() {
            this.resetToDefaults();
        }

        public void flushBinDataDescription() {
            this.precision = null;
            this.compressions = null;
            this.binDataType = null;
        }

        public final void resetToDefaults() {
            this.curScan = null;
            this.defaultArrayLength = null;
            this.spectrumIndex = null;
            this.spectrumId = null;
            this.precursorSpectrumIndex = null;
            this.activationMethodAbbreviation = null;
            this.precursors = new ArrayList<PrecursorInfo>(1);
            this.precursorIsoWndTarget = null;
            this.precursorIsoWndLoOffset = null;
            this.precursorIsoWndHiOffset = null;
            this.precursorIntensity = null;
            this.offset = null;
            this.length = null;
            this.precision = null;
            this.compressions = null;
            this.binDataType = null;
            this.mzData = null;
            this.intensityData = null;
        }

        public EnumSet<PeaksCompression> getCompressions() {
            if (this.compressions == null) {
                this.compressions = EnumSet.noneOf(PeaksCompression.class);
            }
            return this.compressions;
        }

        public static enum BIN_DATA_TYPE {
            MZ,
            INTENSITY;

        }
    }

    protected static enum ATTR {
        SPECTRUM_INDEX("index", true),
        SPECTRUM_ID("id", true),
        SPECTRUM_INSTRUMENT("instrumentConfigurationRef", false),
        SPECTRUM_DEFAULT_ARRAY_LENGTH("defaultArrayLength", true),
        CV_PARAM_ACCESSION("accession", true),
        CV_PARAM_VALUE("value", true),
        CV_PARAM_UNIT_ACCESSION("unitAccession", true),
        CV_PARAM_UNIT_NAME("unitName", true),
        PRECURSOR_SPEC_REF("spectrumRef", false);

        public final String name;
        public final boolean isRequired;

        private ATTR(String name, boolean isRequired) {
            this.name = name;
            this.isRequired = isRequired;
        }
    }

    protected static enum TAG {
        SPECTRUM("spectrum"),
        CV_PARAM("cvParam"),
        SCAN_LIST("scanList"),
        SCAN("scan"),
        PRECURSOR_LIST("precursorList"),
        PRECURSOR("precursor"),
        SELECTED_ION_LIST("selectedIonList"),
        SELECTED_ION("selectedIon"),
        ACTIVATION("activation"),
        BINARY_DATA_LIST("binaryDataArrayList"),
        BINARY_DATA_ARRAY("binaryDataArray"),
        BINARY("binary");

        public final String name;
        public final CharArray charArray;

        private TAG(String name) {
            this.name = name;
            this.charArray = new CharArray(name);
        }
    }
}

